/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.sessionservice;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.ui.menu.IMenuItemProvider;
import org.eclipse.set.basis.Pair;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.model.tablemodel.extensions.TableExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableRowExtensions;
import org.eclipse.set.model.validationreport.ObjectState;
import org.eclipse.set.sessionservice.Messages;
import org.eclipse.set.utils.BasePart;
import org.eclipse.set.utils.events.JumpToSourceLineEvent;
import org.eclipse.set.utils.events.ToolboxEvent;
import org.eclipse.set.utils.table.TableDataProvider;
import org.eclipse.set.utils.table.menu.AbstractTableMenuService;

public class SetTableMenuService
extends AbstractTableMenuService {
    @Inject
    @Translation
    Messages messages;

    public Set<IMenuItemProvider> getMenuItems() {
        return this.menuItems;
    }

    public void createDefaultMenuItems(BasePart part, final Table table, final IDataProvider dataProvider, final SelectionLayer selectionLayer) {
        this.createShowInTextViewItem(this.messages.SetTableMenuService_TextView, (ToolboxEvent)new JumpToSourceLineEvent(part){

            /*
             * WARNING - void declaration
             */
            public Pair<ObjectState, Integer> getLineNumber() {
                Collection selectedCells = selectionLayer.getSelectedCells();
                if (selectedCells.isEmpty()) {
                    return new Pair(null, (Object)-1);
                }
                int rowPosition = ((ILayerCell)selectedCells.iterator().next()).getRowPosition();
                IDataProvider iDataProvider = dataProvider;
                if (iDataProvider instanceof TableDataProvider) {
                    void tableDataProvider;
                    TableDataProvider tableDataProvider2 = (TableDataProvider)iDataProvider;
                    TableDataProvider cfr_ignored_0 = (TableDataProvider)iDataProvider;
                    int originalRowIndex = tableDataProvider.getOriginalRowIndex(rowPosition);
                    if (originalRowIndex > -1) {
                        String objectState = tableDataProvider.getObjectState(rowPosition);
                        ObjectState state = ObjectState.get((String)objectState);
                        Integer lineNumber = tableDataProvider.getObjectSourceLine(originalRowIndex);
                        return new Pair((Object)state, (Object)lineNumber);
                    }
                }
                return new Pair(null, (Object)-1);
            }

            public String getObjectGuid() {
                Collection selectedCells = selectionLayer.getSelectedCells();
                if (selectedCells.isEmpty()) {
                    return null;
                }
                int rowPosition = ((ILayerCell)selectedCells.iterator().next()).getRowPosition();
                List tableRows = TableExtensions.getTableRows((Table)table);
                return TableRowExtensions.getLeadingObjectGuid((TableRow)((TableRow)tableRows.get(rowPosition)));
            }
        });
    }
}

