/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.application.parts;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.set.application.Messages;
import org.eclipse.set.basis.extensions.PathExtensions;
import org.eclipse.set.core.services.pdf.PdfRendererService;
import org.eclipse.set.core.services.pdf.PdfViewer;
import org.eclipse.set.core.services.pdf.PdfViewerPart;
import org.eclipse.set.utils.BasePart;
import org.eclipse.set.utils.SelectableAction;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class ViewPdfPart
extends BasePart
implements PdfViewerPart,
PdfViewer.SaveListener {
    @Optional
    @Inject
    private PdfRendererService rendererService;
    private PdfViewer viewer;
    @Inject
    @Translation
    Messages messages;

    @Inject
    public ViewPdfPart() {
    }

    public PdfViewer getViewer() {
        return this.viewer;
    }

    protected void createView(Composite parent) {
        String filename = (String)this.getToolboxPart().getTransientData().get("org.eclipse.set.application.commandparameter.file");
        final Path path = Paths.get(filename, new String[0]);
        this.getBanderole().setExportAction(new SelectableAction(){

            public String getText() {
                return ViewPdfPart.this.messages.ViewPdfPart_ExportButton;
            }

            public void selected(SelectionEvent e) {
                ViewPdfPart.this.export(path);
            }
        });
        if (this.rendererService != null) {
            this.viewer = this.rendererService.createViewer(parent);
            this.viewer.show(path);
            this.viewer.setSaveListener((PdfViewer.SaveListener)this);
        }
    }

    public java.util.Optional<Path> saveFile(String filename) {
        Shell shell = this.getToolboxShell();
        Path location = this.getModelSession().getToolboxFile().getPath();
        Path parent = location.getParent();
        String defaultPath = parent == null ? "" : parent.toString();
        String defaultFileName = String.format(filename, PathExtensions.getBaseFileName((Path)location));
        return this.getDialogService().saveFileDialog(shell, this.getDialogService().getDokumentFileFilters(), Paths.get(defaultPath, defaultFileName));
    }

    public void saveCompleted(Path path) {
        this.getDialogService().reportSavedFile(this.getToolboxShell(), path);
    }

    protected void export(Path source) {
        java.util.Optional optionalOutputDir = this.getDialogService().selectDirectory(this.getToolboxShell(), ToolboxConfiguration.getDefaultPath().toString());
        optionalOutputDir.ifPresent(outputDir -> {
            boolean overwrite;
            Path dest = Paths.get(outputDir, source.getFileName().toString());
            if (dest.toFile().exists() && !(overwrite = this.getDialogService().confirmOverwrite(this.getToolboxShell(), dest))) {
                return;
            }
            try {
                Files.copy(source, dest, StandardCopyOption.REPLACE_EXISTING);
                this.getDialogService().openDirectoryAfterExport(this.getToolboxShell(), Paths.get(outputDir, new String[0]));
            }
            catch (IOException e) {
                this.getDialogService().error(this.getToolboxShell(), this.messages.ViewPdfPart_ExportErrorTitle, String.format(this.messages.ViewPdfPart_ExportErrorText, dest.toString()), (Exception)e);
            }
        });
    }
}

