/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.application.cacheservice;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.set.application.cacheservice.CacheImpl;
import org.eclipse.set.basis.cache.Cache;
import org.eclipse.set.core.services.cache.CacheService;
import org.osgi.service.event.EventHandler;

public class CacheServiceImpl
implements CacheService {
    private IEventBroker broker;
    private final EventHandler modelChangedHandler = event -> this.invalidate();
    private final Map<String, Cache> caches = new HashMap<String, Cache>();

    public void setEventBroker(IEventBroker broker) {
        if (this.broker != null) {
            this.broker.unsubscribe(this.modelChangedHandler);
        }
        this.broker = broker;
        if (this.broker != null) {
            this.broker.subscribe("modelsession/change/model", this.modelChangedHandler);
        }
    }

    public Cache getCache(String cacheId) {
        this.caches.computeIfAbsent(cacheId, CacheImpl::new);
        return this.caches.get(cacheId);
    }

    public Cache getCache(String cacheId, String containerCacheId) throws IllegalArgumentException {
        String cacheKey = cacheId + "/" + containerCacheId;
        this.caches.computeIfAbsent(cacheKey, CacheImpl::new);
        return this.caches.get(cacheKey);
    }

    private void invalidate() {
        this.caches.values().forEach(Cache::invalidate);
    }
}

