/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.application.addons;

import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.IWindowCloseHandler;
import org.eclipse.set.application.Messages;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.core.services.dialog.DialogService;
import org.eclipse.swt.widgets.Shell;

public class WindowCloseAddon
implements IWindowCloseHandler {
    @Inject
    private DialogService dialogService;
    @Inject
    @Translation
    Messages messages;
    @Inject
    @Optional
    IModelSession modelSession;
    @Inject
    @Optional
    IWorkbench workbench;

    public boolean close(MWindow window) {
        Shell shell = (Shell)window.getContext().get(Shell.class);
        if (this.modelSession != null && this.modelSession.isDirty()) {
            if (this.dialogService.confirmCloseUnsaved(shell)) {
                this.close();
            }
            return false;
        }
        if (this.dialogService.confirmClose(shell)) {
            this.close();
        }
        return false;
    }

    private void close() {
        if (this.modelSession != null) {
            this.modelSession.cleanUp();
        }
        this.workbench.close();
    }

    @Inject
    @Optional
    private void startUpComplete(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/appStartupComplete") MApplication application, EModelService modelService) {
        MWindow window = (MWindow)modelService.find("planpro.mainwindow", (MUIElement)application);
        window.getContext().set(IWindowCloseHandler.class, (Object)this);
    }
}

