/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.table.abstracttableview;

import java.util.Set;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupHeaderLayer;
import org.eclipse.set.basis.tables.Tables;
import org.eclipse.set.feature.table.abstracttableview.ColumnGroup4HeaderLayer;
import org.eclipse.set.feature.table.abstracttableview.ColumnGroupGroupGroupHeaderLayer;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.extensions.ColumnDescriptorExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NatTableColumnGroupHelper {
    private static final Logger logger = LoggerFactory.getLogger(NatTableColumnGroupHelper.class);

    public static void addColumnNumbers(ColumnDescriptor header, ColumnGroup4HeaderLayer columnGroup4HeaderLayer) {
        int noOfcolumns = ColumnDescriptorExtensions.getColumns((ColumnDescriptor)header).length;
        int i = 0;
        while (i < noOfcolumns) {
            String label = Tables.getColumnIdentifier((int)i);
            columnGroup4HeaderLayer.addColumnsIndexesToGroup(label, i++);
        }
    }

    public static void addGroup4(ColumnDescriptor header, ColumnGroup4HeaderLayer columnGroup4HeaderLayer) {
        Set groups4 = ColumnDescriptorExtensions.getGroup4((ColumnDescriptor)header);
        for (ColumnDescriptor group4 : groups4) {
            int[] indices = ColumnDescriptorExtensions.getColumnIndices((ColumnDescriptor)group4);
            String group4Label = group4.getLabel();
            logger.info("Create group 4 {} with indices {}", (Object)group4Label, (Object)indices);
            columnGroup4HeaderLayer.addColumnsIndexesToGroup(group4Label, indices);
        }
    }

    public static void addGroupGroupGroups(ColumnDescriptor header, ColumnGroupGroupGroupHeaderLayer columnGroupGroupGroupHeaderLayer) {
        Set groupGroupGroups = ColumnDescriptorExtensions.getGroupGroupGroups((ColumnDescriptor)header);
        for (ColumnDescriptor groupGroupGroup : groupGroupGroups) {
            int[] indices = ColumnDescriptorExtensions.getColumnIndices((ColumnDescriptor)groupGroupGroup);
            String groupGroupGroupLabel = groupGroupGroup.getLabel();
            logger.info("Create group group group {} with indices {}", (Object)groupGroupGroupLabel, (Object)indices);
            columnGroupGroupGroupHeaderLayer.addColumnsIndexesToGroup(groupGroupGroupLabel, indices);
        }
    }

    public static void addGroupGroups(ColumnDescriptor header, ColumnGroupGroupHeaderLayer columnGroupGroupHeaderLayer) {
        Set groupGroups = ColumnDescriptorExtensions.getGroupGroups((ColumnDescriptor)header);
        for (ColumnDescriptor groupGroup : groupGroups) {
            int[] indices = ColumnDescriptorExtensions.getColumnIndices((ColumnDescriptor)groupGroup);
            String groupGroupLabel = groupGroup.getLabel();
            logger.info("Create group group {} with indices {}", (Object)groupGroupLabel, (Object)indices);
            columnGroupGroupHeaderLayer.addColumnsIndexesToGroup(groupGroupLabel, indices);
        }
    }

    public static void addGroups(ColumnDescriptor header, ColumnGroupHeaderLayer columnGroupHeaderLayer) {
        Set groups = ColumnDescriptorExtensions.getGroups((ColumnDescriptor)header);
        for (ColumnDescriptor group : groups) {
            int[] indices = ColumnDescriptorExtensions.getColumnIndices((ColumnDescriptor)group);
            String groupLabel = group.getLabel();
            logger.info("Create group {} with indices {}", (Object)groupLabel, (Object)indices);
            columnGroupHeaderLayer.addColumnsIndexesToGroup(groupLabel, indices);
        }
    }

    private NatTableColumnGroupHelper() {
    }
}

