/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.security;

import java.nio.ByteBuffer;
import org.eclipse.net4j.util.security.ChallengeResponseNegotiator;
import org.eclipse.net4j.util.security.INegotiationContext;
import org.eclipse.net4j.util.security.IPasswordCredentials;
import org.eclipse.net4j.util.security.IPasswordCredentialsProvider;
import org.eclipse.net4j.util.security.NegotiationException;
import org.eclipse.net4j.util.security.SecurityUtil;

public class ResponseNegotiator
extends ChallengeResponseNegotiator {
    private IPasswordCredentialsProvider credentialsProvider;

    public ResponseNegotiator() {
        super(false);
    }

    public IPasswordCredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public void setCredentialsProvider(IPasswordCredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    @Override
    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        if (this.credentialsProvider == null) {
            throw new IllegalStateException("credentialsProvider == null");
        }
    }

    @Override
    protected void handleChallenge(INegotiationContext context, ByteBuffer challenge, ByteBuffer response) {
        int size = challenge.getInt();
        byte[] randomToken = new byte[size];
        challenge.get(randomToken);
        IPasswordCredentials credentials = this.credentialsProvider.getCredentials();
        String userID = credentials.getUserID();
        context.setUserID(userID);
        byte[] userIDBytes = userID.getBytes();
        response.putInt(userIDBytes.length);
        response.put(userIDBytes);
        byte[] cryptedToken = this.encryptToken(credentials.getPassword(), randomToken);
        response.putInt(cryptedToken.length);
        response.put(cryptedToken);
    }

    @Override
    protected void handleAcknowledgement(INegotiationContext context, boolean success) {
        if (!success) {
            throw new NegotiationException("Negotiation failed");
        }
    }

    protected byte[] encryptToken(char[] password, byte[] token) {
        try {
            return SecurityUtil.pbeEncrypt(token, password, this.getEncryptionAlgorithmName(), this.getEncryptionSaltBytes(), this.getEncryptionIterationCount());
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }
}

