/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.container.delegate;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.net4j.util.collection.MapEntry;
import org.eclipse.net4j.util.container.ContainerEvent;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.container.delegate.AbstractDelegator;
import org.eclipse.net4j.util.container.delegate.ContainerCollection;
import org.eclipse.net4j.util.container.delegate.ContainerSet;
import org.eclipse.net4j.util.container.delegate.IContainerMap;
import org.eclipse.net4j.util.event.IListener;

public class ContainerMap<K, V>
extends AbstractDelegator<Map.Entry<K, V>>
implements IContainerMap<K, V> {
    private Map<K, V> delegate;

    public ContainerMap(Map<K, V> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Map<K, V> getDelegate() {
        return this.delegate;
    }

    @Override
    public void clear() {
        if (!this.isEmpty()) {
            ContainerEvent<Map.Entry<K, V>> event = this.createEvent(this.getDelegate().entrySet(), IContainerDelta.Kind.REMOVED);
            this.getDelegate().clear();
            IListener[] listeners = this.getListeners();
            if (listeners.length != 0) {
                this.fireEvent(event, listeners);
            }
        }
    }

    @Override
    public V put(K key, V value) {
        ContainerEvent<ContainerMapEntry<K, V>> event = new ContainerEvent<ContainerMapEntry<K, V>>(this);
        V removed = this.getDelegate().put(key, value);
        if (removed != null) {
            event.addDelta(new ContainerMapEntry<K, V>(key, removed), IContainerDelta.Kind.REMOVED);
        }
        event.addDelta(new ContainerMapEntry<K, V>(key, value), IContainerDelta.Kind.ADDED);
        IListener[] listeners = this.getListeners();
        if (listeners.length != 0) {
            this.fireEvent(event, listeners);
        }
        return removed;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        ContainerEvent<ContainerMapEntry<K, V>> event = new ContainerEvent<ContainerMapEntry<K, V>>(this);
        for (Map.Entry<K, V> entry : t.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            V removed = this.getDelegate().put(key, value);
            if (removed != null) {
                event.addDelta(new ContainerMapEntry<K, V>(key, removed), IContainerDelta.Kind.REMOVED);
            }
            event.addDelta(new ContainerMapEntry<K, V>(key, value), IContainerDelta.Kind.ADDED);
        }
        this.dispatchEvent(event);
    }

    @Override
    public V remove(Object key) {
        V removed = this.getDelegate().remove(key);
        if (removed != null) {
            this.fireRemovedEvent(new ContainerMapEntry<Object, V>(key, removed));
        }
        return removed;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getDelegate().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getDelegate().containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.getDelegate().get(key);
    }

    @Override
    public int size() {
        return this.getDelegate().size();
    }

    public Map.Entry<K, V>[] getElements() {
        return (Map.Entry[])this.getDelegate().entrySet().toArray();
    }

    @Override
    public boolean isEmpty() {
        return this.getDelegate().isEmpty();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new ContainerSet<Map.Entry<K, V>>(this.getDelegate().entrySet());
    }

    @Override
    public Set<K> keySet() {
        return new ContainerSet<K>(this.getDelegate().keySet());
    }

    @Override
    public Collection<V> values() {
        return new ContainerCollection<V>(this.getDelegate().values());
    }

    private static final class ContainerMapEntry<K, V>
    extends MapEntry<K, V> {
        public ContainerMapEntry(K key, V value) {
            super(key, value);
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }
}

