/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.container;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.container.ContainerEvent;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.container.SingleDeltaContainerEvent;

public abstract class ModifiableContainer<E>
extends Container<E>
implements IContainer.Modifiable<E> {
    private final Class<E> componentType;

    public ModifiableContainer(Class<E> componentType) {
        this.componentType = componentType;
    }

    public final Class<E> getComponentType() {
        return this.componentType;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.backingStoreIsEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E[] getElements() {
        Object[] array;
        ModifiableContainer modifiableContainer = this;
        synchronized (modifiableContainer) {
            Object[] a = (Object[])Array.newInstance(this.componentType, this.backingStoreSize());
            array = this.backingStoreToArray(a);
        }
        array = this.sortElements(array);
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addElement(E element) {
        if (!this.validateElement(element)) {
            return false;
        }
        SingleDeltaContainerEvent<E> event = null;
        ModifiableContainer modifiableContainer = this;
        synchronized (modifiableContainer) {
            if (this.backingStoreAdd(element)) {
                this.elementAdded(element);
                event = this.newContainerEvent(element, IContainerDelta.Kind.ADDED);
                this.notifyAll();
            }
        }
        if (event != null) {
            this.fireEvent(event);
            this.containerModified();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAllElements(Collection<E> elements) {
        ArrayList<E> validElements = new ArrayList<E>();
        for (E element : elements) {
            if (!this.validateElement(element)) continue;
            validElements.add(element);
        }
        ContainerEvent event = null;
        ModifiableContainer modifiableContainer = this;
        synchronized (modifiableContainer) {
            for (Object element : validElements) {
                if (!this.backingStoreAdd(element)) continue;
                this.elementAdded(element);
                if (event == null) {
                    event = this.newContainerEvent();
                }
                event.addDelta(element, IContainerDelta.Kind.ADDED);
            }
            if (event != null) {
                this.notifyAll();
            }
        }
        if (event != null) {
            this.fireEvent(event);
            this.containerModified();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeElement(E element) {
        SingleDeltaContainerEvent<E> event = null;
        ModifiableContainer modifiableContainer = this;
        synchronized (modifiableContainer) {
            if (this.backingStoreRemove(element)) {
                this.elementRemoved(element);
                event = this.newContainerEvent(element, IContainerDelta.Kind.REMOVED);
                this.notifyAll();
            }
        }
        if (event != null) {
            this.fireEvent(event);
            this.containerModified();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAllElements(Collection<E> elements) {
        ContainerEvent<E> event = null;
        ModifiableContainer modifiableContainer = this;
        synchronized (modifiableContainer) {
            for (E element : elements) {
                if (!this.backingStoreRemove(element)) continue;
                this.elementRemoved(element);
                if (event == null) {
                    event = this.newContainerEvent();
                }
                event.addDelta(element, IContainerDelta.Kind.REMOVED);
            }
            if (event != null) {
                this.notifyAll();
            }
        }
        if (event != null) {
            this.fireEvent(event);
            this.containerModified();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        ContainerEvent event = this.newContainerEvent();
        ModifiableContainer modifiableContainer = this;
        synchronized (modifiableContainer) {
            this.backingStoreForEach(element -> {
                if (this.backingStoreContains(element)) {
                    this.elementRemoved(element);
                    event.addDelta(element, IContainerDelta.Kind.REMOVED);
                }
            });
            this.backingStoreClear();
            if (event != null) {
                this.notifyAll();
            }
        }
        if (event != null) {
            this.fireEvent(event);
            this.containerModified();
        }
    }

    protected E[] sortElements(E[] array) {
        return array;
    }

    protected boolean validateElement(E element) {
        return true;
    }

    protected void containerModified() {
    }

    protected void elementAdded(E element) {
    }

    protected void elementRemoved(E element) {
    }

    protected abstract boolean backingStoreIsEmpty();

    protected abstract int backingStoreSize();

    protected abstract E[] backingStoreToArray(E[] var1);

    protected abstract void backingStoreForEach(Consumer<E> var1);

    protected abstract boolean backingStoreContains(E var1);

    protected abstract boolean backingStoreAdd(E var1);

    protected abstract boolean backingStoreRemove(E var1);

    protected abstract void backingStoreClear();
}

