/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.table.tree;

import com.google.common.collect.Iterables;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.RowGroup;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.model.tablemodel.extensions.RowGroupExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableRowExtensions;
import org.eclipse.set.model.validationreport.ValidationProblem;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.eclipse.set.utils.table.AbstractTableModelTransformator;
import org.eclipse.set.utils.table.TMFactory;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public abstract class AbstractValidationProblemTransformator<T>
extends AbstractTableModelTransformator<T> {
    private Set<ValidationProblem> listProblems = CollectionLiterals.newHashSet();

    @Override
    public Table transformTableContent(T report, final TMFactory factory) {
        Consumer<ValidationProblem> _function = new Consumer<ValidationProblem>(){

            @Override
            public void accept(ValidationProblem it) {
                AbstractValidationProblemTransformator.this.transformProblem(factory, it);
                AbstractValidationProblemTransformator.this.listProblems.add(it);
            }
        };
        this.getProblems(report).forEach(_function);
        this.instertTreeRootRow(factory);
        this.reGroupingTree(factory);
        return factory.getTable();
    }

    public abstract List<ValidationProblem> getProblems(T var1);

    protected void transformProblem(TMFactory factory, ValidationProblem problem) {
        TableRow instance = factory.newTableRow(problem.getId(), TableExtensions.getColumns((Table)factory.getTable()));
        this.fillProblem(instance, problem);
        RowGroup rowGroup = RowGroupExtensions.findRowGroup((Table)factory.getTable(), (TableRow)instance, this.getExcludeColumns());
        if (rowGroup != null) {
            rowGroup.getRows().add((Object)instance);
        } else {
            factory.newRowGroup(null).getRowGroup().getRows().add((Object)instance);
        }
    }

    public abstract void fillProblem(TableRow var1, ValidationProblem var2);

    protected void instertTreeRootRow(final TMFactory factory) {
        Functions.Function1<RowGroup, Boolean> _function = new Functions.Function1<RowGroup, Boolean>(){

            public Boolean apply(RowGroup it) {
                int _tableTreeMinimum;
                int _size = it.getRows().size();
                return _size >= (_tableTreeMinimum = ToolboxConfiguration.getTableTreeMinimum());
            }
        };
        Iterable rowGroups = IterableExtensions.filter((Iterable)factory.getTable().getTablecontent().getRowgroups(), (Functions.Function1)_function);
        Consumer<RowGroup> _function_1 = new Consumer<RowGroup>(){

            @Override
            public void accept(RowGroup group) {
                EList _rows = group.getRows();
                final List sortedRows = IterableExtensions.sortWith((Iterable)_rows, (Comparator)new Comparator<TableRow>(){

                    @Override
                    public int compare(TableRow r1, TableRow r2) {
                        return Integer.valueOf(r1.getRowIndex()).compareTo(r2.getRowIndex());
                    }
                });
                TableRow rootRow = factory.createGeneralGroupRow((TableRow)sortedRows.get(0), AbstractValidationProblemTransformator.this.getExcludeColumns());
                ColumnDescriptor _indexColumn = AbstractValidationProblemTransformator.this.getIndexColumn();
                StringConcatenation _builder = new StringConcatenation();
                int _rowIndex = ((TableRow)sortedRows.get(0)).getRowIndex();
                _builder.append((Object)_rowIndex);
                _builder.append("..");
                int _rowIndex_1 = ((TableRow)IterableExtensions.last((Iterable)sortedRows)).getRowIndex();
                _builder.append((Object)_rowIndex_1);
                TableRowExtensions.set((TableRow)rootRow, (ColumnDescriptor)_indexColumn, (String)_builder.toString());
                Functions.Function1<ValidationProblem, Boolean> _function = new Functions.Function1<ValidationProblem, Boolean>(){

                    public Boolean apply(ValidationProblem it) {
                        int _rowIndex;
                        int _id = it.getId();
                        return _id == (_rowIndex = ((TableRow)sortedRows.get(0)).getRowIndex());
                    }
                };
                ValidationProblem _findFirst = (ValidationProblem)IterableExtensions.findFirst(AbstractValidationProblemTransformator.this.listProblems, (Functions.Function1)_function);
                String _generalMsg = null;
                if (_findFirst != null) {
                    _generalMsg = _findFirst.getGeneralMsg();
                }
                String generalErroMsg = _generalMsg;
                TableRowExtensions.set((TableRow)rootRow, (ColumnDescriptor)AbstractValidationProblemTransformator.this.getMessagesColumn(), (String)generalErroMsg);
                group.getRows().add(0, (Object)rootRow);
            }
        };
        rowGroups.forEach(_function_1);
    }

    protected void reGroupingTree(final TMFactory factory) {
        EList tableRowGroups = factory.getTable().getTablecontent().getRowgroups();
        Functions.Function1<RowGroup, Boolean> _function = new Functions.Function1<RowGroup, Boolean>(){

            public Boolean apply(RowGroup it) {
                return it.getRows().size() < ToolboxConfiguration.getTableTreeMinimum() && it.getRows().size() > 1;
            }
        };
        Iterable extractRowGroups = IterableExtensions.filter((Iterable)tableRowGroups, (Functions.Function1)_function);
        Functions.Function1<RowGroup, List<TableRow>> _function_1 = new Functions.Function1<RowGroup, List<TableRow>>(){

            public List<TableRow> apply(RowGroup it) {
                return it.getRows().subList(1, it.getRows().size());
            }
        };
        Set rows = IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)extractRowGroups, (Functions.Function1)_function_1)));
        Consumer<TableRow> _function_2 = new Consumer<TableRow>(){

            @Override
            public void accept(TableRow row) {
                RowGroup newGroup = factory.getRowGroup();
                newGroup.getRows().add((Object)row);
            }
        };
        rows.forEach(_function_2);
    }

    public abstract List<ColumnDescriptor> getExcludeColumns();

    public abstract ColumnDescriptor getIndexColumn();

    public abstract ColumnDescriptor getMessagesColumn();
}

