/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.table.sorting;

import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.List;
import org.eclipse.set.basis.tables.Tables;
import org.eclipse.set.model.tablemodel.RowGroup;
import org.eclipse.set.model.tablemodel.TableCell;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.utils.table.sorting.ComparatorBuilder;
import org.eclipse.set.utils.table.sorting.CompareColumnCriterion;
import org.eclipse.set.utils.table.sorting.CompareTypesCriterion;

public final class TableRowGroupComparator
implements Comparator<RowGroup> {
    private final List<Comparator<TableRow>> criteria = Lists.newLinkedList();

    public static ComparatorBuilder builder() {
        return new ComparatorBuilder(new TableRowGroupComparator());
    }

    private TableRowGroupComparator() {
    }

    public void addCriterion(List<Class<?>> list) {
        this.criteria.add(new CompareTypesCriterion(list));
    }

    public void addCriterion(String columnId, Comparator<TableCell> cellComparator) {
        this.criteria.add(new CompareColumnCriterion(Tables.getColumnIndex((String)columnId), cellComparator));
    }

    public void addCriterion(int columnIndex, Comparator<TableCell> cellComparator) {
        this.criteria.add(new CompareColumnCriterion(columnIndex, cellComparator));
    }

    @Override
    public int compare(RowGroup group1, RowGroup group2) {
        if (group1.getRows().isEmpty()) {
            if (group2.getRows().isEmpty()) {
                return 0;
            }
            return -1;
        }
        if (group2.getRows().isEmpty()) {
            return 1;
        }
        TableRow row1 = (TableRow)group1.getRows().get(0);
        TableRow row2 = (TableRow)group2.getRows().get(0);
        for (Comparator<TableRow> criterion : this.criteria) {
            int result = criterion.compare(row1, row2);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }
}

