/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.table.menu;

import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.ui.menu.IMenuItemProvider;
import org.eclipse.set.core.services.part.ToolboxPartService;
import org.eclipse.set.utils.events.ToolboxEvent;
import org.eclipse.set.utils.events.ToolboxEvents;
import org.eclipse.set.utils.table.menu.TableBodyMenuConfiguration;
import org.eclipse.set.utils.table.menu.TableMenuService;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.MenuItem;

public abstract class AbstractTableMenuService
implements TableMenuService {
    private static final String SOURCE_TEXT_VIEWER_PART_ID = "org.eclipse.set.application.descriptions.SourceWebTextViewDescriptionService";
    @Inject
    ToolboxPartService toolboxPartService;
    @Inject
    protected IEventBroker broker;
    protected Set<IMenuItemProvider> menuItems = new HashSet<IMenuItemProvider>();
    protected TableBodyMenuConfiguration tableBodyMenuConfiguration;

    @Override
    public TableBodyMenuConfiguration createMenuConfiguration(NatTable natTable, SelectionLayer selectionLayer) {
        this.tableBodyMenuConfiguration = new TableBodyMenuConfiguration(natTable, selectionLayer, this.menuItems);
        return this.tableBodyMenuConfiguration;
    }

    protected void createShowInTextViewItem(String label, final ToolboxEvent toolboxEvent) {
        this.menuItems.add(this.createMenuItem(label, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AbstractTableMenuService.this.tableBodyMenuConfiguration.selectionLayer.getSelectedCells().isEmpty()) {
                    return;
                }
                AbstractTableMenuService.this.toolboxPartService.showPart(AbstractTableMenuService.SOURCE_TEXT_VIEWER_PART_ID);
                ToolboxEvents.send((IEventBroker)AbstractTableMenuService.this.broker, (ToolboxEvent)toolboxEvent);
            }
        }));
    }

    @Override
    public IMenuItemProvider createMenuItem(String label, SelectionListener selectionListener) {
        return (natTable, popupMenu) -> {
            MenuItem menuItem = new MenuItem(popupMenu, 8);
            menuItem.setText(label);
            menuItem.setEnabled(true);
            menuItem.addSelectionListener(selectionListener);
        };
    }

    @Override
    public void addMenuItem(IMenuItemProvider menuItem) {
        this.menuItems.add(menuItem);
    }
}

