/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.table;

import com.google.common.base.Throwables;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.MultiColorContent;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.model.tablemodel.extensions.TableRowExtensions;
import org.eclipse.set.ppmodel.extensions.utils.Case;
import org.eclipse.set.ppmodel.extensions.utils.Debug;
import org.eclipse.set.toolboxmodel.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Ur_Objekt;
import org.eclipse.set.toolboxmodel.Regelzeichnung.Bild_TypeClass;
import org.eclipse.set.toolboxmodel.Regelzeichnung.RZ_Nummer_TypeClass;
import org.eclipse.set.toolboxmodel.Regelzeichnung.Regelzeichnung;
import org.eclipse.set.toolboxmodel.Regelzeichnung.Regelzeichnung_Allg_AttributeGroup;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.eclipse.set.utils.table.TableError;
import org.eclipse.set.utils.table.TableModelTransformator;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTableModelTransformator<T>
implements TableModelTransformator<T> {
    private static final String NOT_FILLED = "n.b.";
    private static final Logger logger = LoggerFactory.getLogger(AbstractTableModelTransformator.class);
    protected static final String ITERABLE_FILLING_SEPARATOR = String.format("%n", new Object[0]);
    private static final boolean DEVELOPMENT_MODE = ToolboxConfiguration.isDevelopmentMode();
    private static final String BLANK = "";
    private final List<TableError> tableErrors = CollectionLiterals.newArrayList();

    @Override
    public Collection<TableError> getTableErrors() {
        return this.tableErrors;
    }

    public String toDo() {
        if (DEVELOPMENT_MODE) {
            throw new UnsupportedOperationException("to do");
        }
        return NOT_FILLED;
    }

    public String futureVersion() {
        if (DEVELOPMENT_MODE) {
            throw new UnsupportedOperationException("future Version");
        }
        return NOT_FILLED;
    }

    public String noTestData() {
        if (DEVELOPMENT_MODE) {
            throw new UnsupportedOperationException("no test data");
        }
        return NOT_FILLED;
    }

    public String toBeSpecified() {
        if (DEVELOPMENT_MODE) {
            throw new UnsupportedOperationException("to be specified");
        }
        return NOT_FILLED;
    }

    public <T> void fill(TableRow row, ColumnDescriptor column, T object, Functions.Function1<? super T, ? extends String> filling) {
        try {
            String text = (String)filling.apply(object);
            if (text != null) {
                TableRowExtensions.set((TableRow)row, (ColumnDescriptor)column, (String)text);
            } else {
                TableRowExtensions.set((TableRow)row, (ColumnDescriptor)column, (String)BLANK);
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                this.handleFillingException(e, row, column);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public <T> void fillNumeric(TableRow row, ColumnDescriptor column, final T object, final Functions.Function1<? super T, ? extends Number> filling) {
        Functions.Function1 _function = new Functions.Function1<T, String>(){

            public String apply(T it) {
                Number _apply = (Number)filling.apply(object);
                String _string = null;
                if (_apply != null) {
                    _string = _apply.toString();
                }
                return _string;
            }
        };
        this.fill(row, column, object, _function);
    }

    public <T> void fillMultiColor(TableRow row, ColumnDescriptor column, T object, Functions.Function1<? super T, ? extends MultiColorContent> fillMultiColorContent) {
        MultiColorContent multicolorContent = (MultiColorContent)fillMultiColorContent.apply(object);
        try {
            if (multicolorContent != null && multicolorContent.getStringFormat() != null) {
                TableRowExtensions.set((TableRow)row, (ColumnDescriptor)column, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new MultiColorContent[]{multicolorContent})), (String)BLANK);
            } else {
                TableRowExtensions.set((TableRow)row, (ColumnDescriptor)column, (String)BLANK);
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                this.handleFillingException(e, row, column);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public <T> void fillConditional(TableRow row, ColumnDescriptor column, T object, Functions.Function1<? super T, ? extends Boolean> condition, Functions.Function1<? super T, ? extends String> filling) {
        try {
            boolean _booleanValue = (Boolean)condition.apply(object);
            if (_booleanValue) {
                this.fill(row, column, object, filling);
            } else {
                TableRowExtensions.set((TableRow)row, (ColumnDescriptor)column, (String)BLANK);
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                this.handleFillingException(e, row, column);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public <T> void fillConditional(TableRow row, ColumnDescriptor column, T object, Functions.Function1<? super T, ? extends Boolean> condition, Functions.Function1<? super T, ? extends String> fillingIfTrue, Functions.Function1<? super T, ? extends String> fillingIfFalse) {
        try {
            boolean _booleanValue = (Boolean)condition.apply(object);
            if (_booleanValue) {
                this.fill(row, column, object, fillingIfTrue);
            } else {
                this.fill(row, column, object, fillingIfFalse);
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                this.handleFillingException(e, row, column);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public <T> void fillSwitch(TableRow row, ColumnDescriptor column, T object, Case<T> ... cases) {
        try {
            Iterable content;
            Case<T> switchCase = this.getSwitchCase(object, cases);
            Functions.Function1 _filling = null;
            if (switchCase != null) {
                _filling = switchCase.filling;
            }
            Iterable _apply = null;
            if (_filling != null) {
                _apply = (Iterable)_filling.apply(object);
            }
            if ((content = _apply) == null || IterableExtensions.isEmpty((Iterable)content)) {
                TableRowExtensions.set((TableRow)row, (ColumnDescriptor)column, (String)BLANK);
            } else {
                boolean _tripleEquals;
                int _size = IterableExtensions.size((Iterable)content);
                boolean bl = _tripleEquals = _size == 1;
                if (_tripleEquals) {
                    Functions.Function1 _function = new Functions.Function1<T, String>(){

                        public String apply(T it) {
                            return ((String[])Conversions.unwrapArray((Object)content, String.class))[0];
                        }
                    };
                    this.fill(row, column, object, _function);
                } else {
                    Functions.Function1 _function_1 = new Functions.Function1<T, Iterable<String>>(){

                        public Iterable<String> apply(T it) {
                            return content;
                        }
                    };
                    Functions.Function1<String, String> _function_2 = new Functions.Function1<String, String>(){

                        public String apply(String it) {
                            return it;
                        }
                    };
                    String _xifexpression = null;
                    _xifexpression = switchCase.seperator == null ? ITERABLE_FILLING_SEPARATOR : switchCase.seperator;
                    this.fillIterable(row, column, object, _function_1, switchCase.comparator, _function_2, _xifexpression);
                }
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                this.handleFillingException(e, row, column);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public <T> Case<T> getSwitchCase(T object, Case<T> ... cases) {
        Case<T>[] caseArray = cases;
        int n = cases.length;
        int n2 = 0;
        while (n2 < n) {
            Case<T> c = caseArray[n2];
            Boolean condition = (Boolean)c.condition.apply(object);
            if (condition != null && condition.booleanValue()) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    public <S, T> void fillIterable(TableRow row, ColumnDescriptor column, S object, Functions.Function1<? super S, ? extends Iterable<String>> sequence, Comparator<String> comparator) {
        Functions.Function1<String, String> _function = new Functions.Function1<String, String>(){

            public String apply(String it) {
                return it;
            }
        };
        this.fillIterable(row, column, object, sequence, comparator, _function);
    }

    public <S, T> void fillMultiColorIterable(TableRow row, ColumnDescriptor column, S object, Functions.Function1<? super S, ? extends List<MultiColorContent>> sequence) {
        this.fillMultiColorIterable(row, column, object, sequence, ITERABLE_FILLING_SEPARATOR);
    }

    public <S> void fillMultiColorIterable(TableRow row, ColumnDescriptor column, S object, Functions.Function1<? super S, ? extends List<MultiColorContent>> sequence, String separator) {
        try {
            boolean _not;
            List list = (List)sequence.apply(object);
            boolean _isEmpty = list.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                TableRowExtensions.set((TableRow)row, (ColumnDescriptor)column, (List)list, (String)separator);
            } else {
                Functions.Function1 _function = new Functions.Function1<S, String>(){

                    public String apply(S it) {
                        return null;
                    }
                };
                this.fill(row, column, object, _function);
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                this.handleFillingException(e, row, column);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public <S, T> void fillIterable(TableRow row, ColumnDescriptor column, S object, Functions.Function1<? super S, ? extends Iterable<T>> sequence, Comparator<T> comparator, Functions.Function1<? super T, ? extends String> elementFilling) {
        this.fillIterable(row, column, object, sequence, comparator, elementFilling, ITERABLE_FILLING_SEPARATOR);
    }

    public <S, T> void fillIterable(TableRow row, ColumnDescriptor column, S object, Functions.Function1<? super S, ? extends Iterable<T>> sequence, Comparator<T> comparator, Functions.Function1<? super T, ? extends String> elementFilling, String separator) {
        Functions.Function1 _function = new Functions.Function1<S, Boolean>(){

            public Boolean apply(S it) {
                return true;
            }
        };
        Functions.Function1 _function_1 = new Functions.Function1<S, String>(){

            public String apply(S it) {
                return null;
            }
        };
        this.fillIterableWithSeparatorConditional(row, column, object, _function, sequence, comparator, elementFilling, _function_1, separator);
    }

    public <S, T> void fillIterableWithConditional(TableRow row, ColumnDescriptor column, S object, Functions.Function1<? super S, ? extends Boolean> condition, Functions.Function1<? super S, ? extends Iterable<String>> sequenceIfTrue, Comparator<String> comparator, String separtor) {
        Functions.Function1 _function = new Functions.Function1<S, String>(){

            public String apply(S it) {
                return null;
            }
        };
        this.fillIterableWithSeparatorConditional(row, column, object, condition, sequenceIfTrue, comparator, _function, separtor);
    }

    public <S, T> void fillIterableWithSeparatorConditional(TableRow row, ColumnDescriptor column, S object, Functions.Function1<? super S, ? extends Boolean> condition, Functions.Function1<? super S, ? extends Iterable<String>> sequenceIfTrue, Comparator<String> comparator, Functions.Function1<? super S, ? extends String> fillingIfFalse, String separator) {
        Functions.Function1<String, String> _function = new Functions.Function1<String, String>(){

            public String apply(String it) {
                return it;
            }
        };
        this.fillIterableWithSeparatorConditional(row, column, object, condition, sequenceIfTrue, comparator, _function, fillingIfFalse, separator);
    }

    public <S, T> void fillIterableWithSeparatorConditional(TableRow row, ColumnDescriptor column, S object, Functions.Function1<? super S, ? extends Boolean> condition, Functions.Function1<? super S, ? extends Iterable<T>> sequenceIfTrue, Comparator<T> comparator, Functions.Function1<? super T, ? extends String> elementFilling, Functions.Function1<? super S, ? extends String> fillingIfFalse, String separator) {
        try {
            boolean _booleanValue = (Boolean)condition.apply(object);
            if (_booleanValue) {
                Iterable list = IterableExtensions.filterNull((Iterable)ListExtensions.map((List)IterableExtensions.sortWith((Iterable)IterableExtensions.filterNull((Iterable)((Iterable)sequenceIfTrue.apply(object))), comparator), elementFilling));
                TableRowExtensions.set((TableRow)row, (ColumnDescriptor)column, (Iterable)list, (String)separator);
            } else {
                this.fill(row, column, object, fillingIfFalse);
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                this.handleFillingException(e, row, column);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public static String fillRegelzeichnung(Regelzeichnung regelzeichnung) {
        String rzNummer;
        Regelzeichnung_Allg_AttributeGroup _regelzeichnungAllg = null;
        if (regelzeichnung != null) {
            _regelzeichnungAllg = regelzeichnung.getRegelzeichnungAllg();
        }
        Bild_TypeClass _bild = null;
        if (_regelzeichnungAllg != null) {
            _bild = _regelzeichnungAllg.getBild();
        }
        Bild_TypeClass bild = _bild;
        Regelzeichnung_Allg_AttributeGroup _regelzeichnungAllg_1 = null;
        if (regelzeichnung != null) {
            _regelzeichnungAllg_1 = regelzeichnung.getRegelzeichnungAllg();
        }
        RZ_Nummer_TypeClass _rZNummer = null;
        if (_regelzeichnungAllg_1 != null) {
            _rZNummer = _regelzeichnungAllg_1.getRZNummer();
        }
        String _wert = null;
        if (_rZNummer != null) {
            _wert = _rZNummer.getWert();
        }
        if ((rzNummer = _wert) == null) {
            rzNummer = "null";
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(rzNummer);
        if (bild != null) {
            _builder.append(" (");
            String _wert_1 = bild.getWert();
            _builder.append(_wert_1);
            _builder.append(")");
        }
        return _builder.toString();
    }

    public static String getIterableFilling(Iterable<String> sequence) {
        return AbstractTableModelTransformator.getIterableFilling(sequence, null, ITERABLE_FILLING_SEPARATOR);
    }

    public static String getIterableFilling(Iterable<String> sequence, Comparator<String> comparator) {
        return AbstractTableModelTransformator.getIterableFilling(sequence, comparator, ITERABLE_FILLING_SEPARATOR);
    }

    public static String getIterableFilling(Iterable<String> sequence, Comparator<String> comparator, String separator) {
        StringConcatenation _builder = new StringConcatenation();
        List _sortWith = IterableExtensions.sortWith(sequence, comparator);
        boolean _hasElements = false;
        for (String element : _sortWith) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)separator, BLANK);
            }
            _builder.append(element);
        }
        return _builder.toString();
    }

    private void _handleFillingException(Exception e, TableRow row, ColumnDescriptor column) {
        StringConcatenation _builder = new StringConcatenation();
        String _simpleName = e.getClass().getSimpleName();
        _builder.append(_simpleName);
        _builder.append(": \"");
        String _message = e.getMessage();
        _builder.append(_message);
        _builder.append("\" for leading object ");
        Ur_Objekt _leadingObject = TableRowExtensions.getGroup((TableRow)row).getLeadingObject();
        Identitaet_TypeClass _identitaet = null;
        if (_leadingObject != null) {
            _identitaet = _leadingObject.getIdentitaet();
        }
        String _wert = null;
        if (_identitaet != null) {
            _wert = _identitaet.getWert();
        }
        _builder.append(_wert);
        String errorMsg = _builder.toString();
        Ur_Objekt _leadingObject_1 = TableRowExtensions.getGroup((TableRow)row).getLeadingObject();
        Identitaet_TypeClass _identitaet_1 = null;
        if (_leadingObject_1 != null) {
            _identitaet_1 = _leadingObject_1.getIdentitaet();
        }
        String _wert_1 = null;
        if (_identitaet_1 != null) {
            _wert_1 = _identitaet_1.getWert();
        }
        TableError _tableError = new TableError(_wert_1, BLANK, errorMsg);
        this.tableErrors.add(_tableError);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Error: ");
        _builder_1.append(errorMsg);
        TableRowExtensions.set((TableRow)row, (ColumnDescriptor)column, (String)_builder_1.toString());
        StringConcatenation _builder_2 = new StringConcatenation();
        String _simpleName_1 = e.getClass().getSimpleName();
        _builder_2.append(_simpleName_1);
        _builder_2.append(" in column \"");
        String _debugString = Debug.debugString((Object)column);
        _builder_2.append(_debugString);
        _builder_2.append("\" for leading object ");
        Ur_Objekt _leadingObject_2 = TableRowExtensions.getGroup((TableRow)row).getLeadingObject();
        Identitaet_TypeClass _identitaet_2 = null;
        if (_leadingObject_2 != null) {
            _identitaet_2 = _leadingObject_2.getIdentitaet();
        }
        String _wert_2 = null;
        if (_identitaet_2 != null) {
            _wert_2 = _identitaet_2.getWert();
        }
        _builder_2.append(_wert_2);
        _builder_2.append(". ");
        String _message_1 = e.getMessage();
        _builder_2.append(_message_1);
        String _lineSeparator = System.lineSeparator();
        _builder_2.append(_lineSeparator);
        String _stackTraceAsString = Throwables.getStackTraceAsString((Throwable)e);
        _builder_2.append(_stackTraceAsString);
        logger.error(_builder_2.toString());
    }

    private void _handleFillingException(UnsupportedOperationException e, TableRow row, ColumnDescriptor column) {
        StringConcatenation _builder = new StringConcatenation();
        String _message = e.getMessage();
        _builder.append(_message);
        _builder.append(" for leading object ");
        Ur_Objekt _leadingObject = TableRowExtensions.getGroup((TableRow)row).getLeadingObject();
        Identitaet_TypeClass _identitaet = null;
        if (_leadingObject != null) {
            _identitaet = _leadingObject.getIdentitaet();
        }
        String _wert = null;
        if (_identitaet != null) {
            _wert = _identitaet.getWert();
        }
        _builder.append(_wert);
        String errorMsg = _builder.toString();
        Ur_Objekt _leadingObject_1 = TableRowExtensions.getGroup((TableRow)row).getLeadingObject();
        Identitaet_TypeClass _identitaet_1 = null;
        if (_leadingObject_1 != null) {
            _identitaet_1 = _leadingObject_1.getIdentitaet();
        }
        String _wert_1 = null;
        if (_identitaet_1 != null) {
            _wert_1 = _identitaet_1.getWert();
        }
        TableError _tableError = new TableError(_wert_1, BLANK, errorMsg);
        this.tableErrors.add(_tableError);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Error: ");
        _builder_1.append(errorMsg);
        TableRowExtensions.set((TableRow)row, (ColumnDescriptor)column, (String)_builder_1.toString());
        StringConcatenation _builder_2 = new StringConcatenation();
        String _simpleName = e.getClass().getSimpleName();
        _builder_2.append(_simpleName);
        _builder_2.append(" in column \"");
        String _debugString = Debug.debugString((Object)column);
        _builder_2.append(_debugString);
        _builder_2.append("\". ");
        String _message_1 = e.getMessage();
        _builder_2.append(_message_1);
        String _lineSeparator = System.lineSeparator();
        _builder_2.append(_lineSeparator);
        String _stackTraceAsString = Throwables.getStackTraceAsString((Throwable)e);
        _builder_2.append(_stackTraceAsString);
        logger.error(_builder_2.toString());
    }

    public static <T> String sortEvaluation(T value, Functions.Function1<? super T, ? extends String> valueToString) {
        String result;
        block3: {
            result = "ZZZZZ";
            try {
                result = (String)valueToString.apply(value);
                if (result == null) {
                    result = BLANK;
                }
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) break block3;
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return result;
    }

    public <T> void fillBlank(TableRow row, int column) {
        TableRowExtensions.set((TableRow)row, (int)column, (String)BLANK);
    }

    private void handleFillingException(Exception e, TableRow row, ColumnDescriptor column) {
        if (e instanceof UnsupportedOperationException) {
            this._handleFillingException((UnsupportedOperationException)e, row, column);
            return;
        }
        if (e != null) {
            this._handleFillingException(e, row, column);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(e, row, column).toString());
    }
}

