/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.model.tablemodel.extensions;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.model.tablemodel.TableCell;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.model.tablemodel.extensions.CellContentExtensions;
import org.eclipse.set.model.tablemodel.extensions.ColumnDescriptorExtensions;
import org.eclipse.set.model.tablemodel.format.CellFormat;
import org.eclipse.set.model.tablemodel.format.TableformatFactory;
import org.eclipse.set.model.tablemodel.format.TextAlignment;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class TableCellExtensions {
    public static String getRichTextValue(TableCell cell) {
        return CellContentExtensions.getRichTextValue(cell.getContent());
    }

    public static String getPlainStringValue(TableCell cell) {
        return CellContentExtensions.getPlainStringValue(cell.getContent());
    }

    public static Set<String> getIterableStringValue(TableCell cell) {
        return IterableExtensions.toSet(CellContentExtensions.getStringValueIterable(cell.getContent()));
    }

    public static boolean isEqual(TableCell cell, TableCell other) {
        return ColumnDescriptorExtensions.isEqual(cell.getColumndescriptor(), other.getColumndescriptor()) && CellContentExtensions.isEqual(cell.getContent(), other.getContent());
    }

    public static TableRow getTableRow(TableCell cell) {
        EObject _eContainer = cell.eContainer();
        return (TableRow)_eContainer;
    }

    public static int getColumnNumber(TableCell cell) {
        int _indexOf = TableCellExtensions.getTableRow(cell).getCells().indexOf((Object)cell);
        return _indexOf + 1;
    }

    public static void setTextAlignment(TableCell cell, TextAlignment textAlignment) {
        CellFormat _format = TableCellExtensions.getFormat(cell);
        _format.setTextAlignment(textAlignment);
    }

    public static CellFormat getFormat(TableCell cell) {
        int _size_1;
        boolean _notEquals;
        boolean _equals;
        List results = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)cell.getCellannotation(), CellFormat.class));
        int _size = results.size();
        boolean bl = _equals = _size == 0;
        if (_equals) {
            CellFormat newCellFormat = TableformatFactory.eINSTANCE.createCellFormat();
            cell.getCellannotation().add((Object)newCellFormat);
            results.add(newCellFormat);
        }
        boolean bl2 = _notEquals = (_size_1 = results.size()) != 1;
        if (_notEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Ambiguous cell formats in ");
            _builder.append((Object)cell);
            _builder.append(".");
            throw new IllegalArgumentException(_builder.toString());
        }
        return (CellFormat)results.get(0);
    }
}

