/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.text;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.set.basis.Wrapper;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DescriptionToResourceTransformation {
    private static final Logger LOGGER = LoggerFactory.getLogger(DescriptionToResourceTransformation.class);
    private final ResourceManager resourceManager;
    private final HashMap<ArrayList<?>, Wrapper<Font>> _createCache_transformToFont = CollectionLiterals.newHashMap();

    public DescriptionToResourceTransformation(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public TextAttribute transformToTextAttribute(String description) {
        try {
            String[] parts = this.transformToParts(description);
            return this.transformToTextAttribute(parts);
        }
        catch (Throwable _t) {
            if (_t instanceof NoSuchFieldException) {
                NoSuchFieldException e = (NoSuchFieldException)_t;
                return DescriptionToResourceTransformation.handleTextAttribute(e);
            }
            if (_t instanceof IllegalAccessException) {
                IllegalAccessException e_1 = (IllegalAccessException)_t;
                return DescriptionToResourceTransformation.handleTextAttribute(e_1);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public Font transformToFont(String description) {
        try {
            String[] parts = this.transformToParts(description);
            return this.transformToFont(parts);
        }
        catch (Throwable _t) {
            if (_t instanceof NoSuchFieldException) {
                NoSuchFieldException e = (NoSuchFieldException)_t;
                return DescriptionToResourceTransformation.handleFont(e);
            }
            if (_t instanceof IllegalAccessException) {
                IllegalAccessException e_1 = (IllegalAccessException)_t;
                return DescriptionToResourceTransformation.handleFont(e_1);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private String[] transformToParts(String description) {
        return description.split(",");
    }

    private TextAttribute transformToTextAttribute(String[] parts) throws NoSuchFieldException, IllegalAccessException {
        Color foreground = this.transformToForeground(parts);
        Color background = this.transformToBackground(parts);
        int style = this.transformToStyle(parts);
        return new TextAttribute(foreground, background, style);
    }

    private Color transformToForeground(String[] parts) throws NoSuchFieldException, IllegalAccessException {
        return this.transformToColor(parts[0]);
    }

    private Color transformToBackground(String[] parts) throws NoSuchFieldException, IllegalAccessException {
        return this.transformToColor(parts[1]);
    }

    private int transformToStyle(String[] parts) throws NoSuchFieldException, IllegalAccessException {
        String styleAttribute = parts[2].toUpperCase();
        return SWT.class.getField(styleAttribute).getInt(null);
    }

    private Font transformToFont(String[] parts) throws NoSuchFieldException, IllegalAccessException {
        int height = Integer.parseInt(parts[1]);
        String styleAttribute = parts[2].toUpperCase();
        int style = SWT.class.getField(styleAttribute).getInt(null);
        return (Font)this.transformToFont(parts[0], height, style).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Wrapper<Font> transformToFont(String name, int height, int style) {
        Wrapper _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Serializable[]{name, Integer.valueOf(height), Integer.valueOf(style)});
        HashMap<ArrayList<?>, Wrapper<Font>> hashMap = this._createCache_transformToFont;
        synchronized (hashMap) {
            Wrapper _wrapper;
            if (this._createCache_transformToFont.containsKey(_cacheKey)) {
                return this._createCache_transformToFont.get(_cacheKey);
            }
            _result = _wrapper = new Wrapper();
            this._createCache_transformToFont.put(_cacheKey, (Wrapper<Font>)_result);
        }
        this._init_transformToFont((Wrapper<Font>)_result, name, height, style);
        return _result;
    }

    private void _init_transformToFont(Wrapper<Font> it, String name, int height, int style) {
        FontDescriptor descriptor = FontDescriptor.createFrom((String)name, (int)height, (int)style);
        Font font = this.resourceManager.createFont(descriptor);
        it.setValue((Object)font);
    }

    private Color transformToColor(String name) throws NoSuchFieldException, IllegalAccessException {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("COLOR_");
        String _upperCase = name.toUpperCase();
        _builder.append(_upperCase);
        String foregroundAttribute = _builder.toString();
        int foreground = SWT.class.getField(foregroundAttribute).getInt(null);
        return Display.getCurrent().getSystemColor(foreground);
    }

    public static TextAttribute handleTextAttribute(Exception e) {
        StringConcatenation _builder = new StringConcatenation();
        String _simpleName = e.getClass().getSimpleName();
        _builder.append(_simpleName);
        _builder.append(": ");
        String _message = e.getMessage();
        _builder.append(_message);
        _builder.append(" - returning default text attribute");
        LOGGER.error(_builder.toString(), (Throwable)e);
        Color _systemColor = Display.getCurrent().getSystemColor(2);
        Color _systemColor_1 = Display.getCurrent().getSystemColor(1);
        return new TextAttribute(_systemColor, _systemColor_1, 0);
    }

    public static Font handleFont(Exception e) {
        StringConcatenation _builder = new StringConcatenation();
        String _simpleName = e.getClass().getSimpleName();
        _builder.append(_simpleName);
        _builder.append(": ");
        String _message = e.getMessage();
        _builder.append(_message);
        _builder.append(" - returning no text font");
        LOGGER.error(_builder.toString(), (Throwable)e);
        return null;
    }
}

