/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.events;

import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.set.utils.events.ToolboxEvent;
import org.eclipse.set.utils.events.ToolboxEventHandler;
import org.osgi.service.event.EventHandler;

public class ToolboxEvents {
    private static final String TOOLBOX_EVENT = "event";

    public static void send(IEventBroker broker, ToolboxEvent event) {
        HashMap data = Maps.newHashMap();
        data.put(TOOLBOX_EVENT, event);
        broker.send(event.getTopic(), (Object)data);
    }

    public static <T extends ToolboxEvent> void subscribe(IEventBroker broker, Class<T> eventType, ToolboxEventHandler<T> handler) {
        String topic;
        try {
            topic = ((ToolboxEvent)eventType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).getTopic();
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        ToolboxEvents.subscribe(broker, eventType, handler, topic);
    }

    public static <T extends ToolboxEvent> void subscribe(IEventBroker broker, Class<T> eventType, ToolboxEventHandler<T> handler, String topic) {
        EventHandler eventHandler = event -> {
            ToolboxEvent toolboxEvent = (ToolboxEvent)eventType.cast(event.getProperty(TOOLBOX_EVENT));
            handler.accept(toolboxEvent);
        };
        handler.setEventHandler(eventHandler);
        if (!broker.subscribe(topic, eventHandler)) {
            throw new RuntimeException("Subscribing for " + eventType.getName() + " failed.");
        }
    }

    public static void unsubscribe(IEventBroker broker, ToolboxEventHandler<?> handler) {
        if (handler != null) {
            broker.unsubscribe(handler.getEventHandler());
        }
    }
}

