/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.attachment;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.constants.ContainerType;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.set.toolboxmodel.Basisobjekte.Anhang;
import org.eclipse.set.toolboxmodel.PlanPro.Container_AttributeGroup;

public class AttachmentModelProvider {
    private final List<Anhang> domainAttachmentsFinal;
    private final List<Anhang> domainAttachmentsInitial;
    private final List<Anhang> domainAttachmentsSingle;
    private final List<Anhang> objectManagementAttachments = new ArrayList<Anhang>();

    public AttachmentModelProvider(IModelSession session) {
        this.domainAttachmentsInitial = new ArrayList<Anhang>();
        this.domainAttachmentsFinal = new ArrayList<Anhang>();
        this.domainAttachmentsSingle = new ArrayList<Anhang>();
        MultiContainer_AttributeGroup initialContainer = session.getContainer(ContainerType.INITIAL);
        MultiContainer_AttributeGroup finalContainer = session.getContainer(ContainerType.FINAL);
        MultiContainer_AttributeGroup singleContainer = session.getContainer(ContainerType.SINGLE);
        TreeIterator allContents = session.getPlanProSchnittstelle().eAllContents();
        EObject eObject = (EObject)allContents.next();
        while (allContents.hasNext()) {
            if (eObject instanceof Anhang) {
                Anhang attachment = (Anhang)eObject;
                EObject parent = attachment.eContainer();
                if (parent instanceof Container_AttributeGroup) {
                    if (initialContainer != null && Iterables.contains((Iterable)initialContainer.getContainers(), (Object)parent)) {
                        this.domainAttachmentsInitial.add(attachment);
                    } else if (finalContainer != null && Iterables.contains((Iterable)finalContainer.getContainers(), (Object)parent)) {
                        this.domainAttachmentsFinal.add(attachment);
                    } else if (singleContainer != null && Iterables.contains((Iterable)singleContainer.getContainers(), (Object)parent)) {
                        this.domainAttachmentsSingle.add(attachment);
                    }
                } else {
                    this.objectManagementAttachments.add(attachment);
                }
            }
            eObject = (EObject)allContents.next();
        }
    }

    public List<Anhang> getDomainAttachmentsFinal() {
        return this.domainAttachmentsFinal;
    }

    public List<Anhang> getDomainAttachmentsInitial() {
        return this.domainAttachmentsInitial;
    }

    public List<Anhang> getDomainAttachmentsSingle() {
        return this.domainAttachmentsSingle;
    }

    public List<Anhang> getObjectManagementAttachments() {
        return this.objectManagementAttachments;
    }
}

