/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.set.browser.RequestHandler;
import org.eclipse.set.utils.WebBrowser;
import org.eclipse.swt.widgets.Composite;

public class FileWebBrowser
extends WebBrowser
implements RequestHandler {
    private static final String HOSTNAME = "toolbox";
    private static final String BASE_URI = "https://toolbox/";
    private final Map<String, RequestCallback> prefixUrlHandler = new HashMap<String, RequestCallback>();

    public FileWebBrowser(Composite parent) {
        super(parent);
        this.getBrowser().registerRequestHandler(HOSTNAME, (RequestHandler)this);
    }

    public void setToolboxUrl(String routePath) {
        super.setUrl(BASE_URI + routePath);
    }

    @Override
    protected List<String> getAllowedPrefixes() {
        return List.of(BASE_URI, "chrome://");
    }

    public void onRequest(RequestHandler.Request request, RequestHandler.Response response) throws Exception {
        String uri = request.getURL().substring(BASE_URI.length());
        String decoded = URLDecoder.decode(uri, StandardCharsets.UTF_8.name());
        for (Map.Entry<String, RequestCallback> entry : this.prefixUrlHandler.entrySet()) {
            if (!decoded.startsWith(entry.getKey())) continue;
            entry.getValue().accept(request, response);
            return;
        }
        response.setMimeType("text/plain");
        response.setResponseData("404 - Page not found!");
        response.setStatus(404);
    }

    public void serveFile(String uri, String mime, Path file) {
        this.serveUri(uri, (RequestHandler.Response response) -> {
            response.setMimeType(mime);
            response.setStatus(200);
            InputStream stream = Files.newInputStream(file, new OpenOption[0]);
            response.setResponseData(stream);
        });
    }

    public void serveUri(String uri, RequestCallback callback) {
        this.prefixUrlHandler.put(uri, callback);
    }

    public void serveUri(String uri, SimpleRequestCallback callback) {
        this.prefixUrlHandler.put(uri, (req, resp) -> callback.accept(resp));
    }

    public void serveDirectory(String uri, Path directory) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Stream<Path> files = Files.list(directory);){
            for (Path file : files.toList()) {
                String fileuri;
                String filename = file.getFileName().toString();
                String string = fileuri = uri.length() != 0 ? uri + "/" + filename : filename;
                if (Files.isDirectory(file, new LinkOption[0])) {
                    this.serveDirectory(fileuri, file);
                    continue;
                }
                Path filepath = file.toAbsolutePath();
                String contentType = Files.probeContentType(filepath);
                this.serveFile(fileuri, contentType, filepath);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void serveRootDirectory(Path directory) throws IOException {
        this.serveDirectory("", directory);
    }

    public static String encodePath(String path) {
        try {
            return URLEncoder.encode(path, "UTF-8").replace("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @FunctionalInterface
    public static interface RequestCallback {
        public void accept(RequestHandler.Request var1, RequestHandler.Response var2) throws Exception;
    }

    @FunctionalInterface
    public static interface SimpleRequestCallback {
        public void accept(RequestHandler.Response var1) throws Exception;
    }
}

