/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.GregorianCalendar;
import java.util.Optional;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.emf.ecore.xml.type.internal.XMLCalendar;
import org.eclipse.swt.widgets.DateTime;

public class CalendarTextConversion {
    static DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM);

    public static Optional<XMLGregorianCalendar> getCalendar(DateTime dateTime) {
        return CalendarTextConversion.getCalendar(dateTime.getYear(), dateTime.getMonth() + 1, dateTime.getDay());
    }

    public static Optional<XMLGregorianCalendar> getCalendar(String text) {
        try {
            LocalDate date = LocalDate.parse(text, formatter);
            return CalendarTextConversion.getCalendar(date.getYear(), date.getMonthValue(), date.getDayOfMonth());
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static String getText(XMLGregorianCalendar calendar) {
        LocalDate date = LocalDate.of(calendar.getYear(), calendar.getMonth(), calendar.getDay());
        return date.format(formatter);
    }

    private static Optional<XMLGregorianCalendar> getCalendar(int year, int month, int day) {
        GregorianCalendar c = new GregorianCalendar();
        c.set(year, month - 1, day);
        XMLCalendar xmlGregorianCalendar = new XMLCalendar(c.getTime(), 2);
        xmlGregorianCalendar.setHour(Integer.MIN_VALUE);
        xmlGregorianCalendar.setMinute(Integer.MIN_VALUE);
        xmlGregorianCalendar.setSecond(Integer.MIN_VALUE);
        xmlGregorianCalendar.setMillisecond(Integer.MIN_VALUE);
        xmlGregorianCalendar.setTimezone(Integer.MIN_VALUE);
        return Optional.of(xmlGregorianCalendar);
    }
}

