/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.plazmodel.table;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.set.core.services.enumtranslation.EnumTranslationService;
import org.eclipse.set.feature.plazmodel.Messages;
import org.eclipse.set.feature.plazmodel.table.PlazModelTableTransformationService;
import org.eclipse.set.model.plazmodel.PlazReport;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.validationreport.ValidationProblem;
import org.eclipse.set.utils.BasePart;
import org.eclipse.set.utils.table.menu.TableMenuService;
import org.eclipse.set.utils.table.tree.AbstractTreeLayerTable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class PlazModelTableView
extends AbstractTreeLayerTable {
    private final Messages messages;
    private final BasePart part;
    private final EnumTranslationService enumTranslationService;
    private NatTable natTable;
    private final TableMenuService tableMenuService;

    public PlazModelTableView(BasePart part, Messages messages, TableMenuService tableMenuService, EnumTranslationService enumTranslationService) {
        this.part = part;
        this.messages = messages;
        this.tableMenuService = tableMenuService;
        this.enumTranslationService = enumTranslationService;
    }

    public Control create(Composite parent, PlazReport validationReport) {
        PlazModelTableTransformationService service = new PlazModelTableTransformationService(this.messages, this.enumTranslationService);
        Table table = service.transform(validationReport);
        this.createTableBodyData(table, rowIndex -> ((ValidationProblem)validationReport.getEntries().get(rowIndex - 1)).getLineNumber());
        this.tableMenuService.createDefaultMenuItems(this.part, table, (IDataProvider)this.bodyDataProvider, this.bodyLayerStack.getSelectionLayer());
        this.natTable = this.createTable(parent, table, this.tableMenuService);
        return this.natTable;
    }

    public void updateView(PlazReport report) {
        if (this.natTable != null) {
            PlazModelTableTransformationService service = new PlazModelTableTransformationService(this.messages, this.enumTranslationService);
            this.bodyDataProvider.refresh(service.transform(report));
            this.natTable.refresh();
        }
    }
}

