/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.plazmodel.check;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.text.StringSubstitutor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.feature.plazmodel.check.AbstractPlazContainerCheck;
import org.eclipse.set.feature.plazmodel.check.PlazCheck;
import org.eclipse.set.model.plazmodel.PlazError;
import org.eclipse.set.model.plazmodel.PlazFactory;
import org.eclipse.set.ppmodel.extensions.PlanProSchnittstelleExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.set.toolboxmodel.Ansteuerung_Element.Aussenelementansteuerung;
import org.eclipse.set.toolboxmodel.Bahnsteig.Bahnsteig_Anlage;
import org.eclipse.set.toolboxmodel.Bahnsteig.Bahnsteig_Kante;
import org.eclipse.set.toolboxmodel.Basisobjekte.Basis_Objekt;
import org.eclipse.set.toolboxmodel.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Ur_Objekt;
import org.eclipse.set.toolboxmodel.Geodaten.GEO_Kante;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Kante;
import org.eclipse.set.toolboxmodel.PlanPro.LST_Objekte_Planungsbereich_AttributeGroup;
import org.eclipse.set.toolboxmodel.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.toolboxmodel.PlanPro.Planung_Einzel;
import org.eclipse.set.toolboxmodel.PlanPro.Planung_Gruppe;
import org.eclipse.set.toolboxmodel.Signale.Signal;
import org.eclipse.set.toolboxmodel.Signale.Signal_Befestigung;
import org.eclipse.set.toolboxmodel.Signale.Signal_Rahmen;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.W_Kr_Anlage;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.W_Kr_Gsp_Element;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.W_Kr_Gsp_Komponente;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true)
public class PlanungsBereichValid
extends AbstractPlazContainerCheck
implements PlazCheck {
    private Set<String> planningsObjectID = CollectionLiterals.newHashSet();
    private Map<Ur_Objekt, Boolean> alreadyValidatedObjects = CollectionLiterals.newHashMap();
    private static final List<? extends Class<? extends Basis_Objekt>> relevantObjects = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Class[]{Signal.class, Signal_Rahmen.class, Signal_Befestigung.class, GEO_Kante.class, TOP_Kante.class, Bahnsteig_Anlage.class, Bahnsteig_Kante.class, W_Kr_Anlage.class, W_Kr_Gsp_Element.class, W_Kr_Gsp_Komponente.class, Aussenelementansteuerung.class}));

    @Override
    public List<PlazError> run(MultiContainer_AttributeGroup container) {
        Iterable _orElse = PlanProSchnittstelleExtensions.getLSTPlanungGruppe((PlanPro_Schnittstelle)this.modelSession.getPlanProSchnittstelle()).orElse(null);
        if (_orElse != null) {
            Consumer<Planung_Gruppe> _function = new Consumer<Planung_Gruppe>(){

                @Override
                public void accept(Planung_Gruppe it) {
                    Planung_Einzel _lSTPlanungEinzel = it.getLSTPlanungEinzel();
                    LST_Objekte_Planungsbereich_AttributeGroup _lSTObjektePlanungsbereich = null;
                    if (_lSTPlanungEinzel != null) {
                        _lSTObjektePlanungsbereich = _lSTPlanungEinzel.getLSTObjektePlanungsbereich();
                    }
                    EList _iDLSTObjektPlanungsbereich = null;
                    if (_lSTObjektePlanungsbereich != null) {
                        _iDLSTObjektPlanungsbereich = _lSTObjektePlanungsbereich.getIDLSTObjektPlanungsbereich();
                    }
                    if (_iDLSTObjektPlanungsbereich != null) {
                        Consumer<Ur_Objekt> _function = new Consumer<Ur_Objekt>(){

                            @Override
                            public void accept(Ur_Objekt it_1) {
                                String guid;
                                Identitaet_TypeClass _identitaet = it_1.getIdentitaet();
                                String _wert = null;
                                if (_identitaet != null) {
                                    _wert = _identitaet.getWert();
                                }
                                if ((guid = _wert) != null && !(this).PlanungsBereichValid.this.planningsObjectID.contains(it_1.getIdentitaet().getWert())) {
                                    (this).PlanungsBereichValid.this.planningsObjectID.add(guid);
                                }
                            }
                        };
                        _iDLSTObjektPlanungsbereich.forEach((Consumer)_function);
                    }
                }
            };
            _orElse.forEach(_function);
        }
        Functions.Function1<Ur_Objekt, Boolean> _function_1 = new Functions.Function1<Ur_Objekt, Boolean>(){

            public Boolean apply(final Ur_Objekt obj) {
                Functions.Function1<Class<? extends Basis_Objekt>, Boolean> _function = new Functions.Function1<Class<? extends Basis_Objekt>, Boolean>(){

                    public Boolean apply(Class<? extends Basis_Objekt> it) {
                        return it.isInstance(obj);
                    }
                };
                return IterableExtensions.exists(relevantObjects, (Functions.Function1)_function);
            }
        };
        Functions.Function1<Ur_Objekt, PlazError> _function_2 = new Functions.Function1<Ur_Objekt, PlazError>(){

            public PlazError apply(Ur_Objekt it) {
                String guid;
                Identitaet_TypeClass _identitaet = it.getIdentitaet();
                String _wert = null;
                if (_identitaet != null) {
                    _wert = _identitaet.getWert();
                }
                if ((guid = _wert) != null && !PlanungsBereichValid.this.isPlanningObject(it, PlanungsBereichValid.this.planningsObjectID.contains(guid))) {
                    PlazError err = PlazFactory.eINSTANCE.createPlazError();
                    Identitaet_TypeClass _identitaet_1 = it.getIdentitaet();
                    String _wert_1 = null;
                    if (_identitaet_1 != null) {
                        _wert_1 = _identitaet_1.getWert();
                    }
                    err.setMessage(PlanungsBereichValid.this.transformErroMsg(Map.of("GUID", _wert_1)));
                    err.setType("Planungs-/Betrachtungsbereich");
                    err.setObject((EObject)it);
                    return err;
                }
                return null;
            }
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)container.getAllContents(), Ur_Objekt.class), (Functions.Function1)_function_1), (Functions.Function1)_function_2)));
    }

    private boolean isPlanningObject(Ur_Objekt parent, final boolean isPlanningObject) {
        String parentGUID;
        Boolean alreadyValidate = this.alreadyValidatedObjects.get(parent);
        if (alreadyValidate != null) {
            return alreadyValidate;
        }
        Identitaet_TypeClass _identitaet = parent.getIdentitaet();
        String _wert = null;
        if (_identitaet != null) {
            _wert = _identitaet.getWert();
        }
        if ((parentGUID = _wert) != null && Boolean.valueOf(this.planningsObjectID.contains(parentGUID)) != Boolean.valueOf(isPlanningObject)) {
            this.alreadyValidatedObjects.put(parent, false);
            return false;
        }
        Functions.Function1<Ur_Objekt, Boolean> _function = new Functions.Function1<Ur_Objekt, Boolean>(){

            public Boolean apply(final Ur_Objekt obj) {
                Functions.Function1<Class<? extends Basis_Objekt>, Boolean> _function = new Functions.Function1<Class<? extends Basis_Objekt>, Boolean>(){

                    public Boolean apply(Class<? extends Basis_Objekt> it) {
                        String objGuid;
                        Identitaet_TypeClass _identitaet = obj.getIdentitaet();
                        String _wert = null;
                        if (_identitaet != null) {
                            _wert = _identitaet.getWert();
                        }
                        return (objGuid = _wert) != null && it.isInstance(obj) && parentGUID != objGuid;
                    }
                };
                return IterableExtensions.exists(relevantObjects, (Functions.Function1)_function);
            }
        };
        Functions.Function1<Ur_Objekt, Boolean> _function_1 = new Functions.Function1<Ur_Objekt, Boolean>(){

            public Boolean apply(Ur_Objekt it) {
                boolean _isPlanningObject = PlanungsBereichValid.this.isPlanningObject(it, isPlanningObject);
                return !_isPlanningObject;
            }
        };
        boolean _exists = IterableExtensions.exists((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)parent.eCrossReferences(), Ur_Objekt.class), (Functions.Function1)_function), (Functions.Function1)_function_1);
        boolean refObj = !_exists;
        this.alreadyValidatedObjects.put(parent, refObj);
        return refObj;
    }

    @Override
    public String checkType() {
        return "Planungs-/Betrachtungsbereich";
    }

    @Override
    public String getDescription() {
        return "Objekte sind entweder im Planungs- oder Betrachtungsbereich verortet.";
    }

    @Override
    public String getGeneralErrMsg() {
        return "Bestandteile des Objekts {GUID} sind sowohl im Planungs- als auch im Betrachtungsbereich verortet.";
    }

    @Override
    public String transformErroMsg(Map<String, String> params) {
        return StringSubstitutor.replace((Object)this.getGeneralErrMsg(), params, (String)"{", (String)"}");
    }
}

