/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.plazmodel;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecp.ui.view.ECPRendererException;
import org.eclipse.set.basis.ProblemMessage;
import org.eclipse.set.basis.cache.Cache;
import org.eclipse.set.basis.constants.ToolboxViewState;
import org.eclipse.set.basis.extensions.MApplicationElementExtensions;
import org.eclipse.set.basis.extensions.PathExtensions;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.core.services.dialog.DialogService;
import org.eclipse.set.core.services.enumtranslation.EnumTranslationService;
import org.eclipse.set.feature.plazmodel.Messages;
import org.eclipse.set.feature.plazmodel.service.PlazModelService;
import org.eclipse.set.feature.plazmodel.table.PlazModelTableView;
import org.eclipse.set.model.plazmodel.PlazReport;
import org.eclipse.set.model.validationreport.ValidationSeverity;
import org.eclipse.set.model.validationreport.extensions.ValidationProblemExtensions;
import org.eclipse.set.toolboxmodel.PlanPro.Container_AttributeGroup;
import org.eclipse.set.utils.BasePart;
import org.eclipse.set.utils.SaveAndRefreshAction;
import org.eclipse.set.utils.SelectableAction;
import org.eclipse.set.utils.emfforms.AbstractEmfFormsPart;
import org.eclipse.set.utils.events.ContainerDataChanged;
import org.eclipse.set.utils.events.ProjectDataChanged;
import org.eclipse.set.utils.table.export.ExportToCSV;
import org.eclipse.set.utils.table.menu.TableMenuService;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class PlazModelPart
extends AbstractEmfFormsPart {
    private Exception createException;
    @Inject
    @Translation
    Messages messages;
    @Inject
    UISynchronize sync;
    @Inject
    PlazModelService plazModelService;
    @Inject
    EnumTranslationService enumTranslationService;
    @Inject
    TableMenuService tableMenuService;
    private PlazModelTableView tableView;
    private PlazReport plazReport;
    static final String HEADER_PATTERN = "PlaZ-Modell-Pr\u00fcfung\nDatei: %s\nPr\u00fcfungszeit: %s\nWerkzeugkofferversion: %s\n\n\n\"Lfd. Nr.\";\"Schweregrad\";\"Problemart\";\"Zeilennummer\";\"Objektart\";\"Attribut/-gruppe\";\"Bereich\";\"Meldung\"\n";

    @Inject
    public PlazModelPart() {
    }

    protected void createFormsView(Composite parent) throws ECPRendererException {
        this.tableView = new PlazModelTableView((BasePart)this, this.messages, this.tableMenuService, this.enumTranslationService);
        Shell shell = this.getToolboxShell();
        MPart part = this.getToolboxPart();
        DialogService dialogService = this.getDialogService();
        dialogService.showProgressUISync(shell, this.messages.PlaZService_MonitorDisplay_GeneratePlazModel, () -> this.create(parent));
        if (this.createException != null) {
            dialogService.error(shell, this.createException);
            MApplicationElementExtensions.setViewState((MApplicationElement)part, (ToolboxViewState)ToolboxViewState.ERROR);
        }
        if (this.getModelSession().isDirty()) {
            this.setOutdated(true);
        }
        this.getBanderole().setEnableExport(true);
        this.getBanderole().setExportAction(new SelectableAction(){

            public void selected(SelectionEvent e) {
                PlazModelPart.this.exportPlazModel();
            }

            public String getText() {
                return PlazModelPart.this.messages.PlazModellPart_ExportTitleMsg;
            }
        });
        this.tableView.createExpandCollapseAllButton((Composite)this.getBanderole().getControl(), this.messages.PlazModellPart_ExpandAllGroup, this.messages.PlazModellPart_CollapseAllGroup);
    }

    private void create(Composite parent) {
        try {
            this.updatePlazModel();
            this.tableView.create(parent, this.plazReport);
            this.createException = null;
        }
        catch (Exception e) {
            this.createException = e;
        }
    }

    private void updatePlazModel() {
        this.plazReport = this.plazModelService.runPlazModel(this.getModelSession());
        this.tableView.updateView(this.plazReport);
        this.setOutdated(false);
        Cache cache = Services.getCacheService().getCache("toolbox.cache.problem-message");
        List problems = (List)cache.get("plazReport", ArrayList::new);
        problems.clear();
        this.plazReport.getEntries().stream().filter(entry -> entry.getSeverity() != ValidationSeverity.SUCCESS).forEach(entry -> {
            boolean bl = problems.add(new ProblemMessage(entry.getMessage(), entry.getType(), entry.getLineNumber(), 2, entry.getObjectState().getLiteral()));
        });
        this.getBroker().post("modelsession/change/problems", null);
    }

    private void exportPlazModel() {
        Shell shell = this.getToolboxShell();
        Path location = this.getModelSession().getToolboxFile().getPath();
        Path parent = location.getParent();
        String defaultPath = parent == null ? "" : parent.toString();
        String defaultFileName = String.format(this.messages.PlazModellPart_ExportCsvFilePattern, PathExtensions.getBaseFileName((Path)location));
        Optional optionalPath = this.getDialogService().saveFileDialog(shell, this.getDialogService().getCsvFileFilters(), Paths.get(defaultPath, defaultFileName), this.messages.PlazModellPart_ExportTitleMsg);
        ExportToCSV problemExport = new ExportToCSV(HEADER_PATTERN);
        problemExport.exportToCSV(optionalPath, (List)this.plazReport.getEntries(), ValidationProblemExtensions::getCsvExport);
        optionalPath.ifPresent(outputDir -> this.getDialogService().openDirectoryAfterExport(this.getToolboxShell(), outputDir.getParent()));
    }

    protected SelectableAction getOutdatedAction() {
        return new SaveAndRefreshAction((BasePart)this);
    }

    protected void handleContainerDataChanged(ContainerDataChanged e) {
        this.setOutdated(true);
    }

    protected void handleProjectDataChanged(ProjectDataChanged e) {
        this.setOutdated(true);
    }

    protected void updateViewContainerDataChanged(List<Container_AttributeGroup> container) {
        this.updatePlazModel();
    }

    protected void updateViewProjectDataChanged(List<Notification> notifications) {
        this.updatePlazModel();
    }
}

