/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.basis.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InformationDialog
extends Dialog {
    private static final String DIALOG_FONT_NAME = "Segoe UI Semibold";
    private static final FontDescriptor INFO_FONT_DESCRIPTOR = FontDescriptor.createFrom((String)"Segoe UI Semibold", (int)10, (int)1);
    private final String cause;
    private final String causeLabeltext;
    private Button detailsButton;
    private Text detailsText;
    private final Throwable exception;
    private final String info;
    private final int severity;
    private final String title;

    private static Point computeControl(Control control) {
        return control.computeSize(-1, -1);
    }

    private static Point computeControls(Control ... controls) {
        Point result = new Point(0, 0);
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            result.x = Math.max(result.x, InformationDialog.computeControl((Control)control).x);
            result.y += InformationDialog.computeControl((Control)control).y;
            ++n2;
        }
        return result;
    }

    public InformationDialog(Shell parentShell, String title, String info) {
        super(parentShell);
        this.setShellStyle(1072);
        this.info = info;
        this.title = title;
        this.causeLabeltext = "";
        this.cause = "";
        this.exception = null;
        this.severity = 0;
    }

    public InformationDialog(Shell parentShell, String title, String info, int severity, String causeLabeltext, String cause, Throwable throwable) {
        super(parentShell);
        this.setShellStyle(1072);
        this.info = info;
        this.title = title;
        this.causeLabeltext = causeLabeltext;
        this.cause = cause;
        this.exception = throwable;
        this.severity = severity;
    }

    public String getCause() {
        return this.cause;
    }

    public String getCauseLabeltext() {
        return this.causeLabeltext;
    }

    public Button getDetailsButton() {
        return this.detailsButton;
    }

    public Text getDetailsText() {
        return this.detailsText;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String getInfo() {
        return this.info;
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isOK() {
        return this.severity == 0;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        if (this.severity != 0) {
            this.detailsButton = this.createButton(parent, 13, IDialogConstants.SHOW_DETAILS_LABEL, true);
            this.detailsButton.addMouseListener(new MouseListener(){

                public void mouseDoubleClick(MouseEvent e) {
                    this.toggleDetails();
                }

                public void mouseDown(MouseEvent e) {
                    this.toggleDetails();
                }

                public void mouseUp(MouseEvent e) {
                }

                private void toggleDetails() {
                    boolean isVisible = InformationDialog.this.getDetailsText().isVisible();
                    if (isVisible) {
                        InformationDialog.this.getDetailsButton().setText(IDialogConstants.HIDE_DETAILS_LABEL);
                    } else {
                        InformationDialog.this.getDetailsButton().setText(IDialogConstants.SHOW_DETAILS_LABEL);
                    }
                    InformationDialog.this.getDetailsText().setVisible(!isVisible);
                }
            });
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        parent.getShell().setText(this.title);
        container.setLayout((Layout)new GridLayout(2, false));
        LocalResourceManager localResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)container);
        Font infoFont = localResourceManager.createFont(INFO_FONT_DESCRIPTOR);
        Text infoText = new Text(container, 0x1000000);
        infoText.setLayoutData((Object)new GridData(4, 128, true, true, 1, 1));
        infoText.setFont(infoFont);
        infoText.setText(this.info);
        infoText.setEditable(false);
        Point size = InformationDialog.computeControls(new Control[]{infoText});
        parent.getShell().setSize((int)((double)size.x * 1.25), size.y * 6);
        if (!this.cause.isEmpty()) {
            Label causeLabel = new Label(container, 0);
            causeLabel.setFont(infoFont);
            causeLabel.setLayoutData((Object)new GridData(16384, 128, false, false, 2, 1));
            causeLabel.setText(this.causeLabeltext);
            Text causeText = new Text(container, 16384);
            causeText.setFont(infoFont);
            causeText.setText(this.cause);
            causeText.setEditable(false);
            Point size2 = InformationDialog.computeControls(new Control[]{infoText, causeText});
            parent.getShell().setSize((int)((double)size2.x * 1.25), size2.y * 6);
        }
        if (this.exception != null) {
            this.detailsText = new Text(container, 256);
            this.detailsText.setLayoutData((Object)new GridData(4, 128, true, true, 2, 1));
            if (this.exception.getMessage() != null) {
                this.detailsText.setText(this.exception.getMessage());
            }
            this.detailsText.setVisible(false);
            this.detailsText.setEditable(false);
        }
        return container;
    }
}

