/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.basis.geometry;

import org.eclipse.set.basis.graph.DirectedElement;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineSegment;

public class SegmentPosition {
    private final DirectedElement<LineSegment> directedlineSegment;
    private final double distance;

    public SegmentPosition(DirectedElement<LineSegment> directedLineSegment, double distance) {
        this.directedlineSegment = directedLineSegment;
        this.distance = distance;
    }

    public Coordinate getCoordinate() {
        LineSegment lineSegment = this.directedlineSegment.getElement();
        double length = lineSegment.getLength();
        if (length == 0.0) {
            return lineSegment.pointAlong(0.0);
        }
        return lineSegment.pointAlong(this.distance / length);
    }

    public DirectedElement<LineSegment> getDirectedLineSegment() {
        return this.directedlineSegment;
    }
}

