/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.basis.geometry;

import org.eclipse.set.basis.geometry.Chord;
import org.eclipse.set.basis.geometry.Geometries;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineSegment;

public class Circle {
    private final Coordinate midpoint;
    private final double radius;

    public Circle(Chord chord) {
        this(chord.getMidpoint(), chord.getRadius());
    }

    public Circle(Coordinate midpoint, double radius) {
        this.midpoint = midpoint;
        this.radius = radius;
    }

    public Coordinate getMidpoint() {
        return this.midpoint;
    }

    public double getRadius() {
        return this.radius;
    }

    public LineSegment getTangent(Coordinate coordinate) {
        LineSegment tangent = Geometries.clone(new LineSegment(this.getMidpoint(), coordinate));
        Geometries.translate(tangent, this.getMidpoint(), coordinate);
        Geometries.turn(tangent, 90.0);
        return tangent;
    }
}

