/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.basis.extensions;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.set.basis.extensions.MatcherExtensions;
import org.eclipse.set.basis.text.Tag;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class IDocumentExtensions {
    private static final Pattern TAG_PATTERN = Pattern.compile("<\\s*[/?]?\\s*([^ \\t\\n\\x0B\\f\\r>/]+)([^>]*)>");

    public static String get(IDocument document, IRegion region) throws BadLocationException {
        return document.get(region.getOffset(), region.getLength());
    }

    public static Character getNext(IDocument document, int offset, char ... chars) {
        ArrayList charList = Lists.newArrayList((Iterable)((Iterable)Conversions.doWrapArray((Object)chars)));
        int length = document.getLength();
        try {
            int position = offset + 1;
            while (position < length) {
                Character positionChar = Character.valueOf(document.getChar(position));
                boolean _contains = charList.contains(positionChar);
                if (_contains) {
                    return positionChar;
                }
                ++position;
            }
            return null;
        }
        catch (Throwable _t) {
            if (_t instanceof BadLocationException) {
                BadLocationException e = (BadLocationException)_t;
                throw new RuntimeException((Throwable)e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public static Character getPrevious(IDocument document, int offset, char ... chars) {
        ArrayList charList = Lists.newArrayList((Iterable)((Iterable)Conversions.doWrapArray((Object)chars)));
        try {
            int position = offset - 1;
            while (position >= 0) {
                Character positionChar = Character.valueOf(document.getChar(position));
                boolean _contains = charList.contains(positionChar);
                if (_contains) {
                    return positionChar;
                }
                --position;
            }
            return null;
        }
        catch (Throwable _t) {
            if (_t instanceof BadLocationException) {
                BadLocationException e = (BadLocationException)_t;
                throw new RuntimeException((Throwable)e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public static ArrayList<Tag> getTags(final IDocument document, IRegion region) throws BadLocationException {
        String text = document.get(region.getOffset(), region.getLength());
        Matcher matcher = TAG_PATTERN.matcher(text);
        Functions.Function1<IRegion, Tag> _function = new Functions.Function1<IRegion, Tag>(){

            public Tag apply(IRegion it) {
                return IDocumentExtensions.toTag(it, document);
            }
        };
        return Lists.newArrayList((Iterable)ListExtensions.map(MatcherExtensions.getAllMatches(matcher, region), (Functions.Function1)_function));
    }

    private static Tag toTag(IRegion match, IDocument document) {
        try {
            return new Tag(document, match);
        }
        catch (Throwable _t) {
            if (_t instanceof BadLocationException) {
                BadLocationException e = (BadLocationException)_t;
                throw new RuntimeException((Throwable)e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }
}

