/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ui.view.swt;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecp.edit.spi.ReferenceService;
import org.eclipse.emf.ecp.internal.edit.ECPControlHelper;
import org.eclipse.emf.ecp.spi.common.ui.SelectModelElementWizardFactory;
import org.eclipse.emf.ecp.spi.common.ui.composites.SelectionComposite;
import org.eclipse.emf.ecp.ui.view.swt.reference.AttachmentStrategy;
import org.eclipse.emf.ecp.ui.view.swt.reference.CreateNewModelElementStrategy;
import org.eclipse.emf.ecp.ui.view.swt.reference.EObjectSelectionStrategy;
import org.eclipse.emf.ecp.ui.view.swt.reference.OpenInNewContextStrategy;
import org.eclipse.emf.ecp.ui.view.swt.reference.ReferenceStrategy;
import org.eclipse.emf.ecp.ui.view.swt.reference.SelectionCompositeStrategy;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DefaultReferenceService
implements ReferenceService {
    private EObjectSelectionStrategy eobjectSelectionStrategy = EObjectSelectionStrategy.NULL;
    private CreateNewModelElementStrategy createNewModelElementStrategy = CreateNewModelElementStrategy.DEFAULT;
    private AttachmentStrategy attachmentStrategy = AttachmentStrategy.DEFAULT;
    private ReferenceStrategy referenceStrategy = ReferenceStrategy.DEFAULT;
    private OpenInNewContextStrategy openInNewContextStrategy = OpenInNewContextStrategy.DEFAULT;
    private SelectionCompositeStrategy selectionCompositeStrategy = SelectionCompositeStrategy.DEFAULT;

    public void instantiate(ViewModelContext context) {
    }

    public void dispose() {
    }

    public int getPriority() {
        return 2;
    }

    @Deprecated
    public void addNewModelElements(EObject eObject, EReference eReference) {
        this.addNewModelElements(eObject, eReference, true);
    }

    public Optional<EObject> addNewModelElements(EObject eObject, EReference eReference, boolean openInNewContext) {
        if (eReference.isContainer()) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"Operation not permitted for container references!");
            return Optional.empty();
        }
        Optional<EObject> newMEInstanceOptional = this.createNewModelElementStrategy.createNewModelElement(eObject, eReference);
        if (!newMEInstanceOptional.isPresent()) {
            return Optional.empty();
        }
        EObject newMEInstance = (EObject)newMEInstanceOptional.get();
        if (!eReference.isContainment()) {
            this.attachmentStrategy.addElementToModel(eObject, eReference, newMEInstance);
        }
        this.referenceStrategy.addElementsToReference(eObject, eReference, Collections.singleton(newMEInstance));
        if (openInNewContext) {
            this.openInNewContext(newMEInstance);
        }
        return newMEInstanceOptional;
    }

    public void openInNewContext(EObject eObject) {
        EObject owner = eObject.eContainer();
        EReference reference = eObject.eContainmentFeature();
        this.openInNewContextStrategy.openInNewContext(owner, reference, eObject);
    }

    public void addExistingModelElements(EObject eObject, EReference eReference) {
        Iterator allElements = ItemPropertyDescriptor.getReachableObjectsOfType((EObject)eObject, (EClassifier)eReference.getEType()).iterator();
        LinkedHashSet<EObject> elements = new LinkedHashSet<EObject>();
        while (allElements.hasNext()) {
            elements.add((EObject)allElements.next());
        }
        elements = new LinkedHashSet<EObject>(this.eobjectSelectionStrategy.collectExistingObjects(eObject, eReference, elements));
        ECPControlHelper.removeExistingReferences((EObject)eObject, (EReference)eReference, elements);
        SelectionComposite<? extends StructuredViewer> selectionComposite = this.selectionCompositeStrategy.getSelectionViewer(eObject, eReference, elements);
        Set addedElements = selectionComposite == null ? SelectModelElementWizardFactory.openModelElementSelectionDialog(elements, (boolean)eReference.isMany()) : SelectModelElementWizardFactory.openModelElementSelectionDialog(selectionComposite);
        if (!addedElements.isEmpty()) {
            this.referenceStrategy.addElementsToReference(eObject, eReference, addedElements);
        }
    }

    void setEObjectSelectionStrategy(EObjectSelectionStrategy strategy) {
        if (strategy == null) {
            strategy = EObjectSelectionStrategy.NULL;
        }
        this.eobjectSelectionStrategy = strategy;
    }

    void setCreateNewModelElementStrategy(CreateNewModelElementStrategy strategy) {
        if (strategy == null) {
            strategy = CreateNewModelElementStrategy.DEFAULT;
        }
        this.createNewModelElementStrategy = strategy;
    }

    void setAttachmentStrategy(AttachmentStrategy strategy) {
        if (strategy == null) {
            strategy = AttachmentStrategy.DEFAULT;
        }
        this.attachmentStrategy = strategy;
    }

    void setReferenceStrategy(ReferenceStrategy strategy) {
        if (strategy == null) {
            strategy = ReferenceStrategy.DEFAULT;
        }
        this.referenceStrategy = strategy;
    }

    void setOpenStrategy(OpenInNewContextStrategy strategy) {
        if (strategy == null) {
            strategy = OpenInNewContextStrategy.DEFAULT;
        }
        this.openInNewContextStrategy = strategy;
    }

    void setSelectionCompositeStrategyy(SelectionCompositeStrategy strategy) {
        if (strategy == null) {
            strategy = SelectionCompositeStrategy.DEFAULT;
        }
        this.selectionCompositeStrategy = strategy;
    }
}

