/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.nattable.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Function;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.export.csv.CsvExporter;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;

public class ReferenceTableExporter
extends CsvExporter {
    private static final String CHARSET = "UTF-8";
    private static final String ROW_LABEL = "Row";
    private Function<OutputStream, Void> exportEnd;
    private boolean isFirstCell = true;

    private static String addQuotationMarks(String exportDisplayValue) {
        return "\"" + exportDisplayValue + "\"";
    }

    private static String escapeQuotationMarks(String exportDisplayValue) {
        return exportDisplayValue.replace("\"", "\"\"");
    }

    private static String setRowLabel() {
        return ROW_LABEL;
    }

    public ReferenceTableExporter() {
        this.setCharset(CHARSET);
    }

    public void exportCell(OutputStream outputStream, Object exportDisplayValue, ILayerCell cell, IConfigRegistry configRegistry) throws IOException {
        String newExportDisplayValue = (String)exportDisplayValue;
        if (this.isFirstCell) {
            newExportDisplayValue = ReferenceTableExporter.setRowLabel();
            this.isFirstCell = false;
        }
        newExportDisplayValue = ReferenceTableExporter.escapeQuotationMarks(newExportDisplayValue);
        newExportDisplayValue = ReferenceTableExporter.addQuotationMarks(newExportDisplayValue);
        super.exportCell(outputStream, (Object)newExportDisplayValue, cell, configRegistry);
    }

    public void exportEnd(OutputStream outputStream) throws IOException {
        super.exportEnd(outputStream);
        this.exportEnd.apply(outputStream);
    }

    public Function<OutputStream, Void> getExportEnd() {
        return this.exportEnd;
    }

    public void setExportEnd(Function<OutputStream, Void> exportEnd) {
        this.exportEnd = exportEnd;
    }
}

