/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.emfforms.basisattribute;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.spi.UniqueSetting;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emfforms.internal.core.services.mappingprovider.defaultheuristic.EMFFormsMappingProviderDefaultHeuristic;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.eclipse.emfforms.spi.core.services.mappingprovider.EMFFormsMappingProvider;
import org.eclipse.set.emfforms.basisattribute.BasisAttributeSetting;
import org.eclipse.set.toolboxmodel.PlanPro.PlanPro_Schnittstelle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={EMFFormsMappingProvider.class}, immediate=true)
public class BasisAttributeMappingProvider
extends EMFFormsMappingProviderDefaultHeuristic {
    private static final double PRIORITY = 100.0;

    private static Set<UniqueSetting> getWertMappingFor(EStructuralFeature.Setting setting) {
        HashSet<UniqueSetting> result = new HashSet<UniqueSetting>();
        Object object = setting.get(true);
        if (object instanceof EObject) {
            EObject basisAttribute = (EObject)object;
            result.add(UniqueSetting.createSetting((EObject)basisAttribute, (EStructuralFeature)BasisAttributeSetting.getWertFeature(basisAttribute)));
        }
        return result;
    }

    public Set<UniqueSetting> getMappingFor(VDomainModelReference domainModelReference, EObject domainObject) {
        if (!this.isLinked(domainObject)) {
            return new HashSet<UniqueSetting>();
        }
        HashSet<UniqueSetting> result = new HashSet<UniqueSetting>();
        Set originalMapping = super.getMappingFor(domainModelReference, domainObject);
        result.addAll(originalMapping);
        result.addAll(BasisAttributeMappingProvider.getWertMappingFor(((UniqueSetting)originalMapping.iterator().next()).getSetting()));
        return result;
    }

    public double isApplicable(VDomainModelReference domainModelReference, EObject domainObject) {
        if (!(domainModelReference instanceof VFeaturePathDomainModelReference)) {
            return Double.NEGATIVE_INFINITY;
        }
        VFeaturePathDomainModelReference vFeaturePathDomainModelReference = (VFeaturePathDomainModelReference)domainModelReference;
        EStructuralFeature domainModelEFeature = vFeaturePathDomainModelReference.getDomainModelEFeature();
        if (domainModelEFeature == null) {
            return Double.NEGATIVE_INFINITY;
        }
        if (BasisAttributeSetting.hasWertFeature(domainModelEFeature.getEType())) {
            return 100.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    private boolean isLinked(EObject object) {
        if (object == null) {
            return false;
        }
        if (object instanceof PlanPro_Schnittstelle) {
            return true;
        }
        return this.isLinked(object.eContainer());
    }

    @Reference(unbind="-")
    protected void setEMFFormsDatabinding(EMFFormsDatabindingEMF emfFormsDatabinding) {
        super.setEMFFormsDatabinding(emfFormsDatabinding);
    }

    @Reference(unbind="-")
    protected void setReportService(ReportService reportService) {
        super.setReportService(reportService);
    }
}

