/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.emfforms.basisattribute;

import java.util.Calendar;
import java.util.Optional;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.internal.core.swt.renderer.XMLDateControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.util.swt.ImageRegistryService;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.locale.EMFFormsLocaleProvider;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.editsupport.EMFFormsEditSupport;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.localization.EMFFormsLocalizationService;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.core.services.viewmodel.ToolboxViewModelService;
import org.eclipse.set.emfforms.basisattribute.BasisAttributeBinding;
import org.eclipse.set.emfforms.basisattribute.BasisAttributeRenderer;
import org.eclipse.set.emfforms.basisattribute.BasisAttributeSetting;
import org.eclipse.set.utils.CalendarTextConversion;
import org.eclipse.set.utils.emfforms.Annotations;
import org.eclipse.set.utils.emfforms.Renderers;
import org.eclipse.set.utils.emfforms.ToolboxRenderer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TypedListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasisAttributeDateRenderer
extends XMLDateControlSWTRenderer
implements ToolboxRenderer,
BasisAttributeRenderer<XMLGregorianCalendar> {
    private static final String EMPTY_TEXT = "";
    private static final Logger LOGGER = LoggerFactory.getLogger(BasisAttributeDateRenderer.class);
    private final BasisAttributeSetting<XMLGregorianCalendar> basisAttributeSetting;
    private final BasisAttributeBinding<XMLGregorianCalendar> binding;
    private Button dateButton;
    private Text dateText;
    private FocusAdapter focusListener;
    private Optional<Consumer<Text>> optionalTextConsumer;
    private final EObject parent;
    Optional<DateTime> dateTime;
    Shell dialog;
    final EMFFormsLocaleProvider localeProvider;

    public static boolean isApplicable(EClassifier type) {
        return BasisAttributeSetting.isWertFeatureTypeAssignableTo(type, XMLGregorianCalendar.class);
    }

    @Inject
    public BasisAttributeDateRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, EMFFormsEditSupport emfFormsEditSupport, EMFFormsLocalizationService localizationService, EMFFormsLocaleProvider localeProvider, ImageRegistryService imageRegistryService) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider, emfFormsEditSupport, localizationService, localeProvider, imageRegistryService);
        LOGGER.debug("Render {}", (Object)vElement);
        this.localeProvider = localeProvider;
        this.basisAttributeSetting = new BasisAttributeSetting<XMLGregorianCalendar>(XMLGregorianCalendar.class, vElement, viewContext);
        this.parent = this.basisAttributeSetting.getParent();
        this.binding = new BasisAttributeBinding<XMLGregorianCalendar>(this);
        ToolboxViewModelService toolboxViewModelService = Services.getToolboxViewModelService();
        String textConsumerName = Annotations.getViewModelValue((VElement)vElement, (String)"textConsumer");
        if (textConsumerName != null) {
            Consumer consumer = (Consumer)toolboxViewModelService.get(textConsumerName);
            this.optionalTextConsumer = Optional.of(consumer);
        } else {
            this.optionalTextConsumer = Optional.empty();
        }
    }

    public void checkToolboxRenderer() {
        this.checkRenderer();
    }

    @Override
    public BasisAttributeSetting<XMLGregorianCalendar> getBasisAttributeSetting() {
        return this.basisAttributeSetting;
    }

    @Override
    public Control getControl() {
        return this.dateText;
    }

    @Override
    public EObject getParent() {
        return this.parent;
    }

    @Override
    public boolean isDisposed() {
        return Renderers.isDisposed((ToolboxRenderer)this);
    }

    @Override
    public void updateControl() {
        Optional<XMLGregorianCalendar> modelWert = this.getModelWert();
        if (!modelWert.isPresent() && this.dateText.isFocusControl()) {
            return;
        }
        if (modelWert.isPresent()) {
            String controlWertText;
            String modelWertText = CalendarTextConversion.getText((XMLGregorianCalendar)modelWert.get());
            if (!modelWertText.equals(controlWertText = this.dateText.getText())) {
                Point selection = this.dateText.getSelection();
                this.dateText.setText(modelWertText);
                this.dateText.setSelection(selection);
                LOGGER.debug("Updated control text to \"{}\".", (Object)modelWertText);
            }
        } else {
            this.clearText();
        }
    }

    @Override
    public void updateModel() {
        Optional<XMLGregorianCalendar> controlWert;
        Optional<XMLGregorianCalendar> modelWert = this.getModelWert();
        if (!modelWert.equals(controlWert = this.getControlWert())) {
            if (this.isRemoveable(controlWert)) {
                this.basisAttributeSetting.removeBasisAttribute();
                LOGGER.debug("Basis attribute removed.");
            } else {
                this.updateBasisAttributeWert(controlWert);
                LOGGER.debug("Updated wert to \"{}\".", controlWert.orElse(null));
            }
        }
    }

    @Override
    public Optional<XMLGregorianCalendar> valueOf(String representation) {
        return CalendarTextConversion.getCalendar((String)representation);
    }

    private Optional<XMLGregorianCalendar> getControlWert() {
        return CalendarTextConversion.getCalendar((String)this.dateText.getText());
    }

    private boolean isRemoveable(Optional<XMLGregorianCalendar> controlWert) {
        return !controlWert.isPresent() && !this.basisAttributeSetting.hasContents();
    }

    private void updateBasisAttributeWert(Optional<XMLGregorianCalendar> controlWert) {
        if (this.basisAttributeSetting.updateValue(controlWert.orElse(null))) {
            this.binding.unbind();
            this.binding.bind();
        }
    }

    protected Binding[] createBindings(Control control) throws DatabindingFailedException {
        this.dateText = (Text)((Composite)((Composite)control).getChildren()[0]).getChildren()[0];
        this.binding.bind();
        this.focusListener = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!BasisAttributeDateRenderer.this.getModelWert().isPresent()) {
                    BasisAttributeDateRenderer.this.clearText();
                } else {
                    BasisAttributeDateRenderer.this.updateControl();
                }
            }
        };
        this.dateText.addFocusListener((FocusListener)this.focusListener);
        this.dateButton = (Button)((Composite)control).getChildren()[1];
        Listener[] listeners = this.dateButton.getListeners(13);
        Assert.isTrue((listeners.length == 1 ? 1 : 0) != 0);
        TypedListener listener = (TypedListener)listeners[0];
        SelectionListener selectionListener = (SelectionListener)listener.getEventListener();
        this.dateButton.removeSelectionListener(selectionListener);
        this.dateButton.addSelectionListener((SelectionListener)new DateButtonSelectionListener(this.dateButton));
        if (this.optionalTextConsumer.isPresent()) {
            Consumer<Text> textConsumer = this.optionalTextConsumer.get();
            textConsumer.accept(this.dateText);
        }
        return new Binding[0];
    }

    protected void dispose() {
        super.dispose();
        this.dateText.removeFocusListener((FocusListener)this.focusListener);
    }

    void clearText() {
        this.dateText.setText(EMPTY_TEXT);
        LOGGER.debug("Removed control text.");
    }

    Optional<XMLGregorianCalendar> getModelWert() {
        return this.basisAttributeSetting.getWertValue();
    }

    void updateModelFromDateTime() {
        Optional calendar = CalendarTextConversion.getCalendar((DateTime)this.dateTime.get());
        Optional<XMLGregorianCalendar> modelWert = this.getModelWert();
        if (!modelWert.equals(calendar)) {
            if (this.isRemoveable(calendar)) {
                this.basisAttributeSetting.removeBasisAttribute();
                LOGGER.debug("Basis attribute removed.");
            } else {
                this.updateBasisAttributeWert(calendar);
                LOGGER.debug("Updated wert to \"{}\".", calendar.orElse(null));
            }
        }
    }

    private final class DateButtonSelectionListener
    extends SelectionAdapter {
        private final Button button;

        public DateButtonSelectionListener(Button button) {
            this.button = button;
        }

        public void widgetSelected(SelectionEvent e) {
            if (BasisAttributeDateRenderer.this.dialog != null && !BasisAttributeDateRenderer.this.dialog.isDisposed()) {
                BasisAttributeDateRenderer.this.dialog.dispose();
                return;
            }
            BasisAttributeDateRenderer.this.dialog = new Shell(this.button.getShell(), 0);
            BasisAttributeDateRenderer.this.dialog.setLayout((Layout)new GridLayout(1, false));
            BasisAttributeDateRenderer.this.dateTime = Optional.of(new DateTime((Composite)BasisAttributeDateRenderer.this.dialog, 3072));
            XMLGregorianCalendar gregorianCalendar = BasisAttributeDateRenderer.this.getModelWert().orElse(null);
            Calendar cal = Calendar.getInstance(BasisAttributeDateRenderer.this.localeProvider.getLocale());
            if (gregorianCalendar != null) {
                cal.setTime(gregorianCalendar.toGregorianCalendar().getTime());
            }
            BasisAttributeDateRenderer.this.dateTime.get().setDate(cal.get(1), cal.get(2), cal.get(5));
            Button okButton = new Button((Composite)BasisAttributeDateRenderer.this.dialog, 8);
            okButton.setText(JFaceResources.getString((String)"ok"));
            GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).grab(false, false).applyTo((Control)okButton);
            okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e1) {
                    BasisAttributeDateRenderer.this.updateModelFromDateTime();
                    ((DateButtonSelectionListener)DateButtonSelectionListener.this).BasisAttributeDateRenderer.this.dialog.close();
                }
            });
            BasisAttributeDateRenderer.this.dialog.pack();
            BasisAttributeDateRenderer.this.dialog.layout();
            Point dialogSize = BasisAttributeDateRenderer.this.dialog.getSize();
            Rectangle displayBounds = BasisAttributeDateRenderer.this.dialog.getDisplay().getBounds();
            Point buttonLocation = this.button.toDisplay(this.button.getSize().x, this.button.getSize().y);
            int dialogX = buttonLocation.x - dialogSize.x;
            int dialogY = buttonLocation.y;
            if (dialogY + dialogSize.y > displayBounds.height) {
                dialogY = dialogY - this.button.getSize().y - dialogSize.y;
            }
            if (dialogX + dialogSize.x > displayBounds.width) {
                dialogX -= dialogSize.x;
            } else if (dialogX - dialogSize.x < displayBounds.x) {
                dialogX = buttonLocation.x - this.button.getSize().x;
            }
            BasisAttributeDateRenderer.this.dialog.setLocation(dialogX, dialogY);
            BasisAttributeDateRenderer.this.dialog.open();
        }
    }
}

