/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.validation.table;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.set.feature.validation.Messages;
import org.eclipse.set.feature.validation.table.ValidationTableTransformationService;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.validationreport.ValidationProblem;
import org.eclipse.set.model.validationreport.ValidationReport;
import org.eclipse.set.utils.BasePart;
import org.eclipse.set.utils.table.menu.TableMenuService;
import org.eclipse.set.utils.table.tree.AbstractTreeLayerTable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ValidationTableView
extends AbstractTreeLayerTable {
    private final Messages messages;
    private final BasePart part;
    private NatTable natTable;
    private final TableMenuService tableMenuService;

    public ValidationTableView(BasePart part, Messages messages, TableMenuService tableMenuService) {
        this.part = part;
        this.messages = messages;
        this.tableMenuService = tableMenuService;
    }

    public Control create(Composite parent, ValidationReport validationReport) {
        ValidationTableTransformationService service = new ValidationTableTransformationService(this.messages);
        Table table = service.transform(validationReport);
        this.createTableBodyData(table, rowIndex -> ((ValidationProblem)validationReport.getProblems().get(rowIndex - 1)).getLineNumber());
        this.tableMenuService.createDefaultMenuItems(this.part, table, (IDataProvider)this.bodyDataProvider, this.bodyLayerStack.getSelectionLayer());
        this.natTable = this.createTable(parent, table, this.tableMenuService);
        return this.natTable;
    }

    public void updateView(ValidationReport validationReport) {
        ValidationTableTransformationService service = new ValidationTableTransformationService(this.messages);
        this.bodyDataProvider.refresh(service.transform(validationReport));
        this.natTable.refresh();
    }
}

