/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.validation.service;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Function;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.set.basis.PlanProSchemaDir;
import org.eclipse.set.basis.ResourceLoader;
import org.eclipse.set.basis.constants.ValidationResult;
import org.eclipse.set.basis.files.ToolboxFile;
import org.eclipse.set.core.services.validation.CustomValidator;
import org.eclipse.set.core.services.validation.ValidationService;
import org.eclipse.set.model.model11001.PlanPro.DocumentRoot;
import org.eclipse.set.toolboxmodel.Layoutinformationen.PlanPro_Layoutinfo;
import org.eclipse.set.toolboxmodel.PlanPro.PlanPro_Schnittstelle;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class ValidationServiceImpl
implements ValidationService {
    private final List<CustomValidator> customValidators = Lists.newLinkedList();

    public void addCustomValidator(CustomValidator validator) {
        this.customValidators.add(validator);
    }

    public ValidationResult validateSource(ValidationResult result, ToolboxFile toolboxFile) {
        Class sourceClass = result.getValidatedSourceClass();
        if (sourceClass == null) {
            return result;
        }
        if (sourceClass.isAssignableFrom(PlanPro_Schnittstelle.class)) {
            this.validateSchnittstelle(toolboxFile, result);
        } else if (sourceClass.isAssignableFrom(PlanPro_Layoutinfo.class)) {
            this.validateLayoutinfo(toolboxFile, result);
        }
        return result;
    }

    private void validateSchnittstelle(ToolboxFile toolboxFile, ValidationResult result) {
        this.xsdValidation(toolboxFile.getModelPath(), result);
        DocumentRoot planProSourceModel = toolboxFile.getPlanProSourceModel();
        if (planProSourceModel != null) {
            this.emfValidation(planProSourceModel.getPlanProSchnittstelle(), result);
        }
        this.customValidation(toolboxFile, result);
    }

    private void validateLayoutinfo(ToolboxFile toolboxFile, ValidationResult result) {
        this.xsdValidation(toolboxFile.getLayoutPath(), result);
        org.eclipse.set.model.model11001.Layoutinformationen.DocumentRoot layoutSourceModel = toolboxFile.getLayoutSourceModel();
        if (layoutSourceModel != null) {
            this.emfValidation(layoutSourceModel.getPlanProLayoutinfo(), result);
        }
        this.customValidation(toolboxFile, result);
    }

    public <T extends EObject> T checkLoad(ToolboxFile toolboxFile, ResourceLoader resourceLoader, Function<Resource, T> provider, ValidationResult result) {
        try {
            Resource resource = resourceLoader.load(toolboxFile.getModelPath());
            return (T)((EObject)provider.apply(resource));
        }
        catch (Exception e) {
            result.addIoError(e);
            return null;
        }
    }

    public ValidationResult customValidation(ToolboxFile toolboxFile, ValidationResult result) {
        this.customValidators.forEach(validator -> validator.validate(toolboxFile, result));
        return result;
    }

    public <T extends EObject> ValidationResult emfValidation(T object, ValidationResult result) {
        if (object != null) {
            Diagnostic diagnostic = Diagnostician.INSTANCE.validate(object);
            result.put(diagnostic);
        }
        return result;
    }

    public void removeCustomValidator(CustomValidator validator) {
        this.customValidators.remove(validator);
    }

    public ValidationResult xsdValidation(Path sourcePath, final ValidationResult result) {
        if (sourcePath == null || !sourcePath.toFile().exists()) {
            return result;
        }
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
            // empty catch block
        }
        factory.setResourceResolver(PlanProSchemaDir.getResourceResolver());
        try {
            Schema schema = factory.newSchema(PlanProSchemaDir.getSchemas());
            Validator validator = schema.newValidator();
            validator.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    result.addXsdError(exception);
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    throw exception;
                }

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    result.addXsdWarning(exception);
                }
            });
            validator.validate(new StreamSource(sourcePath.toFile()));
            result.setPassedXsdValidation(true);
        }
        catch (SAXParseException e) {
            result.addXsdError(e);
        }
        catch (IOException | SAXException e) {
            result.addIoError(e);
        }
        return result;
    }
}

