/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.validation.parts;

import javax.inject.Inject;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.emf.ecp.ui.view.ECPRendererException;
import org.eclipse.set.core.services.enumtranslation.EnumTranslationService;
import org.eclipse.set.core.services.version.PlanProVersionService;
import org.eclipse.set.feature.validation.Messages;
import org.eclipse.set.feature.validation.parts.ValidationPart;
import org.eclipse.set.feature.validation.report.SessionToValidationReportTransformation;
import org.eclipse.set.feature.validation.table.ValidationTableView;
import org.eclipse.set.model.validationreport.ValidationReport;
import org.eclipse.set.utils.BasePart;
import org.eclipse.set.utils.SelectableAction;
import org.eclipse.set.utils.emfforms.AbstractEmfFormsPart;
import org.eclipse.set.utils.table.menu.TableMenuService;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;

public class ValidationTablePart
extends AbstractEmfFormsPart {
    @Inject
    @Translation
    private Messages messages;
    @Inject
    private PlanProVersionService versionService;
    @Inject
    private TableMenuService tableMenuService;
    @Inject
    private EnumTranslationService enumTranslationService;

    @Inject
    public ValidationTablePart() {
    }

    protected void createFormsView(Composite parent) throws ECPRendererException {
        SessionToValidationReportTransformation transformation = new SessionToValidationReportTransformation(this.messages, this.versionService, this.enumTranslationService);
        final ValidationReport validationReport = transformation.transform(this.getModelSession());
        this.getBanderole().setExportAction(new SelectableAction(){

            public void selected(SelectionEvent e) {
                ValidationTablePart.this.export(validationReport);
            }

            public String getText() {
                return ValidationTablePart.this.messages.ExportValidationMsg;
            }
        });
        ValidationTableView tableView = new ValidationTableView((BasePart)this, this.messages, this.tableMenuService);
        tableView.create(parent, validationReport);
        tableView.createExpandCollapseAllButton((Composite)this.getBanderole().getControl(), this.messages.ValidationTable_ExpandAllGroup, this.messages.ValidationTable_CollapseAllGroup);
    }

    protected void export(ValidationReport report) {
        ValidationPart.exportValidation((BasePart)this, this.messages, report);
    }
}

