/**
 * Copyright (c) 2023 DB Netz AG and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 * 
 */
package org.eclipse.set.model.model11001.Bahnuebergang;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>ENUM Optik Symbol</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.set.model.model11001.Bahnuebergang.BahnuebergangPackage#getENUMOptikSymbol()
 * @model extendedMetaData="name='ENUMOptik_Symbol'"
 * @generated
 */
public enum ENUMOptikSymbol implements Enumerator {
	/**
	 * The '<em><b>ENUM Optik Symbol Fussgaenger</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_OPTIK_SYMBOL_FUSSGAENGER_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_OPTIK_SYMBOL_FUSSGAENGER(0, "ENUMOptik_Symbol_Fussgaenger", "Fussgaenger"),

	/**
	 * The '<em><b>ENUM Optik Symbol Fussgaenger Radfahrer</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_OPTIK_SYMBOL_FUSSGAENGER_RADFAHRER_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_OPTIK_SYMBOL_FUSSGAENGER_RADFAHRER(1, "ENUMOptik_Symbol_Fussgaenger_Radfahrer", "Fussgaenger_Radfahrer"),

	/**
	 * The '<em><b>ENUM Optik Symbol Pfeil links</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_OPTIK_SYMBOL_PFEIL_LINKS_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_OPTIK_SYMBOL_PFEIL_LINKS(2, "ENUMOptik_Symbol_Pfeil_links", "Pfeil_links"),

	/**
	 * The '<em><b>ENUM Optik Symbol Pfeil rechts</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_OPTIK_SYMBOL_PFEIL_RECHTS_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_OPTIK_SYMBOL_PFEIL_RECHTS(3, "ENUMOptik_Symbol_Pfeil_rechts", "Pfeil_rechts"),

	/**
	 * The '<em><b>ENUM Optik Symbol Radfahrer</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_OPTIK_SYMBOL_RADFAHRER_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_OPTIK_SYMBOL_RADFAHRER(4, "ENUMOptik_Symbol_Radfahrer", "Radfahrer"),

	/**
	 * The '<em><b>ENUM Optik Symbol sonstige</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_OPTIK_SYMBOL_SONSTIGE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_OPTIK_SYMBOL_SONSTIGE(5, "ENUMOptik_Symbol_sonstige", "sonstige");

	/**
	 * The '<em><b>ENUM Optik Symbol Fussgaenger</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_OPTIK_SYMBOL_FUSSGAENGER
	 * @model name="ENUMOptik_Symbol_Fussgaenger" literal="Fussgaenger"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_OPTIK_SYMBOL_FUSSGAENGER_VALUE = 0;

	/**
	 * The '<em><b>ENUM Optik Symbol Fussgaenger Radfahrer</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_OPTIK_SYMBOL_FUSSGAENGER_RADFAHRER
	 * @model name="ENUMOptik_Symbol_Fussgaenger_Radfahrer" literal="Fussgaenger_Radfahrer"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_OPTIK_SYMBOL_FUSSGAENGER_RADFAHRER_VALUE = 1;

	/**
	 * The '<em><b>ENUM Optik Symbol Pfeil links</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_OPTIK_SYMBOL_PFEIL_LINKS
	 * @model name="ENUMOptik_Symbol_Pfeil_links" literal="Pfeil_links"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_OPTIK_SYMBOL_PFEIL_LINKS_VALUE = 2;

	/**
	 * The '<em><b>ENUM Optik Symbol Pfeil rechts</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_OPTIK_SYMBOL_PFEIL_RECHTS
	 * @model name="ENUMOptik_Symbol_Pfeil_rechts" literal="Pfeil_rechts"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_OPTIK_SYMBOL_PFEIL_RECHTS_VALUE = 3;

	/**
	 * The '<em><b>ENUM Optik Symbol Radfahrer</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_OPTIK_SYMBOL_RADFAHRER
	 * @model name="ENUMOptik_Symbol_Radfahrer" literal="Radfahrer"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_OPTIK_SYMBOL_RADFAHRER_VALUE = 4;

	/**
	 * The '<em><b>ENUM Optik Symbol sonstige</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_OPTIK_SYMBOL_SONSTIGE
	 * @model name="ENUMOptik_Symbol_sonstige" literal="sonstige"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_OPTIK_SYMBOL_SONSTIGE_VALUE = 5;

	/**
	 * An array of all the '<em><b>ENUM Optik Symbol</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final ENUMOptikSymbol[] VALUES_ARRAY =
		new ENUMOptikSymbol[] {
			ENUM_OPTIK_SYMBOL_FUSSGAENGER,
			ENUM_OPTIK_SYMBOL_FUSSGAENGER_RADFAHRER,
			ENUM_OPTIK_SYMBOL_PFEIL_LINKS,
			ENUM_OPTIK_SYMBOL_PFEIL_RECHTS,
			ENUM_OPTIK_SYMBOL_RADFAHRER,
			ENUM_OPTIK_SYMBOL_SONSTIGE,
		};

	/**
	 * A public read-only list of all the '<em><b>ENUM Optik Symbol</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<ENUMOptikSymbol> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>ENUM Optik Symbol</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMOptikSymbol get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMOptikSymbol result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUM Optik Symbol</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMOptikSymbol getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMOptikSymbol result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUM Optik Symbol</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMOptikSymbol get(int value) {
		switch (value) {
			case ENUM_OPTIK_SYMBOL_FUSSGAENGER_VALUE: return ENUM_OPTIK_SYMBOL_FUSSGAENGER;
			case ENUM_OPTIK_SYMBOL_FUSSGAENGER_RADFAHRER_VALUE: return ENUM_OPTIK_SYMBOL_FUSSGAENGER_RADFAHRER;
			case ENUM_OPTIK_SYMBOL_PFEIL_LINKS_VALUE: return ENUM_OPTIK_SYMBOL_PFEIL_LINKS;
			case ENUM_OPTIK_SYMBOL_PFEIL_RECHTS_VALUE: return ENUM_OPTIK_SYMBOL_PFEIL_RECHTS;
			case ENUM_OPTIK_SYMBOL_RADFAHRER_VALUE: return ENUM_OPTIK_SYMBOL_RADFAHRER;
			case ENUM_OPTIK_SYMBOL_SONSTIGE_VALUE: return ENUM_OPTIK_SYMBOL_SONSTIGE;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private ENUMOptikSymbol(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //ENUMOptikSymbol
