/**
 * Copyright (c) 2023 DB Netz AG and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 * 
 */
package org.eclipse.set.model.model11001.Regelzeichnung.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.set.model.model11001.Regelzeichnung.util.RegelzeichnungAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class RegelzeichnungItemProviderAdapterFactory extends RegelzeichnungAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RegelzeichnungItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Regelzeichnung.Bild_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bild_TypeClassItemProvider bild_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Regelzeichnung.Bild_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBild_TypeClassAdapter() {
		if (bild_TypeClassItemProvider == null) {
			bild_TypeClassItemProvider = new Bild_TypeClassItemProvider(this);
		}

		return bild_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Regelzeichnung.Regelzeichnung} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RegelzeichnungItemProvider regelzeichnungItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Regelzeichnung.Regelzeichnung}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRegelzeichnungAdapter() {
		if (regelzeichnungItemProvider == null) {
			regelzeichnungItemProvider = new RegelzeichnungItemProvider(this);
		}

		return regelzeichnungItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Regelzeichnung.Regelzeichnung_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Regelzeichnung_Allg_AttributeGroupItemProvider regelzeichnung_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Regelzeichnung.Regelzeichnung_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRegelzeichnung_Allg_AttributeGroupAdapter() {
		if (regelzeichnung_Allg_AttributeGroupItemProvider == null) {
			regelzeichnung_Allg_AttributeGroupItemProvider = new Regelzeichnung_Allg_AttributeGroupItemProvider(this);
		}

		return regelzeichnung_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Regelzeichnung.Regelzeichnung_Parameter} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Regelzeichnung_ParameterItemProvider regelzeichnung_ParameterItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Regelzeichnung.Regelzeichnung_Parameter}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRegelzeichnung_ParameterAdapter() {
		if (regelzeichnung_ParameterItemProvider == null) {
			regelzeichnung_ParameterItemProvider = new Regelzeichnung_ParameterItemProvider(this);
		}

		return regelzeichnung_ParameterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Regelzeichnung.Regelzeichnung_Parameter_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Regelzeichnung_Parameter_Allg_AttributeGroupItemProvider regelzeichnung_Parameter_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Regelzeichnung.Regelzeichnung_Parameter_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRegelzeichnung_Parameter_Allg_AttributeGroupAdapter() {
		if (regelzeichnung_Parameter_Allg_AttributeGroupItemProvider == null) {
			regelzeichnung_Parameter_Allg_AttributeGroupItemProvider = new Regelzeichnung_Parameter_Allg_AttributeGroupItemProvider(this);
		}

		return regelzeichnung_Parameter_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Regelzeichnung.RZ_Nummer_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RZ_Nummer_TypeClassItemProvider rZ_Nummer_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Regelzeichnung.RZ_Nummer_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRZ_Nummer_TypeClassAdapter() {
		if (rZ_Nummer_TypeClassItemProvider == null) {
			rZ_Nummer_TypeClassItemProvider = new RZ_Nummer_TypeClassItemProvider(this);
		}

		return rZ_Nummer_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Regelzeichnung.RZ_Parameter_Name_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RZ_Parameter_Name_TypeClassItemProvider rZ_Parameter_Name_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Regelzeichnung.RZ_Parameter_Name_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRZ_Parameter_Name_TypeClassAdapter() {
		if (rZ_Parameter_Name_TypeClassItemProvider == null) {
			rZ_Parameter_Name_TypeClassItemProvider = new RZ_Parameter_Name_TypeClassItemProvider(this);
		}

		return rZ_Parameter_Name_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Regelzeichnung.RZ_Parameter_Wert_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RZ_Parameter_Wert_TypeClassItemProvider rZ_Parameter_Wert_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Regelzeichnung.RZ_Parameter_Wert_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRZ_Parameter_Wert_TypeClassAdapter() {
		if (rZ_Parameter_Wert_TypeClassItemProvider == null) {
			rZ_Parameter_Wert_TypeClassItemProvider = new RZ_Parameter_Wert_TypeClassItemProvider(this);
		}

		return rZ_Parameter_Wert_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Regelzeichnung.Titel_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Titel_TypeClassItemProvider titel_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Regelzeichnung.Titel_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTitel_TypeClassAdapter() {
		if (titel_TypeClassItemProvider == null) {
			titel_TypeClassItemProvider = new Titel_TypeClassItemProvider(this);
		}

		return titel_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Regelzeichnung.Untertitel_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Untertitel_TypeClassItemProvider untertitel_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Regelzeichnung.Untertitel_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUntertitel_TypeClassAdapter() {
		if (untertitel_TypeClassItemProvider == null) {
			untertitel_TypeClassItemProvider = new Untertitel_TypeClassItemProvider(this);
		}

		return untertitel_TypeClassItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose() {
		if (bild_TypeClassItemProvider != null) bild_TypeClassItemProvider.dispose();
		if (regelzeichnungItemProvider != null) regelzeichnungItemProvider.dispose();
		if (regelzeichnung_Allg_AttributeGroupItemProvider != null) regelzeichnung_Allg_AttributeGroupItemProvider.dispose();
		if (regelzeichnung_ParameterItemProvider != null) regelzeichnung_ParameterItemProvider.dispose();
		if (regelzeichnung_Parameter_Allg_AttributeGroupItemProvider != null) regelzeichnung_Parameter_Allg_AttributeGroupItemProvider.dispose();
		if (rZ_Nummer_TypeClassItemProvider != null) rZ_Nummer_TypeClassItemProvider.dispose();
		if (rZ_Parameter_Name_TypeClassItemProvider != null) rZ_Parameter_Name_TypeClassItemProvider.dispose();
		if (rZ_Parameter_Wert_TypeClassItemProvider != null) rZ_Parameter_Wert_TypeClassItemProvider.dispose();
		if (titel_TypeClassItemProvider != null) titel_TypeClassItemProvider.dispose();
		if (untertitel_TypeClassItemProvider != null) untertitel_TypeClassItemProvider.dispose();
	}

}
