/**
 * Copyright (c) 2023 DB Netz AG and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 * 
 */
package org.eclipse.set.model.model11001.Balisentechnik_ETCS.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.set.model.model11001.Balisentechnik_ETCS.util.Balisentechnik_ETCSAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class Balisentechnik_ETCSItemProviderAdapterFactory extends Balisentechnik_ETCSAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Balisentechnik_ETCSItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Abstand_Bes_Langer_Einfahrweg_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Abstand_Bes_Langer_Einfahrweg_TypeClassItemProvider abstand_Bes_Langer_Einfahrweg_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Abstand_Bes_Langer_Einfahrweg_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAbstand_Bes_Langer_Einfahrweg_TypeClassAdapter() {
		if (abstand_Bes_Langer_Einfahrweg_TypeClassItemProvider == null) {
			abstand_Bes_Langer_Einfahrweg_TypeClassItemProvider = new Abstand_Bes_Langer_Einfahrweg_TypeClassItemProvider(this);
		}

		return abstand_Bes_Langer_Einfahrweg_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Abstand_Datenpunkt_EH_EM_Folgesignal_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Abstand_Datenpunkt_EH_EM_Folgesignal_TypeClassItemProvider abstand_Datenpunkt_EH_EM_Folgesignal_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Abstand_Datenpunkt_EH_EM_Folgesignal_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAbstand_Datenpunkt_EH_EM_Folgesignal_TypeClassAdapter() {
		if (abstand_Datenpunkt_EH_EM_Folgesignal_TypeClassItemProvider == null) {
			abstand_Datenpunkt_EH_EM_Folgesignal_TypeClassItemProvider = new Abstand_Datenpunkt_EH_EM_Folgesignal_TypeClassItemProvider(this);
		}

		return abstand_Datenpunkt_EH_EM_Folgesignal_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Abstand_Datenpunkt_EP_TPI_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Abstand_Datenpunkt_EP_TPI_TypeClassItemProvider abstand_Datenpunkt_EP_TPI_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Abstand_Datenpunkt_EP_TPI_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAbstand_Datenpunkt_EP_TPI_TypeClassAdapter() {
		if (abstand_Datenpunkt_EP_TPI_TypeClassItemProvider == null) {
			abstand_Datenpunkt_EP_TPI_TypeClassItemProvider = new Abstand_Datenpunkt_EP_TPI_TypeClassItemProvider(this);
		}

		return abstand_Datenpunkt_EP_TPI_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Abstand_Datenpunkt_TPI_Folgesignal_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Abstand_Datenpunkt_TPI_Folgesignal_TypeClassItemProvider abstand_Datenpunkt_TPI_Folgesignal_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Abstand_Datenpunkt_TPI_Folgesignal_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAbstand_Datenpunkt_TPI_Folgesignal_TypeClassAdapter() {
		if (abstand_Datenpunkt_TPI_Folgesignal_TypeClassItemProvider == null) {
			abstand_Datenpunkt_TPI_Folgesignal_TypeClassItemProvider = new Abstand_Datenpunkt_TPI_Folgesignal_TypeClassItemProvider(this);
		}

		return abstand_Datenpunkt_TPI_Folgesignal_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Abstand_Einmesspunkt_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Abstand_Einmesspunkt_TypeClassItemProvider abstand_Einmesspunkt_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Abstand_Einmesspunkt_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAbstand_Einmesspunkt_TypeClassAdapter() {
		if (abstand_Einmesspunkt_TypeClassItemProvider == null) {
			abstand_Einmesspunkt_TypeClassItemProvider = new Abstand_Einmesspunkt_TypeClassItemProvider(this);
		}

		return abstand_Einmesspunkt_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Abstand_Grenze_Bereich_C_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Abstand_Grenze_Bereich_C_TypeClassItemProvider abstand_Grenze_Bereich_C_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Abstand_Grenze_Bereich_C_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAbstand_Grenze_Bereich_C_TypeClassAdapter() {
		if (abstand_Grenze_Bereich_C_TypeClassItemProvider == null) {
			abstand_Grenze_Bereich_C_TypeClassItemProvider = new Abstand_Grenze_Bereich_C_TypeClassItemProvider(this);
		}

		return abstand_Grenze_Bereich_C_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Abstand_Reduziert_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Abstand_Reduziert_TypeClassItemProvider abstand_Reduziert_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Abstand_Reduziert_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAbstand_Reduziert_TypeClassAdapter() {
		if (abstand_Reduziert_TypeClassItemProvider == null) {
			abstand_Reduziert_TypeClassItemProvider = new Abstand_Reduziert_TypeClassItemProvider(this);
		}

		return abstand_Reduziert_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Anlagenteil_Sonstige_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Anlagenteil_Sonstige_TypeClassItemProvider anlagenteil_Sonstige_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Anlagenteil_Sonstige_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAnlagenteil_Sonstige_TypeClassAdapter() {
		if (anlagenteil_Sonstige_TypeClassItemProvider == null) {
			anlagenteil_Sonstige_TypeClassItemProvider = new Anlagenteil_Sonstige_TypeClassItemProvider(this);
		}

		return anlagenteil_Sonstige_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Anordnung_Im_DP_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Anordnung_Im_DP_TypeClassItemProvider anordnung_Im_DP_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Anordnung_Im_DP_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAnordnung_Im_DP_TypeClassAdapter() {
		if (anordnung_Im_DP_TypeClassItemProvider == null) {
			anordnung_Im_DP_TypeClassItemProvider = new Anordnung_Im_DP_TypeClassItemProvider(this);
		}

		return anordnung_Im_DP_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Anwendung_ESG_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Anwendung_ESG_TypeClassItemProvider anwendung_ESG_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Anwendung_ESG_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAnwendung_ESG_TypeClassAdapter() {
		if (anwendung_ESG_TypeClassItemProvider == null) {
			anwendung_ESG_TypeClassItemProvider = new Anwendung_ESG_TypeClassItemProvider(this);
		}

		return anwendung_ESG_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Anwendung_GNT_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Anwendung_GNT_TypeClassItemProvider anwendung_GNT_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Anwendung_GNT_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAnwendung_GNT_TypeClassAdapter() {
		if (anwendung_GNT_TypeClassItemProvider == null) {
			anwendung_GNT_TypeClassItemProvider = new Anwendung_GNT_TypeClassItemProvider(this);
		}

		return anwendung_GNT_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Anwendung_Sonst_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Anwendung_Sonst_TypeClassItemProvider anwendung_Sonst_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Anwendung_Sonst_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAnwendung_Sonst_TypeClassAdapter() {
		if (anwendung_Sonst_TypeClassItemProvider == null) {
			anwendung_Sonst_TypeClassItemProvider = new Anwendung_Sonst_TypeClassItemProvider(this);
		}

		return anwendung_Sonst_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Anwendungssystem_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Anwendungssystem_TypeClassItemProvider anwendungssystem_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Anwendungssystem_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAnwendungssystem_TypeClassAdapter() {
		if (anwendungssystem_TypeClassItemProvider == null) {
			anwendungssystem_TypeClassItemProvider = new Anwendungssystem_TypeClassItemProvider(this);
		}

		return anwendungssystem_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Anzahl_Voll_LEU_Kalkuliert_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Anzahl_Voll_LEU_Kalkuliert_TypeClassItemProvider anzahl_Voll_LEU_Kalkuliert_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Anzahl_Voll_LEU_Kalkuliert_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAnzahl_Voll_LEU_Kalkuliert_TypeClassAdapter() {
		if (anzahl_Voll_LEU_Kalkuliert_TypeClassItemProvider == null) {
			anzahl_Voll_LEU_Kalkuliert_TypeClassItemProvider = new Anzahl_Voll_LEU_Kalkuliert_TypeClassItemProvider(this);
		}

		return anzahl_Voll_LEU_Kalkuliert_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Anzeigetext_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Anzeigetext_TypeClassItemProvider anzeigetext_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Anzeigetext_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAnzeigetext_TypeClassAdapter() {
		if (anzeigetext_TypeClassItemProvider == null) {
			anzeigetext_TypeClassItemProvider = new Anzeigetext_TypeClassItemProvider(this);
		}

		return anzeigetext_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Art_Bedingung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Art_Bedingung_TypeClassItemProvider art_Bedingung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Art_Bedingung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createArt_Bedingung_TypeClassAdapter() {
		if (art_Bedingung_TypeClassItemProvider == null) {
			art_Bedingung_TypeClassItemProvider = new Art_Bedingung_TypeClassItemProvider(this);
		}

		return art_Bedingung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Ausgang_Nr_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Ausgang_Nr_TypeClassItemProvider ausgang_Nr_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Ausgang_Nr_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAusgang_Nr_TypeClassAdapter() {
		if (ausgang_Nr_TypeClassItemProvider == null) {
			ausgang_Nr_TypeClassItemProvider = new Ausgang_Nr_TypeClassItemProvider(this);
		}

		return ausgang_Nr_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Ausrichtung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Ausrichtung_TypeClassItemProvider ausrichtung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Ausrichtung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAusrichtung_TypeClassAdapter() {
		if (ausrichtung_TypeClassItemProvider == null) {
			ausrichtung_TypeClassItemProvider = new Ausrichtung_TypeClassItemProvider(this);
		}

		return ausrichtung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Ausstieg_ETCS_Sperre_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Ausstieg_ETCS_Sperre_TypeClassItemProvider ausstieg_ETCS_Sperre_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Ausstieg_ETCS_Sperre_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAusstieg_ETCS_Sperre_TypeClassAdapter() {
		if (ausstieg_ETCS_Sperre_TypeClassItemProvider == null) {
			ausstieg_ETCS_Sperre_TypeClassItemProvider = new Ausstieg_ETCS_Sperre_TypeClassItemProvider(this);
		}

		return ausstieg_ETCS_Sperre_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Balise} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BaliseItemProvider baliseItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Balise}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBaliseAdapter() {
		if (baliseItemProvider == null) {
			baliseItemProvider = new BaliseItemProvider(this);
		}

		return baliseItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Balise_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Balise_Allg_AttributeGroupItemProvider balise_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Balise_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBalise_Allg_AttributeGroupAdapter() {
		if (balise_Allg_AttributeGroupItemProvider == null) {
			balise_Allg_AttributeGroupItemProvider = new Balise_Allg_AttributeGroupItemProvider(this);
		}

		return balise_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Balise_Geraetestand_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Balise_Geraetestand_TypeClassItemProvider balise_Geraetestand_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Balise_Geraetestand_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBalise_Geraetestand_TypeClassAdapter() {
		if (balise_Geraetestand_TypeClassItemProvider == null) {
			balise_Geraetestand_TypeClassItemProvider = new Balise_Geraetestand_TypeClassItemProvider(this);
		}

		return balise_Geraetestand_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Balisenhalter_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Balisenhalter_TypeClassItemProvider balisenhalter_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Balisenhalter_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBalisenhalter_TypeClassAdapter() {
		if (balisenhalter_TypeClassItemProvider == null) {
			balisenhalter_TypeClassItemProvider = new Balisenhalter_TypeClassItemProvider(this);
		}

		return balisenhalter_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Baseline_System_Version_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Baseline_System_Version_TypeClassItemProvider baseline_System_Version_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Baseline_System_Version_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBaseline_System_Version_TypeClassAdapter() {
		if (baseline_System_Version_TypeClassItemProvider == null) {
			baseline_System_Version_TypeClassItemProvider = new Baseline_System_Version_TypeClassItemProvider(this);
		}

		return baseline_System_Version_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bedingung_Besondere_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedingung_Besondere_AttributeGroupItemProvider bedingung_Besondere_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bedingung_Besondere_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedingung_Besondere_AttributeGroupAdapter() {
		if (bedingung_Besondere_AttributeGroupItemProvider == null) {
			bedingung_Besondere_AttributeGroupItemProvider = new Bedingung_Besondere_AttributeGroupItemProvider(this);
		}

		return bedingung_Besondere_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bedingung_PZB_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedingung_PZB_AttributeGroupItemProvider bedingung_PZB_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bedingung_PZB_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedingung_PZB_AttributeGroupAdapter() {
		if (bedingung_PZB_AttributeGroupItemProvider == null) {
			bedingung_PZB_AttributeGroupItemProvider = new Bedingung_PZB_AttributeGroupItemProvider(this);
		}

		return bedingung_PZB_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bedingung_Signal_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedingung_Signal_AttributeGroupItemProvider bedingung_Signal_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bedingung_Signal_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedingung_Signal_AttributeGroupAdapter() {
		if (bedingung_Signal_AttributeGroupItemProvider == null) {
			bedingung_Signal_AttributeGroupItemProvider = new Bedingung_Signal_AttributeGroupItemProvider(this);
		}

		return bedingung_Signal_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bedingung_Sonstige_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedingung_Sonstige_AttributeGroupItemProvider bedingung_Sonstige_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bedingung_Sonstige_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedingung_Sonstige_AttributeGroupAdapter() {
		if (bedingung_Sonstige_AttributeGroupItemProvider == null) {
			bedingung_Sonstige_AttributeGroupItemProvider = new Bedingung_Sonstige_AttributeGroupItemProvider(this);
		}

		return bedingung_Sonstige_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bedingung_Weiche_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedingung_Weiche_AttributeGroupItemProvider bedingung_Weiche_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bedingung_Weiche_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedingung_Weiche_AttributeGroupAdapter() {
		if (bedingung_Weiche_AttributeGroupItemProvider == null) {
			bedingung_Weiche_AttributeGroupItemProvider = new Bedingung_Weiche_AttributeGroupItemProvider(this);
		}

		return bedingung_Weiche_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bedingung_Weichenlage_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedingung_Weichenlage_TypeClassItemProvider bedingung_Weichenlage_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bedingung_Weichenlage_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedingung_Weichenlage_TypeClassAdapter() {
		if (bedingung_Weichenlage_TypeClassItemProvider == null) {
			bedingung_Weichenlage_TypeClassItemProvider = new Bedingung_Weichenlage_TypeClassItemProvider(this);
		}

		return bedingung_Weichenlage_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bez_Strecke_BTS_1_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bez_Strecke_BTS_1_TypeClassItemProvider bez_Strecke_BTS_1_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bez_Strecke_BTS_1_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBez_Strecke_BTS_1_TypeClassAdapter() {
		if (bez_Strecke_BTS_1_TypeClassItemProvider == null) {
			bez_Strecke_BTS_1_TypeClassItemProvider = new Bez_Strecke_BTS_1_TypeClassItemProvider(this);
		}

		return bez_Strecke_BTS_1_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bez_Strecke_BTS_2_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bez_Strecke_BTS_2_TypeClassItemProvider bez_Strecke_BTS_2_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bez_Strecke_BTS_2_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBez_Strecke_BTS_2_TypeClassAdapter() {
		if (bez_Strecke_BTS_2_TypeClassItemProvider == null) {
			bez_Strecke_BTS_2_TypeClassItemProvider = new Bez_Strecke_BTS_2_TypeClassItemProvider(this);
		}

		return bez_Strecke_BTS_2_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bez_Strecke_BTS_3_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bez_Strecke_BTS_3_TypeClassItemProvider bez_Strecke_BTS_3_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bez_Strecke_BTS_3_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBez_Strecke_BTS_3_TypeClassAdapter() {
		if (bez_Strecke_BTS_3_TypeClassItemProvider == null) {
			bez_Strecke_BTS_3_TypeClassItemProvider = new Bez_Strecke_BTS_3_TypeClassItemProvider(this);
		}

		return bez_Strecke_BTS_3_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bez_ZUB_Bereichsgrenze_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bez_ZUB_Bereichsgrenze_TypeClassItemProvider bez_ZUB_Bereichsgrenze_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bez_ZUB_Bereichsgrenze_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBez_ZUB_Bereichsgrenze_TypeClassAdapter() {
		if (bez_ZUB_Bereichsgrenze_TypeClassItemProvider == null) {
			bez_ZUB_Bereichsgrenze_TypeClassItemProvider = new Bez_ZUB_Bereichsgrenze_TypeClassItemProvider(this);
		}

		return bez_ZUB_Bereichsgrenze_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bezeichnung_ETCS_Kante_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bezeichnung_ETCS_Kante_TypeClassItemProvider bezeichnung_ETCS_Kante_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bezeichnung_ETCS_Kante_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBezeichnung_ETCS_Kante_TypeClassAdapter() {
		if (bezeichnung_ETCS_Kante_TypeClassItemProvider == null) {
			bezeichnung_ETCS_Kante_TypeClassItemProvider = new Bezeichnung_ETCS_Kante_TypeClassItemProvider(this);
		}

		return bezeichnung_ETCS_Kante_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bezeichnung_LEU_Anlage_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bezeichnung_LEU_Anlage_TypeClassItemProvider bezeichnung_LEU_Anlage_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bezeichnung_LEU_Anlage_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBezeichnung_LEU_Anlage_TypeClassAdapter() {
		if (bezeichnung_LEU_Anlage_TypeClassItemProvider == null) {
			bezeichnung_LEU_Anlage_TypeClassItemProvider = new Bezeichnung_LEU_Anlage_TypeClassItemProvider(this);
		}

		return bezeichnung_LEU_Anlage_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bezeichnung_ZUB_SE_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bezeichnung_ZUB_SE_TypeClassItemProvider bezeichnung_ZUB_SE_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bezeichnung_ZUB_SE_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBezeichnung_ZUB_SE_TypeClassAdapter() {
		if (bezeichnung_ZUB_SE_TypeClassItemProvider == null) {
			bezeichnung_ZUB_SE_TypeClassItemProvider = new Bezeichnung_ZUB_SE_TypeClassItemProvider(this);
		}

		return bezeichnung_ZUB_SE_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bezeichnung_ZUB_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bezeichnung_ZUB_TypeClassItemProvider bezeichnung_ZUB_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bezeichnung_ZUB_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBezeichnung_ZUB_TypeClassAdapter() {
		if (bezeichnung_ZUB_TypeClassItemProvider == null) {
			bezeichnung_ZUB_TypeClassItemProvider = new Bezeichnung_ZUB_TypeClassItemProvider(this);
		}

		return bezeichnung_ZUB_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bgrenze_Nach_ESG_Bed_Ausstieg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bgrenze_Nach_ESG_Bed_Ausstieg_AttributeGroupItemProvider bgrenze_Nach_ESG_Bed_Ausstieg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bgrenze_Nach_ESG_Bed_Ausstieg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBgrenze_Nach_ESG_Bed_Ausstieg_AttributeGroupAdapter() {
		if (bgrenze_Nach_ESG_Bed_Ausstieg_AttributeGroupItemProvider == null) {
			bgrenze_Nach_ESG_Bed_Ausstieg_AttributeGroupItemProvider = new Bgrenze_Nach_ESG_Bed_Ausstieg_AttributeGroupItemProvider(this);
		}

		return bgrenze_Nach_ESG_Bed_Ausstieg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bgrenze_Nach_L2_Bed_Einstieg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bgrenze_Nach_L2_Bed_Einstieg_AttributeGroupItemProvider bgrenze_Nach_L2_Bed_Einstieg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bgrenze_Nach_L2_Bed_Einstieg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBgrenze_Nach_L2_Bed_Einstieg_AttributeGroupAdapter() {
		if (bgrenze_Nach_L2_Bed_Einstieg_AttributeGroupItemProvider == null) {
			bgrenze_Nach_L2_Bed_Einstieg_AttributeGroupItemProvider = new Bgrenze_Nach_L2_Bed_Einstieg_AttributeGroupItemProvider(this);
		}

		return bgrenze_Nach_L2_Bed_Einstieg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bgrenze_Nach_LZB_Bed_Einstieg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bgrenze_Nach_LZB_Bed_Einstieg_AttributeGroupItemProvider bgrenze_Nach_LZB_Bed_Einstieg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bgrenze_Nach_LZB_Bed_Einstieg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBgrenze_Nach_LZB_Bed_Einstieg_AttributeGroupAdapter() {
		if (bgrenze_Nach_LZB_Bed_Einstieg_AttributeGroupItemProvider == null) {
			bgrenze_Nach_LZB_Bed_Einstieg_AttributeGroupItemProvider = new Bgrenze_Nach_LZB_Bed_Einstieg_AttributeGroupItemProvider(this);
		}

		return bgrenze_Nach_LZB_Bed_Einstieg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bgrenze_Nach_Ohne_Bed_Einstieg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bgrenze_Nach_Ohne_Bed_Einstieg_AttributeGroupItemProvider bgrenze_Nach_Ohne_Bed_Einstieg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bgrenze_Nach_Ohne_Bed_Einstieg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBgrenze_Nach_Ohne_Bed_Einstieg_AttributeGroupAdapter() {
		if (bgrenze_Nach_Ohne_Bed_Einstieg_AttributeGroupItemProvider == null) {
			bgrenze_Nach_Ohne_Bed_Einstieg_AttributeGroupItemProvider = new Bgrenze_Nach_Ohne_Bed_Einstieg_AttributeGroupItemProvider(this);
		}

		return bgrenze_Nach_Ohne_Bed_Einstieg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bgrenze_Nach_PZB_Bed_Einstieg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bgrenze_Nach_PZB_Bed_Einstieg_AttributeGroupItemProvider bgrenze_Nach_PZB_Bed_Einstieg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bgrenze_Nach_PZB_Bed_Einstieg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBgrenze_Nach_PZB_Bed_Einstieg_AttributeGroupAdapter() {
		if (bgrenze_Nach_PZB_Bed_Einstieg_AttributeGroupItemProvider == null) {
			bgrenze_Nach_PZB_Bed_Einstieg_AttributeGroupItemProvider = new Bgrenze_Nach_PZB_Bed_Einstieg_AttributeGroupItemProvider(this);
		}

		return bgrenze_Nach_PZB_Bed_Einstieg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bgrenze_Nach_ZBS_Bed_Einstieg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bgrenze_Nach_ZBS_Bed_Einstieg_AttributeGroupItemProvider bgrenze_Nach_ZBS_Bed_Einstieg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bgrenze_Nach_ZBS_Bed_Einstieg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBgrenze_Nach_ZBS_Bed_Einstieg_AttributeGroupAdapter() {
		if (bgrenze_Nach_ZBS_Bed_Einstieg_AttributeGroupItemProvider == null) {
			bgrenze_Nach_ZBS_Bed_Einstieg_AttributeGroupItemProvider = new Bgrenze_Nach_ZBS_Bed_Einstieg_AttributeGroupItemProvider(this);
		}

		return bgrenze_Nach_ZBS_Bed_Einstieg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bgrenze_RBC_Wechsel_BTS_Kette_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bgrenze_RBC_Wechsel_BTS_Kette_AttributeGroupItemProvider bgrenze_RBC_Wechsel_BTS_Kette_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Bgrenze_RBC_Wechsel_BTS_Kette_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBgrenze_RBC_Wechsel_BTS_Kette_AttributeGroupAdapter() {
		if (bgrenze_RBC_Wechsel_BTS_Kette_AttributeGroupItemProvider == null) {
			bgrenze_RBC_Wechsel_BTS_Kette_AttributeGroupItemProvider = new Bgrenze_RBC_Wechsel_BTS_Kette_AttributeGroupItemProvider(this);
		}

		return bgrenze_RBC_Wechsel_BTS_Kette_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Binaerdaten} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BinaerdatenItemProvider binaerdatenItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Binaerdaten}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBinaerdatenAdapter() {
		if (binaerdatenItemProvider == null) {
			binaerdatenItemProvider = new BinaerdatenItemProvider(this);
		}

		return binaerdatenItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Binaerdaten_Datei_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Binaerdaten_Datei_AttributeGroupItemProvider binaerdaten_Datei_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Binaerdaten_Datei_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBinaerdaten_Datei_AttributeGroupAdapter() {
		if (binaerdaten_Datei_AttributeGroupItemProvider == null) {
			binaerdaten_Datei_AttributeGroupItemProvider = new Binaerdaten_Datei_AttributeGroupItemProvider(this);
		}

		return binaerdaten_Datei_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.D_LEVELTR_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected D_LEVELTR_TypeClassItemProvider d_LEVELTR_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.D_LEVELTR_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createD_LEVELTR_TypeClassAdapter() {
		if (d_LEVELTR_TypeClassItemProvider == null) {
			d_LEVELTR_TypeClassItemProvider = new D_LEVELTR_TypeClassItemProvider(this);
		}

		return d_LEVELTR_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Dateiname_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Dateiname_TypeClassItemProvider dateiname_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Dateiname_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDateiname_TypeClassAdapter() {
		if (dateiname_TypeClassItemProvider == null) {
			dateiname_TypeClassItemProvider = new Dateiname_TypeClassItemProvider(this);
		}

		return dateiname_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Dateityp_Binaerdatei_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Dateityp_Binaerdatei_TypeClassItemProvider dateityp_Binaerdatei_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Dateityp_Binaerdatei_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDateityp_Binaerdatei_TypeClassAdapter() {
		if (dateityp_Binaerdatei_TypeClassItemProvider == null) {
			dateityp_Binaerdatei_TypeClassItemProvider = new Dateityp_Binaerdatei_TypeClassItemProvider(this);
		}

		return dateityp_Binaerdatei_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Daten_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Daten_TypeClassItemProvider daten_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Daten_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDaten_TypeClassAdapter() {
		if (daten_TypeClassItemProvider == null) {
			daten_TypeClassItemProvider = new Daten_TypeClassItemProvider(this);
		}

		return daten_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Datenpunkt} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DatenpunktItemProvider datenpunktItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Datenpunkt}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDatenpunktAdapter() {
		if (datenpunktItemProvider == null) {
			datenpunktItemProvider = new DatenpunktItemProvider(this);
		}

		return datenpunktItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Datenpunkt_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Datenpunkt_Allg_AttributeGroupItemProvider datenpunkt_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Datenpunkt_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDatenpunkt_Allg_AttributeGroupAdapter() {
		if (datenpunkt_Allg_AttributeGroupItemProvider == null) {
			datenpunkt_Allg_AttributeGroupItemProvider = new Datenpunkt_Allg_AttributeGroupItemProvider(this);
		}

		return datenpunkt_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Datenpunkt_Beschreibung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Datenpunkt_Beschreibung_TypeClassItemProvider datenpunkt_Beschreibung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Datenpunkt_Beschreibung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDatenpunkt_Beschreibung_TypeClassAdapter() {
		if (datenpunkt_Beschreibung_TypeClassItemProvider == null) {
			datenpunkt_Beschreibung_TypeClassItemProvider = new Datenpunkt_Beschreibung_TypeClassItemProvider(this);
		}

		return datenpunkt_Beschreibung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Datenpunkt_Einmesspunkt_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Datenpunkt_Einmesspunkt_AttributeGroupItemProvider datenpunkt_Einmesspunkt_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Datenpunkt_Einmesspunkt_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDatenpunkt_Einmesspunkt_AttributeGroupAdapter() {
		if (datenpunkt_Einmesspunkt_AttributeGroupItemProvider == null) {
			datenpunkt_Einmesspunkt_AttributeGroupItemProvider = new Datenpunkt_Einmesspunkt_AttributeGroupItemProvider(this);
		}

		return datenpunkt_Einmesspunkt_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Datenpunkt_Laenge_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Datenpunkt_Laenge_TypeClassItemProvider datenpunkt_Laenge_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Datenpunkt_Laenge_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDatenpunkt_Laenge_TypeClassAdapter() {
		if (datenpunkt_Laenge_TypeClassItemProvider == null) {
			datenpunkt_Laenge_TypeClassItemProvider = new Datenpunkt_Laenge_TypeClassItemProvider(this);
		}

		return datenpunkt_Laenge_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Datenpunkt_Link} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Datenpunkt_LinkItemProvider datenpunkt_LinkItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Datenpunkt_Link}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDatenpunkt_LinkAdapter() {
		if (datenpunkt_LinkItemProvider == null) {
			datenpunkt_LinkItemProvider = new Datenpunkt_LinkItemProvider(this);
		}

		return datenpunkt_LinkItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Delta_VGES_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Delta_VGES_TypeClassItemProvider delta_VGES_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Delta_VGES_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDelta_VGES_TypeClassAdapter() {
		if (delta_VGES_TypeClassItemProvider == null) {
			delta_VGES_TypeClassItemProvider = new Delta_VGES_TypeClassItemProvider(this);
		}

		return delta_VGES_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Delta_VLES_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Delta_VLES_TypeClassItemProvider delta_VLES_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Delta_VLES_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDelta_VLES_TypeClassAdapter() {
		if (delta_VLES_TypeClassItemProvider == null) {
			delta_VLES_TypeClassItemProvider = new Delta_VLES_TypeClassItemProvider(this);
		}

		return delta_VLES_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Delta_VZES_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Delta_VZES_TypeClassItemProvider delta_VZES_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Delta_VZES_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDelta_VZES_TypeClassAdapter() {
		if (delta_VZES_TypeClassItemProvider == null) {
			delta_VZES_TypeClassItemProvider = new Delta_VZES_TypeClassItemProvider(this);
		}

		return delta_VZES_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_ATO_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DP_ATO_TypeClassItemProvider dP_ATO_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_ATO_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDP_ATO_TypeClassAdapter() {
		if (dP_ATO_TypeClassItemProvider == null) {
			dP_ATO_TypeClassItemProvider = new DP_ATO_TypeClassItemProvider(this);
		}

		return dP_ATO_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Bezug_Funktional_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DP_Bezug_Funktional_Art_TypeClassItemProvider dP_Bezug_Funktional_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Bezug_Funktional_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDP_Bezug_Funktional_Art_TypeClassAdapter() {
		if (dP_Bezug_Funktional_Art_TypeClassItemProvider == null) {
			dP_Bezug_Funktional_Art_TypeClassItemProvider = new DP_Bezug_Funktional_Art_TypeClassItemProvider(this);
		}

		return dP_Bezug_Funktional_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Bezug_Funktional_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DP_Bezug_Funktional_AttributeGroupItemProvider dP_Bezug_Funktional_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Bezug_Funktional_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDP_Bezug_Funktional_AttributeGroupAdapter() {
		if (dP_Bezug_Funktional_AttributeGroupItemProvider == null) {
			dP_Bezug_Funktional_AttributeGroupItemProvider = new DP_Bezug_Funktional_AttributeGroupItemProvider(this);
		}

		return dP_Bezug_Funktional_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_ETCS_Adresse_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DP_ETCS_Adresse_AttributeGroupItemProvider dP_ETCS_Adresse_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_ETCS_Adresse_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDP_ETCS_Adresse_AttributeGroupAdapter() {
		if (dP_ETCS_Adresse_AttributeGroupItemProvider == null) {
			dP_ETCS_Adresse_AttributeGroupItemProvider = new DP_ETCS_Adresse_AttributeGroupItemProvider(this);
		}

		return dP_ETCS_Adresse_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Link_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DP_Link_Art_TypeClassItemProvider dP_Link_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Link_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDP_Link_Art_TypeClassAdapter() {
		if (dP_Link_Art_TypeClassItemProvider == null) {
			dP_Link_Art_TypeClassItemProvider = new DP_Link_Art_TypeClassItemProvider(this);
		}

		return dP_Link_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Telegramm_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DP_Telegramm_AttributeGroupItemProvider dP_Telegramm_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Telegramm_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDP_Telegramm_AttributeGroupAdapter() {
		if (dP_Telegramm_AttributeGroupItemProvider == null) {
			dP_Telegramm_AttributeGroupItemProvider = new DP_Telegramm_AttributeGroupItemProvider(this);
		}

		return dP_Telegramm_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Telegramm_ESG_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DP_Telegramm_ESG_AttributeGroupItemProvider dP_Telegramm_ESG_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Telegramm_ESG_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDP_Telegramm_ESG_AttributeGroupAdapter() {
		if (dP_Telegramm_ESG_AttributeGroupItemProvider == null) {
			dP_Telegramm_ESG_AttributeGroupItemProvider = new DP_Telegramm_ESG_AttributeGroupItemProvider(this);
		}

		return dP_Telegramm_ESG_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Typ_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DP_Typ_Art_TypeClassItemProvider dP_Typ_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Typ_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDP_Typ_Art_TypeClassAdapter() {
		if (dP_Typ_Art_TypeClassItemProvider == null) {
			dP_Typ_Art_TypeClassItemProvider = new DP_Typ_Art_TypeClassItemProvider(this);
		}

		return dP_Typ_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Typ_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DP_Typ_AttributeGroupItemProvider dP_Typ_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Typ_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDP_Typ_AttributeGroupAdapter() {
		if (dP_Typ_AttributeGroupItemProvider == null) {
			dP_Typ_AttributeGroupItemProvider = new DP_Typ_AttributeGroupItemProvider(this);
		}

		return dP_Typ_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Typ_ESG_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DP_Typ_ESG_TypeClassItemProvider dP_Typ_ESG_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Typ_ESG_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDP_Typ_ESG_TypeClassAdapter() {
		if (dP_Typ_ESG_TypeClassItemProvider == null) {
			dP_Typ_ESG_TypeClassItemProvider = new DP_Typ_ESG_TypeClassItemProvider(this);
		}

		return dP_Typ_ESG_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Typ_ETCS_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DP_Typ_ETCS_TypeClassItemProvider dP_Typ_ETCS_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Typ_ETCS_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDP_Typ_ETCS_TypeClassAdapter() {
		if (dP_Typ_ETCS_TypeClassItemProvider == null) {
			dP_Typ_ETCS_TypeClassItemProvider = new DP_Typ_ETCS_TypeClassItemProvider(this);
		}

		return dP_Typ_ETCS_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Typ_GESG_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DP_Typ_GESG_AttributeGroupItemProvider dP_Typ_GESG_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Typ_GESG_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDP_Typ_GESG_AttributeGroupAdapter() {
		if (dP_Typ_GESG_AttributeGroupItemProvider == null) {
			dP_Typ_GESG_AttributeGroupItemProvider = new DP_Typ_GESG_AttributeGroupItemProvider(this);
		}

		return dP_Typ_GESG_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Typ_GETCS_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DP_Typ_GETCS_AttributeGroupItemProvider dP_Typ_GETCS_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Typ_GETCS_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDP_Typ_GETCS_AttributeGroupAdapter() {
		if (dP_Typ_GETCS_AttributeGroupItemProvider == null) {
			dP_Typ_GETCS_AttributeGroupItemProvider = new DP_Typ_GETCS_AttributeGroupItemProvider(this);
		}

		return dP_Typ_GETCS_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Typ_GGNT_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DP_Typ_GGNT_AttributeGroupItemProvider dP_Typ_GGNT_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Typ_GGNT_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDP_Typ_GGNT_AttributeGroupAdapter() {
		if (dP_Typ_GGNT_AttributeGroupItemProvider == null) {
			dP_Typ_GGNT_AttributeGroupItemProvider = new DP_Typ_GGNT_AttributeGroupItemProvider(this);
		}

		return dP_Typ_GGNT_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Typ_GNT_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DP_Typ_GNT_TypeClassItemProvider dP_Typ_GNT_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Typ_GNT_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDP_Typ_GNT_TypeClassAdapter() {
		if (dP_Typ_GNT_TypeClassItemProvider == null) {
			dP_Typ_GNT_TypeClassItemProvider = new DP_Typ_GNT_TypeClassItemProvider(this);
		}

		return dP_Typ_GNT_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Typ_GSonst_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DP_Typ_GSonst_AttributeGroupItemProvider dP_Typ_GSonst_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Typ_GSonst_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDP_Typ_GSonst_AttributeGroupAdapter() {
		if (dP_Typ_GSonst_AttributeGroupItemProvider == null) {
			dP_Typ_GSonst_AttributeGroupItemProvider = new DP_Typ_GSonst_AttributeGroupItemProvider(this);
		}

		return dP_Typ_GSonst_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Typ_GTrans_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DP_Typ_GTrans_AttributeGroupItemProvider dP_Typ_GTrans_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Typ_GTrans_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDP_Typ_GTrans_AttributeGroupAdapter() {
		if (dP_Typ_GTrans_AttributeGroupItemProvider == null) {
			dP_Typ_GTrans_AttributeGroupItemProvider = new DP_Typ_GTrans_AttributeGroupItemProvider(this);
		}

		return dP_Typ_GTrans_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Typ_GZBS_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DP_Typ_GZBS_AttributeGroupItemProvider dP_Typ_GZBS_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Typ_GZBS_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDP_Typ_GZBS_AttributeGroupAdapter() {
		if (dP_Typ_GZBS_AttributeGroupItemProvider == null) {
			dP_Typ_GZBS_AttributeGroupItemProvider = new DP_Typ_GZBS_AttributeGroupItemProvider(this);
		}

		return dP_Typ_GZBS_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Typ_Sonst_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DP_Typ_Sonst_TypeClassItemProvider dP_Typ_Sonst_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Typ_Sonst_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDP_Typ_Sonst_TypeClassAdapter() {
		if (dP_Typ_Sonst_TypeClassItemProvider == null) {
			dP_Typ_Sonst_TypeClassItemProvider = new DP_Typ_Sonst_TypeClassItemProvider(this);
		}

		return dP_Typ_Sonst_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Typ_Trans_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DP_Typ_Trans_TypeClassItemProvider dP_Typ_Trans_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Typ_Trans_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDP_Typ_Trans_TypeClassAdapter() {
		if (dP_Typ_Trans_TypeClassItemProvider == null) {
			dP_Typ_Trans_TypeClassItemProvider = new DP_Typ_Trans_TypeClassItemProvider(this);
		}

		return dP_Typ_Trans_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Typ_V_La_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DP_Typ_V_La_TypeClassItemProvider dP_Typ_V_La_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Typ_V_La_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDP_Typ_V_La_TypeClassAdapter() {
		if (dP_Typ_V_La_TypeClassItemProvider == null) {
			dP_Typ_V_La_TypeClassItemProvider = new DP_Typ_V_La_TypeClassItemProvider(this);
		}

		return dP_Typ_V_La_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Typ_ZBS_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DP_Typ_ZBS_TypeClassItemProvider dP_Typ_ZBS_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Typ_ZBS_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDP_Typ_ZBS_TypeClassAdapter() {
		if (dP_Typ_ZBS_TypeClassItemProvider == null) {
			dP_Typ_ZBS_TypeClassItemProvider = new DP_Typ_ZBS_TypeClassItemProvider(this);
		}

		return dP_Typ_ZBS_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Verlinkt_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DP_Verlinkt_TypeClassItemProvider dP_Verlinkt_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DP_Verlinkt_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDP_Verlinkt_TypeClassAdapter() {
		if (dP_Verlinkt_TypeClassItemProvider == null) {
			dP_Verlinkt_TypeClassItemProvider = new DP_Verlinkt_TypeClassItemProvider(this);
		}

		return dP_Verlinkt_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Dunkelschaltanstoss_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Dunkelschaltanstoss_TypeClassItemProvider dunkelschaltanstoss_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Dunkelschaltanstoss_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDunkelschaltanstoss_TypeClassAdapter() {
		if (dunkelschaltanstoss_TypeClassItemProvider == null) {
			dunkelschaltanstoss_TypeClassItemProvider = new Dunkelschaltanstoss_TypeClassItemProvider(this);
		}

		return dunkelschaltanstoss_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DWeg_Intervall_200_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DWeg_Intervall_200_TypeClassItemProvider dWeg_Intervall_200_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DWeg_Intervall_200_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDWeg_Intervall_200_TypeClassAdapter() {
		if (dWeg_Intervall_200_TypeClassItemProvider == null) {
			dWeg_Intervall_200_TypeClassItemProvider = new DWeg_Intervall_200_TypeClassItemProvider(this);
		}

		return dWeg_Intervall_200_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DWeg_Intervall_50_200_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DWeg_Intervall_50_200_TypeClassItemProvider dWeg_Intervall_50_200_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DWeg_Intervall_50_200_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDWeg_Intervall_50_200_TypeClassAdapter() {
		if (dWeg_Intervall_50_200_TypeClassItemProvider == null) {
			dWeg_Intervall_50_200_TypeClassItemProvider = new DWeg_Intervall_50_200_TypeClassItemProvider(this);
		}

		return dWeg_Intervall_50_200_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DWeg_Intervall_50_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DWeg_Intervall_50_TypeClassItemProvider dWeg_Intervall_50_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.DWeg_Intervall_50_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDWeg_Intervall_50_TypeClassAdapter() {
		if (dWeg_Intervall_50_TypeClassItemProvider == null) {
			dWeg_Intervall_50_TypeClassItemProvider = new DWeg_Intervall_50_TypeClassItemProvider(this);
		}

		return dWeg_Intervall_50_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Eingang_Gepuffert_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Eingang_Gepuffert_TypeClassItemProvider eingang_Gepuffert_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Eingang_Gepuffert_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEingang_Gepuffert_TypeClassAdapter() {
		if (eingang_Gepuffert_TypeClassItemProvider == null) {
			eingang_Gepuffert_TypeClassItemProvider = new Eingang_Gepuffert_TypeClassItemProvider(this);
		}

		return eingang_Gepuffert_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Einstieg_Erlaubt_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Einstieg_Erlaubt_TypeClassItemProvider einstieg_Erlaubt_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Einstieg_Erlaubt_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEinstieg_Erlaubt_TypeClassAdapter() {
		if (einstieg_Erlaubt_TypeClassItemProvider == null) {
			einstieg_Erlaubt_TypeClassItemProvider = new Einstieg_Erlaubt_TypeClassItemProvider(this);
		}

		return einstieg_Erlaubt_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Einstieg_Ohne_Rueckw_Sig_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Einstieg_Ohne_Rueckw_Sig_TypeClassItemProvider einstieg_Ohne_Rueckw_Sig_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Einstieg_Ohne_Rueckw_Sig_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEinstieg_Ohne_Rueckw_Sig_TypeClassAdapter() {
		if (einstieg_Ohne_Rueckw_Sig_TypeClassItemProvider == null) {
			einstieg_Ohne_Rueckw_Sig_TypeClassItemProvider = new Einstieg_Ohne_Rueckw_Sig_TypeClassItemProvider(this);
		}

		return einstieg_Ohne_Rueckw_Sig_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Einzeldatei_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Einzeldatei_Art_TypeClassItemProvider einzeldatei_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Einzeldatei_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEinzeldatei_Art_TypeClassAdapter() {
		if (einzeldatei_Art_TypeClassItemProvider == null) {
			einzeldatei_Art_TypeClassItemProvider = new Einzeldatei_Art_TypeClassItemProvider(this);
		}

		return einzeldatei_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Energie_Eingang_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Energie_Eingang_Art_TypeClassItemProvider energie_Eingang_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Energie_Eingang_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEnergie_Eingang_Art_TypeClassAdapter() {
		if (energie_Eingang_Art_TypeClassItemProvider == null) {
			energie_Eingang_Art_TypeClassItemProvider = new Energie_Eingang_Art_TypeClassItemProvider(this);
		}

		return energie_Eingang_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ESG_Ind_Erlaeuterung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ESG_Ind_Erlaeuterung_TypeClassItemProvider esG_Ind_Erlaeuterung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ESG_Ind_Erlaeuterung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createESG_Ind_Erlaeuterung_TypeClassAdapter() {
		if (esG_Ind_Erlaeuterung_TypeClassItemProvider == null) {
			esG_Ind_Erlaeuterung_TypeClassItemProvider = new ESG_Ind_Erlaeuterung_TypeClassItemProvider(this);
		}

		return esG_Ind_Erlaeuterung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ESG_Ind_Parameter_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ESG_Ind_Parameter_TypeClassItemProvider esG_Ind_Parameter_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ESG_Ind_Parameter_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createESG_Ind_Parameter_TypeClassAdapter() {
		if (esG_Ind_Parameter_TypeClassItemProvider == null) {
			esG_Ind_Parameter_TypeClassItemProvider = new ESG_Ind_Parameter_TypeClassItemProvider(this);
		}

		return esG_Ind_Parameter_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ESG_Ind_Parameterwert_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ESG_Ind_Parameterwert_TypeClassItemProvider esG_Ind_Parameterwert_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ESG_Ind_Parameterwert_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createESG_Ind_Parameterwert_TypeClassAdapter() {
		if (esG_Ind_Parameterwert_TypeClassItemProvider == null) {
			esG_Ind_Parameterwert_TypeClassItemProvider = new ESG_Ind_Parameterwert_TypeClassItemProvider(this);
		}

		return esG_Ind_Parameterwert_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ESG_Individuelle_Merkmale_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ESG_Individuelle_Merkmale_AttributeGroupItemProvider esG_Individuelle_Merkmale_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ESG_Individuelle_Merkmale_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createESG_Individuelle_Merkmale_AttributeGroupAdapter() {
		if (esG_Individuelle_Merkmale_AttributeGroupItemProvider == null) {
			esG_Individuelle_Merkmale_AttributeGroupItemProvider = new ESG_Individuelle_Merkmale_AttributeGroupItemProvider(this);
		}

		return esG_Individuelle_Merkmale_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ESG_Spezifische_Merkmale_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ESG_Spezifische_Merkmale_AttributeGroupItemProvider esG_Spezifische_Merkmale_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ESG_Spezifische_Merkmale_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createESG_Spezifische_Merkmale_AttributeGroupAdapter() {
		if (esG_Spezifische_Merkmale_AttributeGroupItemProvider == null) {
			esG_Spezifische_Merkmale_AttributeGroupItemProvider = new ESG_Spezifische_Merkmale_AttributeGroupItemProvider(this);
		}

		return esG_Spezifische_Merkmale_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ETCS_Adresse_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ETCS_Adresse_AttributeGroupItemProvider etcS_Adresse_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ETCS_Adresse_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createETCS_Adresse_AttributeGroupAdapter() {
		if (etcS_Adresse_AttributeGroupItemProvider == null) {
			etcS_Adresse_AttributeGroupItemProvider = new ETCS_Adresse_AttributeGroupItemProvider(this);
		}

		return etcS_Adresse_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ETCS_Gefahrpunktabstand_Abweichend_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ETCS_Gefahrpunktabstand_Abweichend_TypeClassItemProvider etcS_Gefahrpunktabstand_Abweichend_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ETCS_Gefahrpunktabstand_Abweichend_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createETCS_Gefahrpunktabstand_Abweichend_TypeClassAdapter() {
		if (etcS_Gefahrpunktabstand_Abweichend_TypeClassItemProvider == null) {
			etcS_Gefahrpunktabstand_Abweichend_TypeClassItemProvider = new ETCS_Gefahrpunktabstand_Abweichend_TypeClassItemProvider(this);
		}

		return etcS_Gefahrpunktabstand_Abweichend_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ETCS_Kante} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ETCS_KanteItemProvider etcS_KanteItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ETCS_Kante}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createETCS_KanteAdapter() {
		if (etcS_KanteItemProvider == null) {
			etcS_KanteItemProvider = new ETCS_KanteItemProvider(this);
		}

		return etcS_KanteItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ETCS_Kante_Bezeichnung_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ETCS_Kante_Bezeichnung_AttributeGroupItemProvider etcS_Kante_Bezeichnung_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ETCS_Kante_Bezeichnung_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createETCS_Kante_Bezeichnung_AttributeGroupAdapter() {
		if (etcS_Kante_Bezeichnung_AttributeGroupItemProvider == null) {
			etcS_Kante_Bezeichnung_AttributeGroupItemProvider = new ETCS_Kante_Bezeichnung_AttributeGroupItemProvider(this);
		}

		return etcS_Kante_Bezeichnung_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ETCS_Knoten} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ETCS_KnotenItemProvider etcS_KnotenItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ETCS_Knoten}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createETCS_KnotenAdapter() {
		if (etcS_KnotenItemProvider == null) {
			etcS_KnotenItemProvider = new ETCS_KnotenItemProvider(this);
		}

		return etcS_KnotenItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ETCS_Knoten_Art_Sonstige_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ETCS_Knoten_Art_Sonstige_TypeClassItemProvider etcS_Knoten_Art_Sonstige_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ETCS_Knoten_Art_Sonstige_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createETCS_Knoten_Art_Sonstige_TypeClassAdapter() {
		if (etcS_Knoten_Art_Sonstige_TypeClassItemProvider == null) {
			etcS_Knoten_Art_Sonstige_TypeClassItemProvider = new ETCS_Knoten_Art_Sonstige_TypeClassItemProvider(this);
		}

		return etcS_Knoten_Art_Sonstige_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ETCS_Paketnummer_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ETCS_Paketnummer_TypeClassItemProvider etcS_Paketnummer_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ETCS_Paketnummer_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createETCS_Paketnummer_TypeClassAdapter() {
		if (etcS_Paketnummer_TypeClassItemProvider == null) {
			etcS_Paketnummer_TypeClassItemProvider = new ETCS_Paketnummer_TypeClassItemProvider(this);
		}

		return etcS_Paketnummer_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ETCS_Par_Erlaeuterung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ETCS_Par_Erlaeuterung_TypeClassItemProvider etcS_Par_Erlaeuterung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ETCS_Par_Erlaeuterung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createETCS_Par_Erlaeuterung_TypeClassAdapter() {
		if (etcS_Par_Erlaeuterung_TypeClassItemProvider == null) {
			etcS_Par_Erlaeuterung_TypeClassItemProvider = new ETCS_Par_Erlaeuterung_TypeClassItemProvider(this);
		}

		return etcS_Par_Erlaeuterung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ETCS_Parametername_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ETCS_Parametername_TypeClassItemProvider etcS_Parametername_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ETCS_Parametername_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createETCS_Parametername_TypeClassAdapter() {
		if (etcS_Parametername_TypeClassItemProvider == null) {
			etcS_Parametername_TypeClassItemProvider = new ETCS_Parametername_TypeClassItemProvider(this);
		}

		return etcS_Parametername_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ETCS_Parameterwert_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ETCS_Parameterwert_TypeClassItemProvider etcS_Parameterwert_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ETCS_Parameterwert_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createETCS_Parameterwert_TypeClassAdapter() {
		if (etcS_Parameterwert_TypeClassItemProvider == null) {
			etcS_Parameterwert_TypeClassItemProvider = new ETCS_Parameterwert_TypeClassItemProvider(this);
		}

		return etcS_Parameterwert_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ETCS_Richtungsanzeige} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ETCS_RichtungsanzeigeItemProvider etcS_RichtungsanzeigeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ETCS_Richtungsanzeige}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createETCS_RichtungsanzeigeAdapter() {
		if (etcS_RichtungsanzeigeItemProvider == null) {
			etcS_RichtungsanzeigeItemProvider = new ETCS_RichtungsanzeigeItemProvider(this);
		}

		return etcS_RichtungsanzeigeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ETCS_Signal} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ETCS_SignalItemProvider etcS_SignalItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ETCS_Signal}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createETCS_SignalAdapter() {
		if (etcS_SignalItemProvider == null) {
			etcS_SignalItemProvider = new ETCS_SignalItemProvider(this);
		}

		return etcS_SignalItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ETCS_Signal_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ETCS_Signal_Allg_AttributeGroupItemProvider etcS_Signal_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ETCS_Signal_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createETCS_Signal_Allg_AttributeGroupAdapter() {
		if (etcS_Signal_Allg_AttributeGroupItemProvider == null) {
			etcS_Signal_Allg_AttributeGroupItemProvider = new ETCS_Signal_Allg_AttributeGroupItemProvider(this);
		}

		return etcS_Signal_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ETCS_Signal_DWeg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ETCS_Signal_DWeg_AttributeGroupItemProvider etcS_Signal_DWeg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ETCS_Signal_DWeg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createETCS_Signal_DWeg_AttributeGroupAdapter() {
		if (etcS_Signal_DWeg_AttributeGroupItemProvider == null) {
			etcS_Signal_DWeg_AttributeGroupItemProvider = new ETCS_Signal_DWeg_AttributeGroupItemProvider(this);
		}

		return etcS_Signal_DWeg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ETCS_Signal_TBV_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ETCS_Signal_TBV_AttributeGroupItemProvider etcS_Signal_TBV_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ETCS_Signal_TBV_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createETCS_Signal_TBV_AttributeGroupAdapter() {
		if (etcS_Signal_TBV_AttributeGroupItemProvider == null) {
			etcS_Signal_TBV_AttributeGroupItemProvider = new ETCS_Signal_TBV_AttributeGroupItemProvider(this);
		}

		return etcS_Signal_TBV_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ETCS_System_Version_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ETCS_System_Version_TypeClassItemProvider etcS_System_Version_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ETCS_System_Version_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createETCS_System_Version_TypeClassAdapter() {
		if (etcS_System_Version_TypeClassItemProvider == null) {
			etcS_System_Version_TypeClassItemProvider = new ETCS_System_Version_TypeClassItemProvider(this);
		}

		return etcS_System_Version_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ETCS_W_Kr} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ETCS_W_KrItemProvider etcS_W_KrItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ETCS_W_Kr}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createETCS_W_KrAdapter() {
		if (etcS_W_KrItemProvider == null) {
			etcS_W_KrItemProvider = new ETCS_W_KrItemProvider(this);
		}

		return etcS_W_KrItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ETCS_W_Kr_MUKA_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ETCS_W_Kr_MUKA_AttributeGroupItemProvider etcS_W_Kr_MUKA_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ETCS_W_Kr_MUKA_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createETCS_W_Kr_MUKA_AttributeGroupAdapter() {
		if (etcS_W_Kr_MUKA_AttributeGroupItemProvider == null) {
			etcS_W_Kr_MUKA_AttributeGroupItemProvider = new ETCS_W_Kr_MUKA_AttributeGroupItemProvider(this);
		}

		return etcS_W_Kr_MUKA_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.EV_Modul} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EV_ModulItemProvider eV_ModulItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.EV_Modul}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEV_ModulAdapter() {
		if (eV_ModulItemProvider == null) {
			eV_ModulItemProvider = new EV_ModulItemProvider(this);
		}

		return eV_ModulItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.EV_Modul_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EV_Modul_Art_TypeClassItemProvider eV_Modul_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.EV_Modul_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEV_Modul_Art_TypeClassAdapter() {
		if (eV_Modul_Art_TypeClassItemProvider == null) {
			eV_Modul_Art_TypeClassItemProvider = new EV_Modul_Art_TypeClassItemProvider(this);
		}

		return eV_Modul_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.EV_Modul_Ausgang_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EV_Modul_Ausgang_AttributeGroupItemProvider eV_Modul_Ausgang_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.EV_Modul_Ausgang_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEV_Modul_Ausgang_AttributeGroupAdapter() {
		if (eV_Modul_Ausgang_AttributeGroupItemProvider == null) {
			eV_Modul_Ausgang_AttributeGroupItemProvider = new EV_Modul_Ausgang_AttributeGroupItemProvider(this);
		}

		return eV_Modul_Ausgang_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.EV_Modul_Eingang_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EV_Modul_Eingang_AttributeGroupItemProvider eV_Modul_Eingang_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.EV_Modul_Eingang_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEV_Modul_Eingang_AttributeGroupAdapter() {
		if (eV_Modul_Eingang_AttributeGroupItemProvider == null) {
			eV_Modul_Eingang_AttributeGroupItemProvider = new EV_Modul_Eingang_AttributeGroupItemProvider(this);
		}

		return eV_Modul_Eingang_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.EV_Modul_Physisch_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EV_Modul_Physisch_AttributeGroupItemProvider eV_Modul_Physisch_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.EV_Modul_Physisch_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEV_Modul_Physisch_AttributeGroupAdapter() {
		if (eV_Modul_Physisch_AttributeGroupItemProvider == null) {
			eV_Modul_Physisch_AttributeGroupItemProvider = new EV_Modul_Physisch_AttributeGroupItemProvider(this);
		}

		return eV_Modul_Physisch_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.EV_Modul_Typ_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EV_Modul_Typ_TypeClassItemProvider eV_Modul_Typ_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.EV_Modul_Typ_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEV_Modul_Typ_TypeClassAdapter() {
		if (eV_Modul_Typ_TypeClassItemProvider == null) {
			eV_Modul_Typ_TypeClassItemProvider = new EV_Modul_Typ_TypeClassItemProvider(this);
		}

		return eV_Modul_Typ_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.EV_Modul_Virtuell_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EV_Modul_Virtuell_AttributeGroupItemProvider eV_Modul_Virtuell_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.EV_Modul_Virtuell_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEV_Modul_Virtuell_AttributeGroupAdapter() {
		if (eV_Modul_Virtuell_AttributeGroupItemProvider == null) {
			eV_Modul_Virtuell_AttributeGroupItemProvider = new EV_Modul_Virtuell_AttributeGroupItemProvider(this);
		}

		return eV_Modul_Virtuell_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Fabrikat_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fabrikat_TypeClassItemProvider fabrikat_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Fabrikat_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFabrikat_TypeClassAdapter() {
		if (fabrikat_TypeClassItemProvider == null) {
			fabrikat_TypeClassItemProvider = new Fabrikat_TypeClassItemProvider(this);
		}

		return fabrikat_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Fachtelegramm} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FachtelegrammItemProvider fachtelegrammItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Fachtelegramm}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFachtelegrammAdapter() {
		if (fachtelegrammItemProvider == null) {
			fachtelegrammItemProvider = new FachtelegrammItemProvider(this);
		}

		return fachtelegrammItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.FT_Anschaltbedingung} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FT_AnschaltbedingungItemProvider fT_AnschaltbedingungItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.FT_Anschaltbedingung}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFT_AnschaltbedingungAdapter() {
		if (fT_AnschaltbedingungItemProvider == null) {
			fT_AnschaltbedingungItemProvider = new FT_AnschaltbedingungItemProvider(this);
		}

		return fT_AnschaltbedingungItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.FT_ESG_Merkmale_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FT_ESG_Merkmale_AttributeGroupItemProvider fT_ESG_Merkmale_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.FT_ESG_Merkmale_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFT_ESG_Merkmale_AttributeGroupAdapter() {
		if (fT_ESG_Merkmale_AttributeGroupItemProvider == null) {
			fT_ESG_Merkmale_AttributeGroupItemProvider = new FT_ESG_Merkmale_AttributeGroupItemProvider(this);
		}

		return fT_ESG_Merkmale_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.FT_ESG_Subtyp_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FT_ESG_Subtyp_TypeClassItemProvider fT_ESG_Subtyp_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.FT_ESG_Subtyp_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFT_ESG_Subtyp_TypeClassAdapter() {
		if (fT_ESG_Subtyp_TypeClassItemProvider == null) {
			fT_ESG_Subtyp_TypeClassItemProvider = new FT_ESG_Subtyp_TypeClassItemProvider(this);
		}

		return fT_ESG_Subtyp_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.FT_ESG_Typ_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FT_ESG_Typ_TypeClassItemProvider fT_ESG_Typ_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.FT_ESG_Typ_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFT_ESG_Typ_TypeClassAdapter() {
		if (fT_ESG_Typ_TypeClassItemProvider == null) {
			fT_ESG_Typ_TypeClassItemProvider = new FT_ESG_Typ_TypeClassItemProvider(this);
		}

		return fT_ESG_Typ_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.FT_ETCS_L2_Merkmale_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FT_ETCS_L2_Merkmale_AttributeGroupItemProvider fT_ETCS_L2_Merkmale_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.FT_ETCS_L2_Merkmale_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFT_ETCS_L2_Merkmale_AttributeGroupAdapter() {
		if (fT_ETCS_L2_Merkmale_AttributeGroupItemProvider == null) {
			fT_ETCS_L2_Merkmale_AttributeGroupItemProvider = new FT_ETCS_L2_Merkmale_AttributeGroupItemProvider(this);
		}

		return fT_ETCS_L2_Merkmale_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.FT_ETCS_L2_Typ_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FT_ETCS_L2_Typ_TypeClassItemProvider fT_ETCS_L2_Typ_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.FT_ETCS_L2_Typ_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFT_ETCS_L2_Typ_TypeClassAdapter() {
		if (fT_ETCS_L2_Typ_TypeClassItemProvider == null) {
			fT_ETCS_L2_Typ_TypeClassItemProvider = new FT_ETCS_L2_Typ_TypeClassItemProvider(this);
		}

		return fT_ETCS_L2_Typ_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.FT_ETCS_Trans_Merkmale_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FT_ETCS_Trans_Merkmale_AttributeGroupItemProvider fT_ETCS_Trans_Merkmale_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.FT_ETCS_Trans_Merkmale_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFT_ETCS_Trans_Merkmale_AttributeGroupAdapter() {
		if (fT_ETCS_Trans_Merkmale_AttributeGroupItemProvider == null) {
			fT_ETCS_Trans_Merkmale_AttributeGroupItemProvider = new FT_ETCS_Trans_Merkmale_AttributeGroupItemProvider(this);
		}

		return fT_ETCS_Trans_Merkmale_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.FT_ETCS_Trans_Paket_41_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FT_ETCS_Trans_Paket_41_AttributeGroupItemProvider fT_ETCS_Trans_Paket_41_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.FT_ETCS_Trans_Paket_41_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFT_ETCS_Trans_Paket_41_AttributeGroupAdapter() {
		if (fT_ETCS_Trans_Paket_41_AttributeGroupItemProvider == null) {
			fT_ETCS_Trans_Paket_41_AttributeGroupItemProvider = new FT_ETCS_Trans_Paket_41_AttributeGroupItemProvider(this);
		}

		return fT_ETCS_Trans_Paket_41_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.FT_ETCS_Trans_Paket_N_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FT_ETCS_Trans_Paket_N_AttributeGroupItemProvider fT_ETCS_Trans_Paket_N_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.FT_ETCS_Trans_Paket_N_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFT_ETCS_Trans_Paket_N_AttributeGroupAdapter() {
		if (fT_ETCS_Trans_Paket_N_AttributeGroupItemProvider == null) {
			fT_ETCS_Trans_Paket_N_AttributeGroupItemProvider = new FT_ETCS_Trans_Paket_N_AttributeGroupItemProvider(this);
		}

		return fT_ETCS_Trans_Paket_N_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.FT_Fahrweg_Teil} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FT_Fahrweg_TeilItemProvider fT_Fahrweg_TeilItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.FT_Fahrweg_Teil}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFT_Fahrweg_TeilAdapter() {
		if (fT_Fahrweg_TeilItemProvider == null) {
			fT_Fahrweg_TeilItemProvider = new FT_Fahrweg_TeilItemProvider(this);
		}

		return fT_Fahrweg_TeilItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.FT_Fahrweg_Teil_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FT_Fahrweg_Teil_Allg_AttributeGroupItemProvider fT_Fahrweg_Teil_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.FT_Fahrweg_Teil_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFT_Fahrweg_Teil_Allg_AttributeGroupAdapter() {
		if (fT_Fahrweg_Teil_Allg_AttributeGroupItemProvider == null) {
			fT_Fahrweg_Teil_Allg_AttributeGroupItemProvider = new FT_Fahrweg_Teil_Allg_AttributeGroupItemProvider(this);
		}

		return fT_Fahrweg_Teil_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.FT_Fahrweg_Teile_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FT_Fahrweg_Teile_AttributeGroupItemProvider fT_Fahrweg_Teile_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.FT_Fahrweg_Teile_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFT_Fahrweg_Teile_AttributeGroupAdapter() {
		if (fT_Fahrweg_Teile_AttributeGroupItemProvider == null) {
			fT_Fahrweg_Teile_AttributeGroupItemProvider = new FT_Fahrweg_Teile_AttributeGroupItemProvider(this);
		}

		return fT_Fahrweg_Teile_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.FT_GNT_Merkmale_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FT_GNT_Merkmale_AttributeGroupItemProvider fT_GNT_Merkmale_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.FT_GNT_Merkmale_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFT_GNT_Merkmale_AttributeGroupAdapter() {
		if (fT_GNT_Merkmale_AttributeGroupItemProvider == null) {
			fT_GNT_Merkmale_AttributeGroupItemProvider = new FT_GNT_Merkmale_AttributeGroupItemProvider(this);
		}

		return fT_GNT_Merkmale_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.FT_GNT_Punktart_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FT_GNT_Punktart_TypeClassItemProvider fT_GNT_Punktart_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.FT_GNT_Punktart_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFT_GNT_Punktart_TypeClassAdapter() {
		if (fT_GNT_Punktart_TypeClassItemProvider == null) {
			fT_GNT_Punktart_TypeClassItemProvider = new FT_GNT_Punktart_TypeClassItemProvider(this);
		}

		return fT_GNT_Punktart_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.FT_Hinweis_Funktion_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FT_Hinweis_Funktion_TypeClassItemProvider fT_Hinweis_Funktion_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.FT_Hinweis_Funktion_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFT_Hinweis_Funktion_TypeClassAdapter() {
		if (fT_Hinweis_Funktion_TypeClassItemProvider == null) {
			fT_Hinweis_Funktion_TypeClassItemProvider = new FT_Hinweis_Funktion_TypeClassItemProvider(this);
		}

		return fT_Hinweis_Funktion_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.FT_ZBS_Merkmale_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FT_ZBS_Merkmale_AttributeGroupItemProvider fT_ZBS_Merkmale_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.FT_ZBS_Merkmale_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFT_ZBS_Merkmale_AttributeGroupAdapter() {
		if (fT_ZBS_Merkmale_AttributeGroupItemProvider == null) {
			fT_ZBS_Merkmale_AttributeGroupItemProvider = new FT_ZBS_Merkmale_AttributeGroupItemProvider(this);
		}

		return fT_ZBS_Merkmale_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.FT_ZBS_Merkmale_La_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FT_ZBS_Merkmale_La_AttributeGroupItemProvider fT_ZBS_Merkmale_La_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.FT_ZBS_Merkmale_La_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFT_ZBS_Merkmale_La_AttributeGroupAdapter() {
		if (fT_ZBS_Merkmale_La_AttributeGroupItemProvider == null) {
			fT_ZBS_Merkmale_La_AttributeGroupItemProvider = new FT_ZBS_Merkmale_La_AttributeGroupItemProvider(this);
		}

		return fT_ZBS_Merkmale_La_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.FT_ZBS_Typ_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FT_ZBS_Typ_TypeClassItemProvider fT_ZBS_Typ_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.FT_ZBS_Typ_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFT_ZBS_Typ_TypeClassAdapter() {
		if (fT_ZBS_Typ_TypeClassItemProvider == null) {
			fT_ZBS_Typ_TypeClassItemProvider = new FT_ZBS_Typ_TypeClassItemProvider(this);
		}

		return fT_ZBS_Typ_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.FW_Teil_Nummer_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FW_Teil_Nummer_TypeClassItemProvider fW_Teil_Nummer_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.FW_Teil_Nummer_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFW_Teil_Nummer_TypeClassAdapter() {
		if (fW_Teil_Nummer_TypeClassItemProvider == null) {
			fW_Teil_Nummer_TypeClassItemProvider = new FW_Teil_Nummer_TypeClassItemProvider(this);
		}

		return fW_Teil_Nummer_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Gruppen_ID_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Gruppen_ID_TypeClassItemProvider gruppen_ID_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Gruppen_ID_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGruppen_ID_TypeClassAdapter() {
		if (gruppen_ID_TypeClassItemProvider == null) {
			gruppen_ID_TypeClassItemProvider = new Gruppen_ID_TypeClassItemProvider(this);
		}

		return gruppen_ID_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Harter_Ausstieg_Aus_L2_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Harter_Ausstieg_Aus_L2_TypeClassItemProvider harter_Ausstieg_Aus_L2_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Harter_Ausstieg_Aus_L2_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHarter_Ausstieg_Aus_L2_TypeClassAdapter() {
		if (harter_Ausstieg_Aus_L2_TypeClassItemProvider == null) {
			harter_Ausstieg_Aus_L2_TypeClassItemProvider = new Harter_Ausstieg_Aus_L2_TypeClassItemProvider(this);
		}

		return harter_Ausstieg_Aus_L2_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Hersteller_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Hersteller_TypeClassItemProvider hersteller_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Hersteller_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHersteller_TypeClassAdapter() {
		if (hersteller_TypeClassItemProvider == null) {
			hersteller_TypeClassItemProvider = new Hersteller_TypeClassItemProvider(this);
		}

		return hersteller_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Hinweis_Balisenbefestigung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Hinweis_Balisenbefestigung_TypeClassItemProvider hinweis_Balisenbefestigung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Hinweis_Balisenbefestigung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHinweis_Balisenbefestigung_TypeClassAdapter() {
		if (hinweis_Balisenbefestigung_TypeClassItemProvider == null) {
			hinweis_Balisenbefestigung_TypeClassItemProvider = new Hinweis_Balisenbefestigung_TypeClassItemProvider(this);
		}

		return hinweis_Balisenbefestigung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Individualisierung_Weitere_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Individualisierung_Weitere_TypeClassItemProvider individualisierung_Weitere_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Individualisierung_Weitere_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIndividualisierung_Weitere_TypeClassAdapter() {
		if (individualisierung_Weitere_TypeClassItemProvider == null) {
			individualisierung_Weitere_TypeClassItemProvider = new Individualisierung_Weitere_TypeClassItemProvider(this);
		}

		return individualisierung_Weitere_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Ist_Befahren_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Ist_Befahren_TypeClassItemProvider ist_Befahren_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Ist_Befahren_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIst_Befahren_TypeClassAdapter() {
		if (ist_Befahren_TypeClassItemProvider == null) {
			ist_Befahren_TypeClassItemProvider = new Ist_Befahren_TypeClassItemProvider(this);
		}

		return ist_Befahren_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Km_BTS_1_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Km_BTS_1_TypeClassItemProvider km_BTS_1_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Km_BTS_1_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createKm_BTS_1_TypeClassAdapter() {
		if (km_BTS_1_TypeClassItemProvider == null) {
			km_BTS_1_TypeClassItemProvider = new Km_BTS_1_TypeClassItemProvider(this);
		}

		return km_BTS_1_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Km_BTS_2_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Km_BTS_2_TypeClassItemProvider km_BTS_2_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Km_BTS_2_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createKm_BTS_2_TypeClassAdapter() {
		if (km_BTS_2_TypeClassItemProvider == null) {
			km_BTS_2_TypeClassItemProvider = new Km_BTS_2_TypeClassItemProvider(this);
		}

		return km_BTS_2_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Km_BTS_3_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Km_BTS_3_TypeClassItemProvider km_BTS_3_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Km_BTS_3_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createKm_BTS_3_TypeClassAdapter() {
		if (km_BTS_3_TypeClassItemProvider == null) {
			km_BTS_3_TypeClassItemProvider = new Km_BTS_3_TypeClassItemProvider(this);
		}

		return km_BTS_3_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Knoten_Auf_TOP_Kante_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Knoten_Auf_TOP_Kante_AttributeGroupItemProvider knoten_Auf_TOP_Kante_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Knoten_Auf_TOP_Kante_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createKnoten_Auf_TOP_Kante_AttributeGroupAdapter() {
		if (knoten_Auf_TOP_Kante_AttributeGroupItemProvider == null) {
			knoten_Auf_TOP_Kante_AttributeGroupItemProvider = new Knoten_Auf_TOP_Kante_AttributeGroupItemProvider(this);
		}

		return knoten_Auf_TOP_Kante_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Konfigurationskennung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Konfigurationskennung_TypeClassItemProvider konfigurationskennung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Konfigurationskennung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createKonfigurationskennung_TypeClassAdapter() {
		if (konfigurationskennung_TypeClassItemProvider == null) {
			konfigurationskennung_TypeClassItemProvider = new Konfigurationskennung_TypeClassItemProvider(this);
		}

		return konfigurationskennung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.L_ACKLEVELTR_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected L_ACKLEVELTR_TypeClassItemProvider l_ACKLEVELTR_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.L_ACKLEVELTR_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createL_ACKLEVELTR_TypeClassAdapter() {
		if (l_ACKLEVELTR_TypeClassItemProvider == null) {
			l_ACKLEVELTR_TypeClassItemProvider = new L_ACKLEVELTR_TypeClassItemProvider(this);
		}

		return l_ACKLEVELTR_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Laenge_1_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Laenge_1_TypeClassItemProvider laenge_1_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Laenge_1_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLaenge_1_TypeClassAdapter() {
		if (laenge_1_TypeClassItemProvider == null) {
			laenge_1_TypeClassItemProvider = new Laenge_1_TypeClassItemProvider(this);
		}

		return laenge_1_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Laenge_Ausfuehrungsbereich_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Laenge_Ausfuehrungsbereich_TypeClassItemProvider laenge_Ausfuehrungsbereich_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Laenge_Ausfuehrungsbereich_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLaenge_Ausfuehrungsbereich_TypeClassAdapter() {
		if (laenge_Ausfuehrungsbereich_TypeClassItemProvider == null) {
			laenge_Ausfuehrungsbereich_TypeClassItemProvider = new Laenge_Ausfuehrungsbereich_TypeClassItemProvider(this);
		}

		return laenge_Ausfuehrungsbereich_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Laenge_Gestufte_V_Signalisierung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Laenge_Gestufte_V_Signalisierung_TypeClassItemProvider laenge_Gestufte_V_Signalisierung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Laenge_Gestufte_V_Signalisierung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLaenge_Gestufte_V_Signalisierung_TypeClassAdapter() {
		if (laenge_Gestufte_V_Signalisierung_TypeClassItemProvider == null) {
			laenge_Gestufte_V_Signalisierung_TypeClassItemProvider = new Laenge_Gestufte_V_Signalisierung_TypeClassItemProvider(this);
		}

		return laenge_Gestufte_V_Signalisierung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Laenge_Soll_Mind_150_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Laenge_Soll_Mind_150_TypeClassItemProvider laenge_Soll_Mind_150_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Laenge_Soll_Mind_150_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLaenge_Soll_Mind_150_TypeClassAdapter() {
		if (laenge_Soll_Mind_150_TypeClassItemProvider == null) {
			laenge_Soll_Mind_150_TypeClassItemProvider = new Laenge_Soll_Mind_150_TypeClassItemProvider(this);
		}

		return laenge_Soll_Mind_150_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Leistungsbedarf_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Leistungsbedarf_TypeClassItemProvider leistungsbedarf_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Leistungsbedarf_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLeistungsbedarf_TypeClassAdapter() {
		if (leistungsbedarf_TypeClassItemProvider == null) {
			leistungsbedarf_TypeClassItemProvider = new Leistungsbedarf_TypeClassItemProvider(this);
		}

		return leistungsbedarf_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LEU_Anlage} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LEU_AnlageItemProvider leU_AnlageItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LEU_Anlage}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLEU_AnlageAdapter() {
		if (leU_AnlageItemProvider == null) {
			leU_AnlageItemProvider = new LEU_AnlageItemProvider(this);
		}

		return leU_AnlageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LEU_Anlage_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LEU_Anlage_Allg_AttributeGroupItemProvider leU_Anlage_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LEU_Anlage_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLEU_Anlage_Allg_AttributeGroupAdapter() {
		if (leU_Anlage_Allg_AttributeGroupItemProvider == null) {
			leU_Anlage_Allg_AttributeGroupItemProvider = new LEU_Anlage_Allg_AttributeGroupItemProvider(this);
		}

		return leU_Anlage_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LEU_Anlage_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LEU_Anlage_Art_TypeClassItemProvider leU_Anlage_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LEU_Anlage_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLEU_Anlage_Art_TypeClassAdapter() {
		if (leU_Anlage_Art_TypeClassItemProvider == null) {
			leU_Anlage_Art_TypeClassItemProvider = new LEU_Anlage_Art_TypeClassItemProvider(this);
		}

		return leU_Anlage_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LEU_Anlage_Bezeichnung_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LEU_Anlage_Bezeichnung_AttributeGroupItemProvider leU_Anlage_Bezeichnung_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LEU_Anlage_Bezeichnung_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLEU_Anlage_Bezeichnung_AttributeGroupAdapter() {
		if (leU_Anlage_Bezeichnung_AttributeGroupItemProvider == null) {
			leU_Anlage_Bezeichnung_AttributeGroupItemProvider = new LEU_Anlage_Bezeichnung_AttributeGroupItemProvider(this);
		}

		return leU_Anlage_Bezeichnung_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LEU_Ausgang_Nr_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LEU_Ausgang_Nr_TypeClassItemProvider leU_Ausgang_Nr_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LEU_Ausgang_Nr_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLEU_Ausgang_Nr_TypeClassAdapter() {
		if (leU_Ausgang_Nr_TypeClassItemProvider == null) {
			leU_Ausgang_Nr_TypeClassItemProvider = new LEU_Ausgang_Nr_TypeClassItemProvider(this);
		}

		return leU_Ausgang_Nr_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LEU_Modul} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LEU_ModulItemProvider leU_ModulItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LEU_Modul}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLEU_ModulAdapter() {
		if (leU_ModulItemProvider == null) {
			leU_ModulItemProvider = new LEU_ModulItemProvider(this);
		}

		return leU_ModulItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LEU_Modul_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LEU_Modul_Allg_AttributeGroupItemProvider leU_Modul_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LEU_Modul_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLEU_Modul_Allg_AttributeGroupAdapter() {
		if (leU_Modul_Allg_AttributeGroupItemProvider == null) {
			leU_Modul_Allg_AttributeGroupItemProvider = new LEU_Modul_Allg_AttributeGroupItemProvider(this);
		}

		return leU_Modul_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LEU_Modul_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LEU_Modul_Art_TypeClassItemProvider leU_Modul_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LEU_Modul_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLEU_Modul_Art_TypeClassAdapter() {
		if (leU_Modul_Art_TypeClassItemProvider == null) {
			leU_Modul_Art_TypeClassItemProvider = new LEU_Modul_Art_TypeClassItemProvider(this);
		}

		return leU_Modul_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LEU_Modul_Ausgang_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LEU_Modul_Ausgang_AttributeGroupItemProvider leU_Modul_Ausgang_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LEU_Modul_Ausgang_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLEU_Modul_Ausgang_AttributeGroupAdapter() {
		if (leU_Modul_Ausgang_AttributeGroupItemProvider == null) {
			leU_Modul_Ausgang_AttributeGroupItemProvider = new LEU_Modul_Ausgang_AttributeGroupItemProvider(this);
		}

		return leU_Modul_Ausgang_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LEU_Modul_Bezeichnung_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LEU_Modul_Bezeichnung_AttributeGroupItemProvider leU_Modul_Bezeichnung_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LEU_Modul_Bezeichnung_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLEU_Modul_Bezeichnung_AttributeGroupAdapter() {
		if (leU_Modul_Bezeichnung_AttributeGroupItemProvider == null) {
			leU_Modul_Bezeichnung_AttributeGroupItemProvider = new LEU_Modul_Bezeichnung_AttributeGroupItemProvider(this);
		}

		return leU_Modul_Bezeichnung_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LEU_Modul_Geraetestand_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LEU_Modul_Geraetestand_TypeClassItemProvider leU_Modul_Geraetestand_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LEU_Modul_Geraetestand_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLEU_Modul_Geraetestand_TypeClassAdapter() {
		if (leU_Modul_Geraetestand_TypeClassItemProvider == null) {
			leU_Modul_Geraetestand_TypeClassItemProvider = new LEU_Modul_Geraetestand_TypeClassItemProvider(this);
		}

		return leU_Modul_Geraetestand_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LEU_Modul_Typ_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LEU_Modul_Typ_TypeClassItemProvider leU_Modul_Typ_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LEU_Modul_Typ_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLEU_Modul_Typ_TypeClassAdapter() {
		if (leU_Modul_Typ_TypeClassItemProvider == null) {
			leU_Modul_Typ_TypeClassItemProvider = new LEU_Modul_Typ_TypeClassItemProvider(this);
		}

		return leU_Modul_Typ_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LEU_Schaltkasten} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LEU_SchaltkastenItemProvider leU_SchaltkastenItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LEU_Schaltkasten}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLEU_SchaltkastenAdapter() {
		if (leU_SchaltkastenItemProvider == null) {
			leU_SchaltkastenItemProvider = new LEU_SchaltkastenItemProvider(this);
		}

		return leU_SchaltkastenItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LEU_Schaltkasten_Bezeichnung_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LEU_Schaltkasten_Bezeichnung_AttributeGroupItemProvider leU_Schaltkasten_Bezeichnung_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LEU_Schaltkasten_Bezeichnung_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLEU_Schaltkasten_Bezeichnung_AttributeGroupAdapter() {
		if (leU_Schaltkasten_Bezeichnung_AttributeGroupItemProvider == null) {
			leU_Schaltkasten_Bezeichnung_AttributeGroupItemProvider = new LEU_Schaltkasten_Bezeichnung_AttributeGroupItemProvider(this);
		}

		return leU_Schaltkasten_Bezeichnung_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LEU_Schaltkasten_Energie_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LEU_Schaltkasten_Energie_AttributeGroupItemProvider leU_Schaltkasten_Energie_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LEU_Schaltkasten_Energie_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLEU_Schaltkasten_Energie_AttributeGroupAdapter() {
		if (leU_Schaltkasten_Energie_AttributeGroupItemProvider == null) {
			leU_Schaltkasten_Energie_AttributeGroupItemProvider = new LEU_Schaltkasten_Energie_AttributeGroupItemProvider(this);
		}

		return leU_Schaltkasten_Energie_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LEU_Schaltkasten_Position_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LEU_Schaltkasten_Position_AttributeGroupItemProvider leU_Schaltkasten_Position_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LEU_Schaltkasten_Position_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLEU_Schaltkasten_Position_AttributeGroupAdapter() {
		if (leU_Schaltkasten_Position_AttributeGroupItemProvider == null) {
			leU_Schaltkasten_Position_AttributeGroupItemProvider = new LEU_Schaltkasten_Position_AttributeGroupItemProvider(this);
		}

		return leU_Schaltkasten_Position_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LEU_Schaltkasten_Typ_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LEU_Schaltkasten_Typ_TypeClassItemProvider leU_Schaltkasten_Typ_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LEU_Schaltkasten_Typ_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLEU_Schaltkasten_Typ_TypeClassAdapter() {
		if (leU_Schaltkasten_Typ_TypeClassItemProvider == null) {
			leU_Schaltkasten_Typ_TypeClassItemProvider = new LEU_Schaltkasten_Typ_TypeClassItemProvider(this);
		}

		return leU_Schaltkasten_Typ_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LEU_Steuernde_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LEU_Steuernde_AttributeGroupItemProvider leU_Steuernde_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LEU_Steuernde_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLEU_Steuernde_AttributeGroupAdapter() {
		if (leU_Steuernde_AttributeGroupItemProvider == null) {
			leU_Steuernde_AttributeGroupItemProvider = new LEU_Steuernde_AttributeGroupItemProvider(this);
		}

		return leU_Steuernde_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Lfd_Nr_Am_Bezugspunkt_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Lfd_Nr_Am_Bezugspunkt_TypeClassItemProvider lfd_Nr_Am_Bezugspunkt_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Lfd_Nr_Am_Bezugspunkt_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLfd_Nr_Am_Bezugspunkt_TypeClassAdapter() {
		if (lfd_Nr_Am_Bezugspunkt_TypeClassItemProvider == null) {
			lfd_Nr_Am_Bezugspunkt_TypeClassItemProvider = new Lfd_Nr_Am_Bezugspunkt_TypeClassItemProvider(this);
		}

		return lfd_Nr_Am_Bezugspunkt_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Link_Distanz_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Link_Distanz_TypeClassItemProvider link_Distanz_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Link_Distanz_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLink_Distanz_TypeClassAdapter() {
		if (link_Distanz_TypeClassItemProvider == null) {
			link_Distanz_TypeClassItemProvider = new Link_Distanz_TypeClassItemProvider(this);
		}

		return link_Distanz_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LLA_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LLA_TypeClassItemProvider llA_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LLA_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLLA_TypeClassAdapter() {
		if (llA_TypeClassItemProvider == null) {
			llA_TypeClassItemProvider = new LLA_TypeClassItemProvider(this);
		}

		return llA_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LM_G_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LM_G_TypeClassItemProvider lM_G_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LM_G_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLM_G_TypeClassAdapter() {
		if (lM_G_TypeClassItemProvider == null) {
			lM_G_TypeClassItemProvider = new LM_G_TypeClassItemProvider(this);
		}

		return lM_G_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LT_Binaerdatei_Hilfe_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LT_Binaerdatei_Hilfe_AttributeGroupItemProvider lT_Binaerdatei_Hilfe_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LT_Binaerdatei_Hilfe_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLT_Binaerdatei_Hilfe_AttributeGroupAdapter() {
		if (lT_Binaerdatei_Hilfe_AttributeGroupItemProvider == null) {
			lT_Binaerdatei_Hilfe_AttributeGroupItemProvider = new LT_Binaerdatei_Hilfe_AttributeGroupItemProvider(this);
		}

		return lT_Binaerdatei_Hilfe_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LT_Binaerdaten_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LT_Binaerdaten_AttributeGroupItemProvider lT_Binaerdaten_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.LT_Binaerdaten_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLT_Binaerdaten_AttributeGroupAdapter() {
		if (lT_Binaerdaten_AttributeGroupItemProvider == null) {
			lT_Binaerdaten_AttributeGroupItemProvider = new LT_Binaerdaten_AttributeGroupItemProvider(this);
		}

		return lT_Binaerdaten_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Luft_Telegramm} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Luft_TelegrammItemProvider luft_TelegrammItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Luft_Telegramm}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLuft_TelegrammAdapter() {
		if (luft_TelegrammItemProvider == null) {
			luft_TelegrammItemProvider = new Luft_TelegrammItemProvider(this);
		}

		return luft_TelegrammItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.M_LEVELTR_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected M_LEVELTR_TypeClassItemProvider m_LEVELTR_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.M_LEVELTR_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createM_LEVELTR_TypeClassAdapter() {
		if (m_LEVELTR_TypeClassItemProvider == null) {
			m_LEVELTR_TypeClassItemProvider = new M_LEVELTR_TypeClassItemProvider(this);
		}

		return m_LEVELTR_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Massgebende_Neig_1_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Massgebende_Neig_1_TypeClassItemProvider massgebende_Neig_1_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Massgebende_Neig_1_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMassgebende_Neig_1_TypeClassAdapter() {
		if (massgebende_Neig_1_TypeClassItemProvider == null) {
			massgebende_Neig_1_TypeClassItemProvider = new Massgebende_Neig_1_TypeClassItemProvider(this);
		}

		return massgebende_Neig_1_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Massgebende_Neig_Schutzstrecke_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Massgebende_Neig_Schutzstrecke_TypeClassItemProvider massgebende_Neig_Schutzstrecke_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Massgebende_Neig_Schutzstrecke_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMassgebende_Neig_Schutzstrecke_TypeClassAdapter() {
		if (massgebende_Neig_Schutzstrecke_TypeClassItemProvider == null) {
			massgebende_Neig_Schutzstrecke_TypeClassItemProvider = new Massgebende_Neig_Schutzstrecke_TypeClassItemProvider(this);
		}

		return massgebende_Neig_Schutzstrecke_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Massgebende_Neigung_Mind_150_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Massgebende_Neigung_Mind_150_TypeClassItemProvider massgebende_Neigung_Mind_150_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Massgebende_Neigung_Mind_150_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMassgebende_Neigung_Mind_150_TypeClassAdapter() {
		if (massgebende_Neigung_Mind_150_TypeClassItemProvider == null) {
			massgebende_Neigung_Mind_150_TypeClassItemProvider = new Massgebende_Neigung_Mind_150_TypeClassItemProvider(this);
		}

		return massgebende_Neigung_Mind_150_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Massgebende_Neigung_Mind_Sig_150_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Massgebende_Neigung_Mind_Sig_150_TypeClassItemProvider massgebende_Neigung_Mind_Sig_150_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Massgebende_Neigung_Mind_Sig_150_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMassgebende_Neigung_Mind_Sig_150_TypeClassAdapter() {
		if (massgebende_Neigung_Mind_Sig_150_TypeClassItemProvider == null) {
			massgebende_Neigung_Mind_Sig_150_TypeClassItemProvider = new Massgebende_Neigung_Mind_Sig_150_TypeClassItemProvider(this);
		}

		return massgebende_Neigung_Mind_Sig_150_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Massgebende_Neigung_Mind_Sig_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Massgebende_Neigung_Mind_Sig_TypeClassItemProvider massgebende_Neigung_Mind_Sig_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Massgebende_Neigung_Mind_Sig_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMassgebende_Neigung_Mind_Sig_TypeClassAdapter() {
		if (massgebende_Neigung_Mind_Sig_TypeClassItemProvider == null) {
			massgebende_Neigung_Mind_Sig_TypeClassItemProvider = new Massgebende_Neigung_Mind_Sig_TypeClassItemProvider(this);
		}

		return massgebende_Neigung_Mind_Sig_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Mastschild_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Mastschild_TypeClassItemProvider mastschild_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Mastschild_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMastschild_TypeClassAdapter() {
		if (mastschild_TypeClassItemProvider == null) {
			mastschild_TypeClassItemProvider = new Mastschild_TypeClassItemProvider(this);
		}

		return mastschild_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Max_Leistung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Max_Leistung_TypeClassItemProvider max_Leistung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Max_Leistung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMax_Leistung_TypeClassAdapter() {
		if (max_Leistung_TypeClassItemProvider == null) {
			max_Leistung_TypeClassItemProvider = new Max_Leistung_TypeClassItemProvider(this);
		}

		return max_Leistung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Max_Unterbrechungszeit_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Max_Unterbrechungszeit_TypeClassItemProvider max_Unterbrechungszeit_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Max_Unterbrechungszeit_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMax_Unterbrechungszeit_TypeClassAdapter() {
		if (max_Unterbrechungszeit_TypeClassItemProvider == null) {
			max_Unterbrechungszeit_TypeClassItemProvider = new Max_Unterbrechungszeit_TypeClassItemProvider(this);
		}

		return max_Unterbrechungszeit_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Metallteil_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Metallteil_AttributeGroupItemProvider metallteil_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Metallteil_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMetallteil_AttributeGroupAdapter() {
		if (metallteil_AttributeGroupItemProvider == null) {
			metallteil_AttributeGroupItemProvider = new Metallteil_AttributeGroupItemProvider(this);
		}

		return metallteil_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Metallteil_Kategorie_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Metallteil_Kategorie_TypeClassItemProvider metallteil_Kategorie_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Metallteil_Kategorie_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMetallteil_Kategorie_TypeClassAdapter() {
		if (metallteil_Kategorie_TypeClassItemProvider == null) {
			metallteil_Kategorie_TypeClassItemProvider = new Metallteil_Kategorie_TypeClassItemProvider(this);
		}

		return metallteil_Kategorie_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Metallteil_Laenge_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Metallteil_Laenge_TypeClassItemProvider metallteil_Laenge_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Metallteil_Laenge_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMetallteil_Laenge_TypeClassAdapter() {
		if (metallteil_Laenge_TypeClassItemProvider == null) {
			metallteil_Laenge_TypeClassItemProvider = new Metallteil_Laenge_TypeClassItemProvider(this);
		}

		return metallteil_Laenge_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Modulnummer_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Modulnummer_TypeClassItemProvider modulnummer_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Modulnummer_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModulnummer_TypeClassAdapter() {
		if (modulnummer_TypeClassItemProvider == null) {
			modulnummer_TypeClassItemProvider = new Modulnummer_TypeClassItemProvider(this);
		}

		return modulnummer_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Montageabweichung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Montageabweichung_TypeClassItemProvider montageabweichung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Montageabweichung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMontageabweichung_TypeClassAdapter() {
		if (montageabweichung_TypeClassItemProvider == null) {
			montageabweichung_TypeClassItemProvider = new Montageabweichung_TypeClassItemProvider(this);
		}

		return montageabweichung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Neigung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Neigung_TypeClassItemProvider neigung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Neigung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNeigung_TypeClassAdapter() {
		if (neigung_TypeClassItemProvider == null) {
			neigung_TypeClassItemProvider = new Neigung_TypeClassItemProvider(this);
		}

		return neigung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Nennleistung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Nennleistung_TypeClassItemProvider nennleistung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Nennleistung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNennleistung_TypeClassAdapter() {
		if (nennleistung_TypeClassItemProvider == null) {
			nennleistung_TypeClassItemProvider = new Nennleistung_TypeClassItemProvider(this);
		}

		return nennleistung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.NID_BG_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NID_BG_TypeClassItemProvider niD_BG_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.NID_BG_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNID_BG_TypeClassAdapter() {
		if (niD_BG_TypeClassItemProvider == null) {
			niD_BG_TypeClassItemProvider = new NID_BG_TypeClassItemProvider(this);
		}

		return niD_BG_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.NID_C_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NID_C_TypeClassItemProvider niD_C_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.NID_C_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNID_C_TypeClassAdapter() {
		if (niD_C_TypeClassItemProvider == null) {
			niD_C_TypeClassItemProvider = new NID_C_TypeClassItemProvider(this);
		}

		return niD_C_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.NID_RBC_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NID_RBC_TypeClassItemProvider niD_RBC_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.NID_RBC_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNID_RBC_TypeClassAdapter() {
		if (niD_RBC_TypeClassItemProvider == null) {
			niD_RBC_TypeClassItemProvider = new NID_RBC_TypeClassItemProvider(this);
		}

		return niD_RBC_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.NID_STM_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NID_STM_TypeClassItemProvider niD_STM_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.NID_STM_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNID_STM_TypeClassAdapter() {
		if (niD_STM_TypeClassItemProvider == null) {
			niD_STM_TypeClassItemProvider = new NID_STM_TypeClassItemProvider(this);
		}

		return niD_STM_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.NID_TSR_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NID_TSR_TypeClassItemProvider niD_TSR_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.NID_TSR_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNID_TSR_TypeClassAdapter() {
		if (niD_TSR_TypeClassItemProvider == null) {
			niD_TSR_TypeClassItemProvider = new NID_TSR_TypeClassItemProvider(this);
		}

		return niD_TSR_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Nummer_Schaltkasten_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Nummer_Schaltkasten_TypeClassItemProvider nummer_Schaltkasten_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Nummer_Schaltkasten_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNummer_Schaltkasten_TypeClassAdapter() {
		if (nummer_Schaltkasten_TypeClassItemProvider == null) {
			nummer_Schaltkasten_TypeClassItemProvider = new Nummer_Schaltkasten_TypeClassItemProvider(this);
		}

		return nummer_Schaltkasten_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Oberstrombegrenzung_Gueterzug_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Oberstrombegrenzung_Gueterzug_TypeClassItemProvider oberstrombegrenzung_Gueterzug_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Oberstrombegrenzung_Gueterzug_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOberstrombegrenzung_Gueterzug_TypeClassAdapter() {
		if (oberstrombegrenzung_Gueterzug_TypeClassItemProvider == null) {
			oberstrombegrenzung_Gueterzug_TypeClassItemProvider = new Oberstrombegrenzung_Gueterzug_TypeClassItemProvider(this);
		}

		return oberstrombegrenzung_Gueterzug_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Oberstrombegrenzung_Reisezug_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Oberstrombegrenzung_Reisezug_TypeClassItemProvider oberstrombegrenzung_Reisezug_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Oberstrombegrenzung_Reisezug_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOberstrombegrenzung_Reisezug_TypeClassAdapter() {
		if (oberstrombegrenzung_Reisezug_TypeClassItemProvider == null) {
			oberstrombegrenzung_Reisezug_TypeClassItemProvider = new Oberstrombegrenzung_Reisezug_TypeClassItemProvider(this);
		}

		return oberstrombegrenzung_Reisezug_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Port_Nr_Ausg_Physisch_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Port_Nr_Ausg_Physisch_TypeClassItemProvider port_Nr_Ausg_Physisch_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Port_Nr_Ausg_Physisch_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPort_Nr_Ausg_Physisch_TypeClassAdapter() {
		if (port_Nr_Ausg_Physisch_TypeClassItemProvider == null) {
			port_Nr_Ausg_Physisch_TypeClassItemProvider = new Port_Nr_Ausg_Physisch_TypeClassItemProvider(this);
		}

		return port_Nr_Ausg_Physisch_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Position_Sonstige_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Position_Sonstige_TypeClassItemProvider position_Sonstige_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Position_Sonstige_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPosition_Sonstige_TypeClassAdapter() {
		if (position_Sonstige_TypeClassItemProvider == null) {
			position_Sonstige_TypeClassItemProvider = new Position_Sonstige_TypeClassItemProvider(this);
		}

		return position_Sonstige_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Position_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Position_TypeClassItemProvider position_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Position_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPosition_TypeClassAdapter() {
		if (position_TypeClassItemProvider == null) {
			position_TypeClassItemProvider = new Position_TypeClassItemProvider(this);
		}

		return position_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Primaerquelle_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Primaerquelle_TypeClassItemProvider primaerquelle_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Primaerquelle_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPrimaerquelle_TypeClassAdapter() {
		if (primaerquelle_TypeClassItemProvider == null) {
			primaerquelle_TypeClassItemProvider = new Primaerquelle_TypeClassItemProvider(this);
		}

		return primaerquelle_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Prioritaet_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Prioritaet_TypeClassItemProvider prioritaet_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Prioritaet_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPrioritaet_TypeClassAdapter() {
		if (prioritaet_TypeClassItemProvider == null) {
			prioritaet_TypeClassItemProvider = new Prioritaet_TypeClassItemProvider(this);
		}

		return prioritaet_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Prog_Datei_Einzel_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Prog_Datei_Einzel_AttributeGroupItemProvider prog_Datei_Einzel_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Prog_Datei_Einzel_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProg_Datei_Einzel_AttributeGroupAdapter() {
		if (prog_Datei_Einzel_AttributeGroupItemProvider == null) {
			prog_Datei_Einzel_AttributeGroupItemProvider = new Prog_Datei_Einzel_AttributeGroupItemProvider(this);
		}

		return prog_Datei_Einzel_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Prog_Datei_Gruppe} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Prog_Datei_GruppeItemProvider prog_Datei_GruppeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Prog_Datei_Gruppe}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProg_Datei_GruppeAdapter() {
		if (prog_Datei_GruppeItemProvider == null) {
			prog_Datei_GruppeItemProvider = new Prog_Datei_GruppeItemProvider(this);
		}

		return prog_Datei_GruppeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Projektierungsfall_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Projektierungsfall_TypeClassItemProvider projektierungsfall_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Projektierungsfall_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProjektierungsfall_TypeClassAdapter() {
		if (projektierungsfall_TypeClassItemProvider == null) {
			projektierungsfall_TypeClassItemProvider = new Projektierungsfall_TypeClassItemProvider(this);
		}

		return projektierungsfall_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.RBC} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RBCItemProvider rbcItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.RBC}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRBCAdapter() {
		if (rbcItemProvider == null) {
			rbcItemProvider = new RBCItemProvider(this);
		}

		return rbcItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.RBC_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RBC_Allg_AttributeGroupItemProvider rbC_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.RBC_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRBC_Allg_AttributeGroupAdapter() {
		if (rbC_Allg_AttributeGroupItemProvider == null) {
			rbC_Allg_AttributeGroupItemProvider = new RBC_Allg_AttributeGroupItemProvider(this);
		}

		return rbC_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.RBC_ETCS_System_Version_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RBC_ETCS_System_Version_TypeClassItemProvider rbC_ETCS_System_Version_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.RBC_ETCS_System_Version_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRBC_ETCS_System_Version_TypeClassAdapter() {
		if (rbC_ETCS_System_Version_TypeClassItemProvider == null) {
			rbC_ETCS_System_Version_TypeClassItemProvider = new RBC_ETCS_System_Version_TypeClassItemProvider(this);
		}

		return rbC_ETCS_System_Version_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.RBC_SRS_Version_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RBC_SRS_Version_TypeClassItemProvider rbC_SRS_Version_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.RBC_SRS_Version_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRBC_SRS_Version_TypeClassAdapter() {
		if (rbC_SRS_Version_TypeClassItemProvider == null) {
			rbC_SRS_Version_TypeClassItemProvider = new RBC_SRS_Version_TypeClassItemProvider(this);
		}

		return rbC_SRS_Version_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Rekursion_2_Nr_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Rekursion_2_Nr_TypeClassItemProvider rekursion_2_Nr_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Rekursion_2_Nr_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRekursion_2_Nr_TypeClassAdapter() {
		if (rekursion_2_Nr_TypeClassItemProvider == null) {
			rekursion_2_Nr_TypeClassItemProvider = new Rekursion_2_Nr_TypeClassItemProvider(this);
		}

		return rekursion_2_Nr_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Rekursion_Nr_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Rekursion_Nr_TypeClassItemProvider rekursion_Nr_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Rekursion_Nr_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRekursion_Nr_TypeClassAdapter() {
		if (rekursion_Nr_TypeClassItemProvider == null) {
			rekursion_Nr_TypeClassItemProvider = new Rekursion_Nr_TypeClassItemProvider(this);
		}

		return rekursion_Nr_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Rufnummer_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Rufnummer_TypeClassItemProvider rufnummer_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Rufnummer_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRufnummer_TypeClassAdapter() {
		if (rufnummer_TypeClassItemProvider == null) {
			rufnummer_TypeClassItemProvider = new Rufnummer_TypeClassItemProvider(this);
		}

		return rufnummer_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.SBE_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SBE_TypeClassItemProvider sbE_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.SBE_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSBE_TypeClassAdapter() {
		if (sbE_TypeClassItemProvider == null) {
			sbE_TypeClassItemProvider = new SBE_TypeClassItemProvider(this);
		}

		return sbE_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Schutzstrecke_Erforderlich_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Schutzstrecke_Erforderlich_TypeClassItemProvider schutzstrecke_Erforderlich_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Schutzstrecke_Erforderlich_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSchutzstrecke_Erforderlich_TypeClassAdapter() {
		if (schutzstrecke_Erforderlich_TypeClassItemProvider == null) {
			schutzstrecke_Erforderlich_TypeClassItemProvider = new Schutzstrecke_Erforderlich_TypeClassItemProvider(this);
		}

		return schutzstrecke_Erforderlich_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Schutzstrecke_Vorhanden_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Schutzstrecke_Vorhanden_TypeClassItemProvider schutzstrecke_Vorhanden_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Schutzstrecke_Vorhanden_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSchutzstrecke_Vorhanden_TypeClassAdapter() {
		if (schutzstrecke_Vorhanden_TypeClassItemProvider == null) {
			schutzstrecke_Vorhanden_TypeClassItemProvider = new Schutzstrecke_Vorhanden_TypeClassItemProvider(this);
		}

		return schutzstrecke_Vorhanden_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Solllaenge_Mind_Sig_150_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Solllaenge_Mind_Sig_150_TypeClassItemProvider solllaenge_Mind_Sig_150_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Solllaenge_Mind_Sig_150_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSolllaenge_Mind_Sig_150_TypeClassAdapter() {
		if (solllaenge_Mind_Sig_150_TypeClassItemProvider == null) {
			solllaenge_Mind_Sig_150_TypeClassItemProvider = new Solllaenge_Mind_Sig_150_TypeClassItemProvider(this);
		}

		return solllaenge_Mind_Sig_150_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Solllaenge_Mind_Sig_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Solllaenge_Mind_Sig_TypeClassItemProvider solllaenge_Mind_Sig_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Solllaenge_Mind_Sig_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSolllaenge_Mind_Sig_TypeClassAdapter() {
		if (solllaenge_Mind_Sig_TypeClassItemProvider == null) {
			solllaenge_Mind_Sig_TypeClassItemProvider = new Solllaenge_Mind_Sig_TypeClassItemProvider(this);
		}

		return solllaenge_Mind_Sig_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Sonstige_Standortangabe_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Sonstige_Standortangabe_TypeClassItemProvider sonstige_Standortangabe_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Sonstige_Standortangabe_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSonstige_Standortangabe_TypeClassAdapter() {
		if (sonstige_Standortangabe_TypeClassItemProvider == null) {
			sonstige_Standortangabe_TypeClassItemProvider = new Sonstige_Standortangabe_TypeClassItemProvider(this);
		}

		return sonstige_Standortangabe_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Spannung_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Spannung_Art_TypeClassItemProvider spannung_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Spannung_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSpannung_Art_TypeClassAdapter() {
		if (spannung_Art_TypeClassItemProvider == null) {
			spannung_Art_TypeClassItemProvider = new Spannung_Art_TypeClassItemProvider(this);
		}

		return spannung_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Spannung_Toleranz_Obere_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Spannung_Toleranz_Obere_TypeClassItemProvider spannung_Toleranz_Obere_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Spannung_Toleranz_Obere_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSpannung_Toleranz_Obere_TypeClassAdapter() {
		if (spannung_Toleranz_Obere_TypeClassItemProvider == null) {
			spannung_Toleranz_Obere_TypeClassItemProvider = new Spannung_Toleranz_Obere_TypeClassItemProvider(this);
		}

		return spannung_Toleranz_Obere_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Spannung_Toleranz_Untere_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Spannung_Toleranz_Untere_TypeClassItemProvider spannung_Toleranz_Untere_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Spannung_Toleranz_Untere_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSpannung_Toleranz_Untere_TypeClassAdapter() {
		if (spannung_Toleranz_Untere_TypeClassItemProvider == null) {
			spannung_Toleranz_Untere_TypeClassItemProvider = new Spannung_Toleranz_Untere_TypeClassItemProvider(this);
		}

		return spannung_Toleranz_Untere_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.SRS_Version_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SRS_Version_TypeClassItemProvider srS_Version_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.SRS_Version_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSRS_Version_TypeClassAdapter() {
		if (srS_Version_TypeClassItemProvider == null) {
			srS_Version_TypeClassItemProvider = new SRS_Version_TypeClassItemProvider(this);
		}

		return srS_Version_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Standortangabe_Balisenschild_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Standortangabe_Balisenschild_TypeClassItemProvider standortangabe_Balisenschild_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Standortangabe_Balisenschild_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStandortangabe_Balisenschild_TypeClassAdapter() {
		if (standortangabe_Balisenschild_TypeClassItemProvider == null) {
			standortangabe_Balisenschild_TypeClassItemProvider = new Standortangabe_Balisenschild_TypeClassItemProvider(this);
		}

		return standortangabe_Balisenschild_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Start_W_Element_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Start_W_Element_AttributeGroupItemProvider start_W_Element_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Start_W_Element_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStart_W_Element_AttributeGroupAdapter() {
		if (start_W_Element_AttributeGroupItemProvider == null) {
			start_W_Element_AttributeGroupItemProvider = new Start_W_Element_AttributeGroupItemProvider(this);
		}

		return start_W_Element_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.STZ_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected STZ_TypeClassItemProvider stZ_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.STZ_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSTZ_TypeClassAdapter() {
		if (stZ_TypeClassItemProvider == null) {
			stZ_TypeClassItemProvider = new STZ_TypeClassItemProvider(this);
		}

		return stZ_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.System_Vor_Grenze_Besonders_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected System_Vor_Grenze_Besonders_TypeClassItemProvider system_Vor_Grenze_Besonders_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.System_Vor_Grenze_Besonders_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSystem_Vor_Grenze_Besonders_TypeClassAdapter() {
		if (system_Vor_Grenze_Besonders_TypeClassItemProvider == null) {
			system_Vor_Grenze_Besonders_TypeClassItemProvider = new System_Vor_Grenze_Besonders_TypeClassItemProvider(this);
		}

		return system_Vor_Grenze_Besonders_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.System_Vor_Grenze_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected System_Vor_Grenze_TypeClassItemProvider system_Vor_Grenze_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.System_Vor_Grenze_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSystem_Vor_Grenze_TypeClassAdapter() {
		if (system_Vor_Grenze_TypeClassItemProvider == null) {
			system_Vor_Grenze_TypeClassItemProvider = new System_Vor_Grenze_TypeClassItemProvider(this);
		}

		return system_Vor_Grenze_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.TBV_Meldepunkt_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TBV_Meldepunkt_TypeClassItemProvider tbV_Meldepunkt_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.TBV_Meldepunkt_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTBV_Meldepunkt_TypeClassAdapter() {
		if (tbV_Meldepunkt_TypeClassItemProvider == null) {
			tbV_Meldepunkt_TypeClassItemProvider = new TBV_Meldepunkt_TypeClassItemProvider(this);
		}

		return tbV_Meldepunkt_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.TBV_Tunnelbereich_Laenge_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TBV_Tunnelbereich_Laenge_TypeClassItemProvider tbV_Tunnelbereich_Laenge_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.TBV_Tunnelbereich_Laenge_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTBV_Tunnelbereich_Laenge_TypeClassAdapter() {
		if (tbV_Tunnelbereich_Laenge_TypeClassItemProvider == null) {
			tbV_Tunnelbereich_Laenge_TypeClassItemProvider = new TBV_Tunnelbereich_Laenge_TypeClassItemProvider(this);
		}

		return tbV_Tunnelbereich_Laenge_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.TBV_Tunnelsignal_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TBV_Tunnelsignal_TypeClassItemProvider tbV_Tunnelsignal_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.TBV_Tunnelsignal_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTBV_Tunnelsignal_TypeClassAdapter() {
		if (tbV_Tunnelsignal_TypeClassItemProvider == null) {
			tbV_Tunnelsignal_TypeClassItemProvider = new TBV_Tunnelsignal_TypeClassItemProvider(this);
		}

		return tbV_Tunnelsignal_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Telegramm_Index_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Telegramm_Index_TypeClassItemProvider telegramm_Index_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Telegramm_Index_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTelegramm_Index_TypeClassAdapter() {
		if (telegramm_Index_TypeClassItemProvider == null) {
			telegramm_Index_TypeClassItemProvider = new Telegramm_Index_TypeClassItemProvider(this);
		}

		return telegramm_Index_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Telegrammnummer_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Telegrammnummer_TypeClassItemProvider telegrammnummer_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Telegrammnummer_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTelegrammnummer_TypeClassAdapter() {
		if (telegrammnummer_TypeClassItemProvider == null) {
			telegrammnummer_TypeClassItemProvider = new Telegrammnummer_TypeClassItemProvider(this);
		}

		return telegrammnummer_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Text_Bedingung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Text_Bedingung_TypeClassItemProvider text_Bedingung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Text_Bedingung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createText_Bedingung_TypeClassAdapter() {
		if (text_Bedingung_TypeClassItemProvider == null) {
			text_Bedingung_TypeClassItemProvider = new Text_Bedingung_TypeClassItemProvider(this);
		}

		return text_Bedingung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Textmeldung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Textmeldung_TypeClassItemProvider textmeldung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Textmeldung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTextmeldung_TypeClassAdapter() {
		if (textmeldung_TypeClassItemProvider == null) {
			textmeldung_TypeClassItemProvider = new Textmeldung_TypeClassItemProvider(this);
		}

		return textmeldung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Ueberbrueckung_EV_Unterbrechung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Ueberbrueckung_EV_Unterbrechung_TypeClassItemProvider ueberbrueckung_EV_Unterbrechung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Ueberbrueckung_EV_Unterbrechung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUeberbrueckung_EV_Unterbrechung_TypeClassAdapter() {
		if (ueberbrueckung_EV_Unterbrechung_TypeClassItemProvider == null) {
			ueberbrueckung_EV_Unterbrechung_TypeClassItemProvider = new Ueberbrueckung_EV_Unterbrechung_TypeClassItemProvider(this);
		}

		return ueberbrueckung_EV_Unterbrechung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Ueberwachung_Laenge_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Ueberwachung_Laenge_TypeClassItemProvider ueberwachung_Laenge_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Ueberwachung_Laenge_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUeberwachung_Laenge_TypeClassAdapter() {
		if (ueberwachung_Laenge_TypeClassItemProvider == null) {
			ueberwachung_Laenge_TypeClassItemProvider = new Ueberwachung_Laenge_TypeClassItemProvider(this);
		}

		return ueberwachung_Laenge_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Umfahrstrasse_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Umfahrstrasse_TypeClassItemProvider umfahrstrasse_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Umfahrstrasse_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUmfahrstrasse_TypeClassAdapter() {
		if (umfahrstrasse_TypeClassItemProvider == null) {
			umfahrstrasse_TypeClassItemProvider = new Umfahrstrasse_TypeClassItemProvider(this);
		}

		return umfahrstrasse_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Untergruppen_ID_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Untergruppen_ID_TypeClassItemProvider untergruppen_ID_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Untergruppen_ID_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUntergruppen_ID_TypeClassAdapter() {
		if (untergruppen_ID_TypeClassItemProvider == null) {
			untergruppen_ID_TypeClassItemProvider = new Untergruppen_ID_TypeClassItemProvider(this);
		}

		return untergruppen_ID_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.V_Befehl_R_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected V_Befehl_R_TypeClassItemProvider v_Befehl_R_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.V_Befehl_R_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createV_Befehl_R_TypeClassAdapter() {
		if (v_Befehl_R_TypeClassItemProvider == null) {
			v_Befehl_R_TypeClassItemProvider = new V_Befehl_R_TypeClassItemProvider(this);
		}

		return v_Befehl_R_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.V_Befehl_Z_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected V_Befehl_Z_TypeClassItemProvider v_Befehl_Z_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.V_Befehl_Z_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createV_Befehl_Z_TypeClassAdapter() {
		if (v_Befehl_Z_TypeClassItemProvider == null) {
			v_Befehl_Z_TypeClassItemProvider = new V_Befehl_Z_TypeClassItemProvider(this);
		}

		return v_Befehl_Z_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.V_Frei_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected V_Frei_TypeClassItemProvider v_Frei_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.V_Frei_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createV_Frei_TypeClassAdapter() {
		if (v_Frei_TypeClassItemProvider == null) {
			v_Frei_TypeClassItemProvider = new V_Frei_TypeClassItemProvider(this);
		}

		return v_Frei_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.V_Start_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected V_Start_TypeClassItemProvider v_Start_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.V_Start_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createV_Start_TypeClassAdapter() {
		if (v_Start_TypeClassItemProvider == null) {
			v_Start_TypeClassItemProvider = new V_Start_TypeClassItemProvider(this);
		}

		return v_Start_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.V_Ziel_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected V_Ziel_TypeClassItemProvider v_Ziel_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.V_Ziel_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createV_Ziel_TypeClassAdapter() {
		if (v_Ziel_TypeClassItemProvider == null) {
			v_Ziel_TypeClassItemProvider = new V_Ziel_TypeClassItemProvider(this);
		}

		return v_Ziel_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.V_Zul_Strecke_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected V_Zul_Strecke_TypeClassItemProvider v_Zul_Strecke_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.V_Zul_Strecke_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createV_Zul_Strecke_TypeClassAdapter() {
		if (v_Zul_Strecke_TypeClassItemProvider == null) {
			v_Zul_Strecke_TypeClassItemProvider = new V_Zul_Strecke_TypeClassItemProvider(this);
		}

		return v_Zul_Strecke_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.VBC_Kennung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VBC_Kennung_TypeClassItemProvider vbC_Kennung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.VBC_Kennung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVBC_Kennung_TypeClassAdapter() {
		if (vbC_Kennung_TypeClassItemProvider == null) {
			vbC_Kennung_TypeClassItemProvider = new VBC_Kennung_TypeClassItemProvider(this);
		}

		return vbC_Kennung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.VBC_NID_C_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VBC_NID_C_TypeClassItemProvider vbC_NID_C_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.VBC_NID_C_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVBC_NID_C_TypeClassAdapter() {
		if (vbC_NID_C_TypeClassItemProvider == null) {
			vbC_NID_C_TypeClassItemProvider = new VBC_NID_C_TypeClassItemProvider(this);
		}

		return vbC_NID_C_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.VBC_Setzen_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VBC_Setzen_TypeClassItemProvider vbC_Setzen_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.VBC_Setzen_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVBC_Setzen_TypeClassAdapter() {
		if (vbC_Setzen_TypeClassItemProvider == null) {
			vbC_Setzen_TypeClassItemProvider = new VBC_Setzen_TypeClassItemProvider(this);
		}

		return vbC_Setzen_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.VBC_Timer_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VBC_Timer_TypeClassItemProvider vbC_Timer_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.VBC_Timer_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVBC_Timer_TypeClassAdapter() {
		if (vbC_Timer_TypeClassItemProvider == null) {
			vbC_Timer_TypeClassItemProvider = new VBC_Timer_TypeClassItemProvider(this);
		}

		return vbC_Timer_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Verbot_Anhalten_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Verbot_Anhalten_TypeClassItemProvider verbot_Anhalten_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Verbot_Anhalten_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVerbot_Anhalten_TypeClassAdapter() {
		if (verbot_Anhalten_TypeClassItemProvider == null) {
			verbot_Anhalten_TypeClassItemProvider = new Verbot_Anhalten_TypeClassItemProvider(this);
		}

		return verbot_Anhalten_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Verbot_Regenerative_Bremse_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Verbot_Regenerative_Bremse_TypeClassItemProvider verbot_Regenerative_Bremse_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Verbot_Regenerative_Bremse_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVerbot_Regenerative_Bremse_TypeClassAdapter() {
		if (verbot_Regenerative_Bremse_TypeClassItemProvider == null) {
			verbot_Regenerative_Bremse_TypeClassItemProvider = new Verbot_Regenerative_Bremse_TypeClassItemProvider(this);
		}

		return verbot_Regenerative_Bremse_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Verbot_WB_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Verbot_WB_Art_TypeClassItemProvider verbot_WB_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Verbot_WB_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVerbot_WB_Art_TypeClassAdapter() {
		if (verbot_WB_Art_TypeClassItemProvider == null) {
			verbot_WB_Art_TypeClassItemProvider = new Verbot_WB_Art_TypeClassItemProvider(this);
		}

		return verbot_WB_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Verkuerzter_Abstand_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Verkuerzter_Abstand_TypeClassItemProvider verkuerzter_Abstand_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Verkuerzter_Abstand_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVerkuerzter_Abstand_TypeClassAdapter() {
		if (verkuerzter_Abstand_TypeClassItemProvider == null) {
			verkuerzter_Abstand_TypeClassItemProvider = new Verkuerzter_Abstand_TypeClassItemProvider(this);
		}

		return verkuerzter_Abstand_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Verwendung_Als_Rueckfall_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Verwendung_Als_Rueckfall_TypeClassItemProvider verwendung_Als_Rueckfall_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Verwendung_Als_Rueckfall_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVerwendung_Als_Rueckfall_TypeClassAdapter() {
		if (verwendung_Als_Rueckfall_TypeClassItemProvider == null) {
			verwendung_Als_Rueckfall_TypeClassItemProvider = new Verwendung_Als_Rueckfall_TypeClassItemProvider(this);
		}

		return verwendung_Als_Rueckfall_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Verwendung_Hilfe_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Verwendung_Hilfe_TypeClassItemProvider verwendung_Hilfe_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Verwendung_Hilfe_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVerwendung_Hilfe_TypeClassAdapter() {
		if (verwendung_Hilfe_TypeClassItemProvider == null) {
			verwendung_Hilfe_TypeClassItemProvider = new Verwendung_Hilfe_TypeClassItemProvider(this);
		}

		return verwendung_Hilfe_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Verwendung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Verwendung_TypeClassItemProvider verwendung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Verwendung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVerwendung_TypeClassAdapter() {
		if (verwendung_TypeClassItemProvider == null) {
			verwendung_TypeClassItemProvider = new Verwendung_TypeClassItemProvider(this);
		}

		return verwendung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.VGR_1_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VGR_1_TypeClassItemProvider vgR_1_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.VGR_1_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVGR_1_TypeClassAdapter() {
		if (vgR_1_TypeClassItemProvider == null) {
			vgR_1_TypeClassItemProvider = new VGR_1_TypeClassItemProvider(this);
		}

		return vgR_1_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.VGR_2_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VGR_2_TypeClassItemProvider vgR_2_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.VGR_2_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVGR_2_TypeClassAdapter() {
		if (vgR_2_TypeClassItemProvider == null) {
			vgR_2_TypeClassItemProvider = new VGR_2_TypeClassItemProvider(this);
		}

		return vgR_2_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.VGR_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VGR_TypeClassItemProvider vgR_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.VGR_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVGR_TypeClassAdapter() {
		if (vgR_TypeClassItemProvider == null) {
			vgR_TypeClassItemProvider = new VGR_TypeClassItemProvider(this);
		}

		return vgR_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.VLA_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VLA_TypeClassItemProvider vlA_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.VLA_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVLA_TypeClassAdapter() {
		if (vlA_TypeClassItemProvider == null) {
			vlA_TypeClassItemProvider = new VLA_TypeClassItemProvider(this);
		}

		return vlA_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Vorsignalabstand_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Vorsignalabstand_TypeClassItemProvider vorsignalabstand_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Vorsignalabstand_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVorsignalabstand_TypeClassAdapter() {
		if (vorsignalabstand_TypeClassItemProvider == null) {
			vorsignalabstand_TypeClassItemProvider = new Vorsignalabstand_TypeClassItemProvider(this);
		}

		return vorsignalabstand_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.VZ_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VZ_TypeClassItemProvider vZ_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.VZ_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVZ_TypeClassAdapter() {
		if (vZ_TypeClassItemProvider == null) {
			vZ_TypeClassItemProvider = new VZ_TypeClassItemProvider(this);
		}

		return vZ_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.W_Anschluss_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected W_Anschluss_TypeClassItemProvider w_Anschluss_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.W_Anschluss_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createW_Anschluss_TypeClassAdapter() {
		if (w_Anschluss_TypeClassItemProvider == null) {
			w_Anschluss_TypeClassItemProvider = new W_Anschluss_TypeClassItemProvider(this);
		}

		return w_Anschluss_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.W_Lage_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected W_Lage_TypeClassItemProvider w_Lage_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.W_Lage_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createW_Lage_TypeClassAdapter() {
		if (w_Lage_TypeClassItemProvider == null) {
			w_Lage_TypeClassItemProvider = new W_Lage_TypeClassItemProvider(this);
		}

		return w_Lage_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Wirkrichtung_In_Datenpunkt_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Wirkrichtung_In_Datenpunkt_TypeClassItemProvider wirkrichtung_In_Datenpunkt_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Wirkrichtung_In_Datenpunkt_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createWirkrichtung_In_Datenpunkt_TypeClassAdapter() {
		if (wirkrichtung_In_Datenpunkt_TypeClassItemProvider == null) {
			wirkrichtung_In_Datenpunkt_TypeClassItemProvider = new Wirkrichtung_In_Datenpunkt_TypeClassItemProvider(this);
		}

		return wirkrichtung_In_Datenpunkt_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Wirksam_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Wirksam_TypeClassItemProvider wirksam_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Wirksam_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createWirksam_TypeClassAdapter() {
		if (wirksam_TypeClassItemProvider == null) {
			wirksam_TypeClassItemProvider = new Wirksam_TypeClassItemProvider(this);
		}

		return wirksam_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZBS_La_Bereich_Distanz_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZBS_La_Bereich_Distanz_TypeClassItemProvider zbS_La_Bereich_Distanz_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZBS_La_Bereich_Distanz_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZBS_La_Bereich_Distanz_TypeClassAdapter() {
		if (zbS_La_Bereich_Distanz_TypeClassItemProvider == null) {
			zbS_La_Bereich_Distanz_TypeClassItemProvider = new ZBS_La_Bereich_Distanz_TypeClassItemProvider(this);
		}

		return zbS_La_Bereich_Distanz_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZBS_La_Bereich_Geschwindigkeit_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZBS_La_Bereich_Geschwindigkeit_TypeClassItemProvider zbS_La_Bereich_Geschwindigkeit_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZBS_La_Bereich_Geschwindigkeit_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZBS_La_Bereich_Geschwindigkeit_TypeClassAdapter() {
		if (zbS_La_Bereich_Geschwindigkeit_TypeClassItemProvider == null) {
			zbS_La_Bereich_Geschwindigkeit_TypeClassItemProvider = new ZBS_La_Bereich_Geschwindigkeit_TypeClassItemProvider(this);
		}

		return zbS_La_Bereich_Geschwindigkeit_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZBS_La_Bereich_Laenge_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZBS_La_Bereich_Laenge_TypeClassItemProvider zbS_La_Bereich_Laenge_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZBS_La_Bereich_Laenge_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZBS_La_Bereich_Laenge_TypeClassAdapter() {
		if (zbS_La_Bereich_Laenge_TypeClassItemProvider == null) {
			zbS_La_Bereich_Laenge_TypeClassItemProvider = new ZBS_La_Bereich_Laenge_TypeClassItemProvider(this);
		}

		return zbS_La_Bereich_Laenge_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZBS_La_Bereich_Neigung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZBS_La_Bereich_Neigung_TypeClassItemProvider zbS_La_Bereich_Neigung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZBS_La_Bereich_Neigung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZBS_La_Bereich_Neigung_TypeClassAdapter() {
		if (zbS_La_Bereich_Neigung_TypeClassItemProvider == null) {
			zbS_La_Bereich_Neigung_TypeClassItemProvider = new ZBS_La_Bereich_Neigung_TypeClassItemProvider(this);
		}

		return zbS_La_Bereich_Neigung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZBS_Merkmale_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZBS_Merkmale_AttributeGroupItemProvider zbS_Merkmale_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZBS_Merkmale_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZBS_Merkmale_AttributeGroupAdapter() {
		if (zbS_Merkmale_AttributeGroupItemProvider == null) {
			zbS_Merkmale_AttributeGroupItemProvider = new ZBS_Merkmale_AttributeGroupItemProvider(this);
		}

		return zbS_Merkmale_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZBS_Reaktion_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZBS_Reaktion_TypeClassItemProvider zbS_Reaktion_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZBS_Reaktion_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZBS_Reaktion_TypeClassAdapter() {
		if (zbS_Reaktion_TypeClassItemProvider == null) {
			zbS_Reaktion_TypeClassItemProvider = new ZBS_Reaktion_TypeClassItemProvider(this);
		}

		return zbS_Reaktion_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZBS_Schutzstrecke} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZBS_SchutzstreckeItemProvider zbS_SchutzstreckeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZBS_Schutzstrecke}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZBS_SchutzstreckeAdapter() {
		if (zbS_SchutzstreckeItemProvider == null) {
			zbS_SchutzstreckeItemProvider = new ZBS_SchutzstreckeItemProvider(this);
		}

		return zbS_SchutzstreckeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZBS_Schutzstrecke_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZBS_Schutzstrecke_Allg_AttributeGroupItemProvider zbS_Schutzstrecke_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZBS_Schutzstrecke_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZBS_Schutzstrecke_Allg_AttributeGroupAdapter() {
		if (zbS_Schutzstrecke_Allg_AttributeGroupItemProvider == null) {
			zbS_Schutzstrecke_Allg_AttributeGroupItemProvider = new ZBS_Schutzstrecke_Allg_AttributeGroupItemProvider(this);
		}

		return zbS_Schutzstrecke_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZBS_Signal} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZBS_SignalItemProvider zbS_SignalItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZBS_Signal}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZBS_SignalAdapter() {
		if (zbS_SignalItemProvider == null) {
			zbS_SignalItemProvider = new ZBS_SignalItemProvider(this);
		}

		return zbS_SignalItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZBS_Signal_Signalabstand_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZBS_Signal_Signalabstand_AttributeGroupItemProvider zbS_Signal_Signalabstand_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZBS_Signal_Signalabstand_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZBS_Signal_Signalabstand_AttributeGroupAdapter() {
		if (zbS_Signal_Signalabstand_AttributeGroupItemProvider == null) {
			zbS_Signal_Signalabstand_AttributeGroupItemProvider = new ZBS_Signal_Signalabstand_AttributeGroupItemProvider(this);
		}

		return zbS_Signal_Signalabstand_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Ziel_DP_Ausrichtung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Ziel_DP_Ausrichtung_TypeClassItemProvider ziel_DP_Ausrichtung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Ziel_DP_Ausrichtung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZiel_DP_Ausrichtung_TypeClassAdapter() {
		if (ziel_DP_Ausrichtung_TypeClassItemProvider == null) {
			ziel_DP_Ausrichtung_TypeClassItemProvider = new Ziel_DP_Ausrichtung_TypeClassItemProvider(this);
		}

		return ziel_DP_Ausrichtung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Ziel_Ist_Fahrwegende_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Ziel_Ist_Fahrwegende_TypeClassItemProvider ziel_Ist_Fahrwegende_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Ziel_Ist_Fahrwegende_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZiel_Ist_Fahrwegende_TypeClassAdapter() {
		if (ziel_Ist_Fahrwegende_TypeClassItemProvider == null) {
			ziel_Ist_Fahrwegende_TypeClassItemProvider = new Ziel_Ist_Fahrwegende_TypeClassItemProvider(this);
		}

		return ziel_Ist_Fahrwegende_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Ziel_W_Element_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Ziel_W_Element_AttributeGroupItemProvider ziel_W_Element_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.Ziel_W_Element_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZiel_W_Element_AttributeGroupAdapter() {
		if (ziel_W_Element_AttributeGroupItemProvider == null) {
			ziel_W_Element_AttributeGroupItemProvider = new Ziel_W_Element_AttributeGroupItemProvider(this);
		}

		return ziel_W_Element_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZLA_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZLA_TypeClassItemProvider zlA_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZLA_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZLA_TypeClassAdapter() {
		if (zlA_TypeClassItemProvider == null) {
			zlA_TypeClassItemProvider = new ZLA_TypeClassItemProvider(this);
		}

		return zlA_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZUB_Bereichsgrenze} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZUB_BereichsgrenzeItemProvider zuB_BereichsgrenzeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZUB_Bereichsgrenze}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZUB_BereichsgrenzeAdapter() {
		if (zuB_BereichsgrenzeItemProvider == null) {
			zuB_BereichsgrenzeItemProvider = new ZUB_BereichsgrenzeItemProvider(this);
		}

		return zuB_BereichsgrenzeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZUB_Bereichsgrenze_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZUB_Bereichsgrenze_Allg_AttributeGroupItemProvider zuB_Bereichsgrenze_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZUB_Bereichsgrenze_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZUB_Bereichsgrenze_Allg_AttributeGroupAdapter() {
		if (zuB_Bereichsgrenze_Allg_AttributeGroupItemProvider == null) {
			zuB_Bereichsgrenze_Allg_AttributeGroupItemProvider = new ZUB_Bereichsgrenze_Allg_AttributeGroupItemProvider(this);
		}

		return zuB_Bereichsgrenze_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZUB_Bereichsgrenze_Bezeichnung_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZUB_Bereichsgrenze_Bezeichnung_AttributeGroupItemProvider zuB_Bereichsgrenze_Bezeichnung_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZUB_Bereichsgrenze_Bezeichnung_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZUB_Bereichsgrenze_Bezeichnung_AttributeGroupAdapter() {
		if (zuB_Bereichsgrenze_Bezeichnung_AttributeGroupItemProvider == null) {
			zuB_Bereichsgrenze_Bezeichnung_AttributeGroupItemProvider = new ZUB_Bereichsgrenze_Bezeichnung_AttributeGroupItemProvider(this);
		}

		return zuB_Bereichsgrenze_Bezeichnung_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZUB_Bereichsgrenze_Nach_ESG_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZUB_Bereichsgrenze_Nach_ESG_AttributeGroupItemProvider zuB_Bereichsgrenze_Nach_ESG_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZUB_Bereichsgrenze_Nach_ESG_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZUB_Bereichsgrenze_Nach_ESG_AttributeGroupAdapter() {
		if (zuB_Bereichsgrenze_Nach_ESG_AttributeGroupItemProvider == null) {
			zuB_Bereichsgrenze_Nach_ESG_AttributeGroupItemProvider = new ZUB_Bereichsgrenze_Nach_ESG_AttributeGroupItemProvider(this);
		}

		return zuB_Bereichsgrenze_Nach_ESG_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZUB_Bereichsgrenze_Nach_GNT_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZUB_Bereichsgrenze_Nach_GNT_TypeClassItemProvider zuB_Bereichsgrenze_Nach_GNT_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZUB_Bereichsgrenze_Nach_GNT_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZUB_Bereichsgrenze_Nach_GNT_TypeClassAdapter() {
		if (zuB_Bereichsgrenze_Nach_GNT_TypeClassItemProvider == null) {
			zuB_Bereichsgrenze_Nach_GNT_TypeClassItemProvider = new ZUB_Bereichsgrenze_Nach_GNT_TypeClassItemProvider(this);
		}

		return zuB_Bereichsgrenze_Nach_GNT_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZUB_Bereichsgrenze_Nach_L2_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZUB_Bereichsgrenze_Nach_L2_AttributeGroupItemProvider zuB_Bereichsgrenze_Nach_L2_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZUB_Bereichsgrenze_Nach_L2_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZUB_Bereichsgrenze_Nach_L2_AttributeGroupAdapter() {
		if (zuB_Bereichsgrenze_Nach_L2_AttributeGroupItemProvider == null) {
			zuB_Bereichsgrenze_Nach_L2_AttributeGroupItemProvider = new ZUB_Bereichsgrenze_Nach_L2_AttributeGroupItemProvider(this);
		}

		return zuB_Bereichsgrenze_Nach_L2_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZUB_Bereichsgrenze_Nach_L2_Von_ESG_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZUB_Bereichsgrenze_Nach_L2_Von_ESG_AttributeGroupItemProvider zuB_Bereichsgrenze_Nach_L2_Von_ESG_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZUB_Bereichsgrenze_Nach_L2_Von_ESG_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZUB_Bereichsgrenze_Nach_L2_Von_ESG_AttributeGroupAdapter() {
		if (zuB_Bereichsgrenze_Nach_L2_Von_ESG_AttributeGroupItemProvider == null) {
			zuB_Bereichsgrenze_Nach_L2_Von_ESG_AttributeGroupItemProvider = new ZUB_Bereichsgrenze_Nach_L2_Von_ESG_AttributeGroupItemProvider(this);
		}

		return zuB_Bereichsgrenze_Nach_L2_Von_ESG_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZUB_Bereichsgrenze_Nach_LZB_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZUB_Bereichsgrenze_Nach_LZB_AttributeGroupItemProvider zuB_Bereichsgrenze_Nach_LZB_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZUB_Bereichsgrenze_Nach_LZB_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZUB_Bereichsgrenze_Nach_LZB_AttributeGroupAdapter() {
		if (zuB_Bereichsgrenze_Nach_LZB_AttributeGroupItemProvider == null) {
			zuB_Bereichsgrenze_Nach_LZB_AttributeGroupItemProvider = new ZUB_Bereichsgrenze_Nach_LZB_AttributeGroupItemProvider(this);
		}

		return zuB_Bereichsgrenze_Nach_LZB_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZUB_Bereichsgrenze_Nach_Ohne_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZUB_Bereichsgrenze_Nach_Ohne_AttributeGroupItemProvider zuB_Bereichsgrenze_Nach_Ohne_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZUB_Bereichsgrenze_Nach_Ohne_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZUB_Bereichsgrenze_Nach_Ohne_AttributeGroupAdapter() {
		if (zuB_Bereichsgrenze_Nach_Ohne_AttributeGroupItemProvider == null) {
			zuB_Bereichsgrenze_Nach_Ohne_AttributeGroupItemProvider = new ZUB_Bereichsgrenze_Nach_Ohne_AttributeGroupItemProvider(this);
		}

		return zuB_Bereichsgrenze_Nach_Ohne_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZUB_Bereichsgrenze_Nach_PZB_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZUB_Bereichsgrenze_Nach_PZB_AttributeGroupItemProvider zuB_Bereichsgrenze_Nach_PZB_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZUB_Bereichsgrenze_Nach_PZB_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZUB_Bereichsgrenze_Nach_PZB_AttributeGroupAdapter() {
		if (zuB_Bereichsgrenze_Nach_PZB_AttributeGroupItemProvider == null) {
			zuB_Bereichsgrenze_Nach_PZB_AttributeGroupItemProvider = new ZUB_Bereichsgrenze_Nach_PZB_AttributeGroupItemProvider(this);
		}

		return zuB_Bereichsgrenze_Nach_PZB_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZUB_Bereichsgrenze_Nach_Sonstige_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZUB_Bereichsgrenze_Nach_Sonstige_AttributeGroupItemProvider zuB_Bereichsgrenze_Nach_Sonstige_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZUB_Bereichsgrenze_Nach_Sonstige_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZUB_Bereichsgrenze_Nach_Sonstige_AttributeGroupAdapter() {
		if (zuB_Bereichsgrenze_Nach_Sonstige_AttributeGroupItemProvider == null) {
			zuB_Bereichsgrenze_Nach_Sonstige_AttributeGroupItemProvider = new ZUB_Bereichsgrenze_Nach_Sonstige_AttributeGroupItemProvider(this);
		}

		return zuB_Bereichsgrenze_Nach_Sonstige_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZUB_Bereichsgrenze_Nach_ZBS_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZUB_Bereichsgrenze_Nach_ZBS_AttributeGroupItemProvider zuB_Bereichsgrenze_Nach_ZBS_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZUB_Bereichsgrenze_Nach_ZBS_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZUB_Bereichsgrenze_Nach_ZBS_AttributeGroupAdapter() {
		if (zuB_Bereichsgrenze_Nach_ZBS_AttributeGroupItemProvider == null) {
			zuB_Bereichsgrenze_Nach_ZBS_AttributeGroupItemProvider = new ZUB_Bereichsgrenze_Nach_ZBS_AttributeGroupItemProvider(this);
		}

		return zuB_Bereichsgrenze_Nach_ZBS_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZUB_Bgrenze_RBC_Wechsel_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZUB_Bgrenze_RBC_Wechsel_AttributeGroupItemProvider zuB_Bgrenze_RBC_Wechsel_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZUB_Bgrenze_RBC_Wechsel_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZUB_Bgrenze_RBC_Wechsel_AttributeGroupAdapter() {
		if (zuB_Bgrenze_RBC_Wechsel_AttributeGroupItemProvider == null) {
			zuB_Bgrenze_RBC_Wechsel_AttributeGroupItemProvider = new ZUB_Bgrenze_RBC_Wechsel_AttributeGroupItemProvider(this);
		}

		return zuB_Bgrenze_RBC_Wechsel_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZUB_SE_Ausruestung_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZUB_SE_Ausruestung_AttributeGroupItemProvider zuB_SE_Ausruestung_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZUB_SE_Ausruestung_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZUB_SE_Ausruestung_AttributeGroupAdapter() {
		if (zuB_SE_Ausruestung_AttributeGroupItemProvider == null) {
			zuB_SE_Ausruestung_AttributeGroupItemProvider = new ZUB_SE_Ausruestung_AttributeGroupItemProvider(this);
		}

		return zuB_SE_Ausruestung_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZUB_Streckeneigenschaft} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZUB_StreckeneigenschaftItemProvider zuB_StreckeneigenschaftItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZUB_Streckeneigenschaft}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZUB_StreckeneigenschaftAdapter() {
		if (zuB_StreckeneigenschaftItemProvider == null) {
			zuB_StreckeneigenschaftItemProvider = new ZUB_StreckeneigenschaftItemProvider(this);
		}

		return zuB_StreckeneigenschaftItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZUB_Streckeneigenschaft_Bezeichnung_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZUB_Streckeneigenschaft_Bezeichnung_AttributeGroupItemProvider zuB_Streckeneigenschaft_Bezeichnung_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Balisentechnik_ETCS.ZUB_Streckeneigenschaft_Bezeichnung_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZUB_Streckeneigenschaft_Bezeichnung_AttributeGroupAdapter() {
		if (zuB_Streckeneigenschaft_Bezeichnung_AttributeGroupItemProvider == null) {
			zuB_Streckeneigenschaft_Bezeichnung_AttributeGroupItemProvider = new ZUB_Streckeneigenschaft_Bezeichnung_AttributeGroupItemProvider(this);
		}

		return zuB_Streckeneigenschaft_Bezeichnung_AttributeGroupItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose() {
		if (abstand_Bes_Langer_Einfahrweg_TypeClassItemProvider != null) abstand_Bes_Langer_Einfahrweg_TypeClassItemProvider.dispose();
		if (abstand_Datenpunkt_EH_EM_Folgesignal_TypeClassItemProvider != null) abstand_Datenpunkt_EH_EM_Folgesignal_TypeClassItemProvider.dispose();
		if (abstand_Datenpunkt_EP_TPI_TypeClassItemProvider != null) abstand_Datenpunkt_EP_TPI_TypeClassItemProvider.dispose();
		if (abstand_Datenpunkt_TPI_Folgesignal_TypeClassItemProvider != null) abstand_Datenpunkt_TPI_Folgesignal_TypeClassItemProvider.dispose();
		if (abstand_Einmesspunkt_TypeClassItemProvider != null) abstand_Einmesspunkt_TypeClassItemProvider.dispose();
		if (abstand_Grenze_Bereich_C_TypeClassItemProvider != null) abstand_Grenze_Bereich_C_TypeClassItemProvider.dispose();
		if (abstand_Reduziert_TypeClassItemProvider != null) abstand_Reduziert_TypeClassItemProvider.dispose();
		if (anlagenteil_Sonstige_TypeClassItemProvider != null) anlagenteil_Sonstige_TypeClassItemProvider.dispose();
		if (anordnung_Im_DP_TypeClassItemProvider != null) anordnung_Im_DP_TypeClassItemProvider.dispose();
		if (anwendung_ESG_TypeClassItemProvider != null) anwendung_ESG_TypeClassItemProvider.dispose();
		if (anwendung_GNT_TypeClassItemProvider != null) anwendung_GNT_TypeClassItemProvider.dispose();
		if (anwendung_Sonst_TypeClassItemProvider != null) anwendung_Sonst_TypeClassItemProvider.dispose();
		if (anwendungssystem_TypeClassItemProvider != null) anwendungssystem_TypeClassItemProvider.dispose();
		if (anzahl_Voll_LEU_Kalkuliert_TypeClassItemProvider != null) anzahl_Voll_LEU_Kalkuliert_TypeClassItemProvider.dispose();
		if (anzeigetext_TypeClassItemProvider != null) anzeigetext_TypeClassItemProvider.dispose();
		if (art_Bedingung_TypeClassItemProvider != null) art_Bedingung_TypeClassItemProvider.dispose();
		if (ausgang_Nr_TypeClassItemProvider != null) ausgang_Nr_TypeClassItemProvider.dispose();
		if (ausrichtung_TypeClassItemProvider != null) ausrichtung_TypeClassItemProvider.dispose();
		if (ausstieg_ETCS_Sperre_TypeClassItemProvider != null) ausstieg_ETCS_Sperre_TypeClassItemProvider.dispose();
		if (baliseItemProvider != null) baliseItemProvider.dispose();
		if (balise_Allg_AttributeGroupItemProvider != null) balise_Allg_AttributeGroupItemProvider.dispose();
		if (balise_Geraetestand_TypeClassItemProvider != null) balise_Geraetestand_TypeClassItemProvider.dispose();
		if (balisenhalter_TypeClassItemProvider != null) balisenhalter_TypeClassItemProvider.dispose();
		if (baseline_System_Version_TypeClassItemProvider != null) baseline_System_Version_TypeClassItemProvider.dispose();
		if (bedingung_Besondere_AttributeGroupItemProvider != null) bedingung_Besondere_AttributeGroupItemProvider.dispose();
		if (bedingung_PZB_AttributeGroupItemProvider != null) bedingung_PZB_AttributeGroupItemProvider.dispose();
		if (bedingung_Signal_AttributeGroupItemProvider != null) bedingung_Signal_AttributeGroupItemProvider.dispose();
		if (bedingung_Sonstige_AttributeGroupItemProvider != null) bedingung_Sonstige_AttributeGroupItemProvider.dispose();
		if (bedingung_Weiche_AttributeGroupItemProvider != null) bedingung_Weiche_AttributeGroupItemProvider.dispose();
		if (bedingung_Weichenlage_TypeClassItemProvider != null) bedingung_Weichenlage_TypeClassItemProvider.dispose();
		if (bez_Strecke_BTS_1_TypeClassItemProvider != null) bez_Strecke_BTS_1_TypeClassItemProvider.dispose();
		if (bez_Strecke_BTS_2_TypeClassItemProvider != null) bez_Strecke_BTS_2_TypeClassItemProvider.dispose();
		if (bez_Strecke_BTS_3_TypeClassItemProvider != null) bez_Strecke_BTS_3_TypeClassItemProvider.dispose();
		if (bez_ZUB_Bereichsgrenze_TypeClassItemProvider != null) bez_ZUB_Bereichsgrenze_TypeClassItemProvider.dispose();
		if (bezeichnung_ETCS_Kante_TypeClassItemProvider != null) bezeichnung_ETCS_Kante_TypeClassItemProvider.dispose();
		if (bezeichnung_LEU_Anlage_TypeClassItemProvider != null) bezeichnung_LEU_Anlage_TypeClassItemProvider.dispose();
		if (bezeichnung_ZUB_SE_TypeClassItemProvider != null) bezeichnung_ZUB_SE_TypeClassItemProvider.dispose();
		if (bezeichnung_ZUB_TypeClassItemProvider != null) bezeichnung_ZUB_TypeClassItemProvider.dispose();
		if (bgrenze_Nach_ESG_Bed_Ausstieg_AttributeGroupItemProvider != null) bgrenze_Nach_ESG_Bed_Ausstieg_AttributeGroupItemProvider.dispose();
		if (bgrenze_Nach_L2_Bed_Einstieg_AttributeGroupItemProvider != null) bgrenze_Nach_L2_Bed_Einstieg_AttributeGroupItemProvider.dispose();
		if (bgrenze_Nach_LZB_Bed_Einstieg_AttributeGroupItemProvider != null) bgrenze_Nach_LZB_Bed_Einstieg_AttributeGroupItemProvider.dispose();
		if (bgrenze_Nach_Ohne_Bed_Einstieg_AttributeGroupItemProvider != null) bgrenze_Nach_Ohne_Bed_Einstieg_AttributeGroupItemProvider.dispose();
		if (bgrenze_Nach_PZB_Bed_Einstieg_AttributeGroupItemProvider != null) bgrenze_Nach_PZB_Bed_Einstieg_AttributeGroupItemProvider.dispose();
		if (bgrenze_Nach_ZBS_Bed_Einstieg_AttributeGroupItemProvider != null) bgrenze_Nach_ZBS_Bed_Einstieg_AttributeGroupItemProvider.dispose();
		if (bgrenze_RBC_Wechsel_BTS_Kette_AttributeGroupItemProvider != null) bgrenze_RBC_Wechsel_BTS_Kette_AttributeGroupItemProvider.dispose();
		if (binaerdatenItemProvider != null) binaerdatenItemProvider.dispose();
		if (binaerdaten_Datei_AttributeGroupItemProvider != null) binaerdaten_Datei_AttributeGroupItemProvider.dispose();
		if (d_LEVELTR_TypeClassItemProvider != null) d_LEVELTR_TypeClassItemProvider.dispose();
		if (dateiname_TypeClassItemProvider != null) dateiname_TypeClassItemProvider.dispose();
		if (dateityp_Binaerdatei_TypeClassItemProvider != null) dateityp_Binaerdatei_TypeClassItemProvider.dispose();
		if (daten_TypeClassItemProvider != null) daten_TypeClassItemProvider.dispose();
		if (datenpunktItemProvider != null) datenpunktItemProvider.dispose();
		if (datenpunkt_Allg_AttributeGroupItemProvider != null) datenpunkt_Allg_AttributeGroupItemProvider.dispose();
		if (datenpunkt_Beschreibung_TypeClassItemProvider != null) datenpunkt_Beschreibung_TypeClassItemProvider.dispose();
		if (datenpunkt_Einmesspunkt_AttributeGroupItemProvider != null) datenpunkt_Einmesspunkt_AttributeGroupItemProvider.dispose();
		if (datenpunkt_Laenge_TypeClassItemProvider != null) datenpunkt_Laenge_TypeClassItemProvider.dispose();
		if (datenpunkt_LinkItemProvider != null) datenpunkt_LinkItemProvider.dispose();
		if (delta_VGES_TypeClassItemProvider != null) delta_VGES_TypeClassItemProvider.dispose();
		if (delta_VLES_TypeClassItemProvider != null) delta_VLES_TypeClassItemProvider.dispose();
		if (delta_VZES_TypeClassItemProvider != null) delta_VZES_TypeClassItemProvider.dispose();
		if (dP_ATO_TypeClassItemProvider != null) dP_ATO_TypeClassItemProvider.dispose();
		if (dP_Bezug_Funktional_Art_TypeClassItemProvider != null) dP_Bezug_Funktional_Art_TypeClassItemProvider.dispose();
		if (dP_Bezug_Funktional_AttributeGroupItemProvider != null) dP_Bezug_Funktional_AttributeGroupItemProvider.dispose();
		if (dP_ETCS_Adresse_AttributeGroupItemProvider != null) dP_ETCS_Adresse_AttributeGroupItemProvider.dispose();
		if (dP_Link_Art_TypeClassItemProvider != null) dP_Link_Art_TypeClassItemProvider.dispose();
		if (dP_Telegramm_AttributeGroupItemProvider != null) dP_Telegramm_AttributeGroupItemProvider.dispose();
		if (dP_Telegramm_ESG_AttributeGroupItemProvider != null) dP_Telegramm_ESG_AttributeGroupItemProvider.dispose();
		if (dP_Typ_Art_TypeClassItemProvider != null) dP_Typ_Art_TypeClassItemProvider.dispose();
		if (dP_Typ_AttributeGroupItemProvider != null) dP_Typ_AttributeGroupItemProvider.dispose();
		if (dP_Typ_ESG_TypeClassItemProvider != null) dP_Typ_ESG_TypeClassItemProvider.dispose();
		if (dP_Typ_ETCS_TypeClassItemProvider != null) dP_Typ_ETCS_TypeClassItemProvider.dispose();
		if (dP_Typ_GESG_AttributeGroupItemProvider != null) dP_Typ_GESG_AttributeGroupItemProvider.dispose();
		if (dP_Typ_GETCS_AttributeGroupItemProvider != null) dP_Typ_GETCS_AttributeGroupItemProvider.dispose();
		if (dP_Typ_GGNT_AttributeGroupItemProvider != null) dP_Typ_GGNT_AttributeGroupItemProvider.dispose();
		if (dP_Typ_GNT_TypeClassItemProvider != null) dP_Typ_GNT_TypeClassItemProvider.dispose();
		if (dP_Typ_GSonst_AttributeGroupItemProvider != null) dP_Typ_GSonst_AttributeGroupItemProvider.dispose();
		if (dP_Typ_GTrans_AttributeGroupItemProvider != null) dP_Typ_GTrans_AttributeGroupItemProvider.dispose();
		if (dP_Typ_GZBS_AttributeGroupItemProvider != null) dP_Typ_GZBS_AttributeGroupItemProvider.dispose();
		if (dP_Typ_Sonst_TypeClassItemProvider != null) dP_Typ_Sonst_TypeClassItemProvider.dispose();
		if (dP_Typ_Trans_TypeClassItemProvider != null) dP_Typ_Trans_TypeClassItemProvider.dispose();
		if (dP_Typ_V_La_TypeClassItemProvider != null) dP_Typ_V_La_TypeClassItemProvider.dispose();
		if (dP_Typ_ZBS_TypeClassItemProvider != null) dP_Typ_ZBS_TypeClassItemProvider.dispose();
		if (dP_Verlinkt_TypeClassItemProvider != null) dP_Verlinkt_TypeClassItemProvider.dispose();
		if (dunkelschaltanstoss_TypeClassItemProvider != null) dunkelschaltanstoss_TypeClassItemProvider.dispose();
		if (dWeg_Intervall_200_TypeClassItemProvider != null) dWeg_Intervall_200_TypeClassItemProvider.dispose();
		if (dWeg_Intervall_50_200_TypeClassItemProvider != null) dWeg_Intervall_50_200_TypeClassItemProvider.dispose();
		if (dWeg_Intervall_50_TypeClassItemProvider != null) dWeg_Intervall_50_TypeClassItemProvider.dispose();
		if (eingang_Gepuffert_TypeClassItemProvider != null) eingang_Gepuffert_TypeClassItemProvider.dispose();
		if (einstieg_Erlaubt_TypeClassItemProvider != null) einstieg_Erlaubt_TypeClassItemProvider.dispose();
		if (einstieg_Ohne_Rueckw_Sig_TypeClassItemProvider != null) einstieg_Ohne_Rueckw_Sig_TypeClassItemProvider.dispose();
		if (einzeldatei_Art_TypeClassItemProvider != null) einzeldatei_Art_TypeClassItemProvider.dispose();
		if (energie_Eingang_Art_TypeClassItemProvider != null) energie_Eingang_Art_TypeClassItemProvider.dispose();
		if (esG_Ind_Erlaeuterung_TypeClassItemProvider != null) esG_Ind_Erlaeuterung_TypeClassItemProvider.dispose();
		if (esG_Ind_Parameter_TypeClassItemProvider != null) esG_Ind_Parameter_TypeClassItemProvider.dispose();
		if (esG_Ind_Parameterwert_TypeClassItemProvider != null) esG_Ind_Parameterwert_TypeClassItemProvider.dispose();
		if (esG_Individuelle_Merkmale_AttributeGroupItemProvider != null) esG_Individuelle_Merkmale_AttributeGroupItemProvider.dispose();
		if (esG_Spezifische_Merkmale_AttributeGroupItemProvider != null) esG_Spezifische_Merkmale_AttributeGroupItemProvider.dispose();
		if (etcS_Adresse_AttributeGroupItemProvider != null) etcS_Adresse_AttributeGroupItemProvider.dispose();
		if (etcS_Gefahrpunktabstand_Abweichend_TypeClassItemProvider != null) etcS_Gefahrpunktabstand_Abweichend_TypeClassItemProvider.dispose();
		if (etcS_KanteItemProvider != null) etcS_KanteItemProvider.dispose();
		if (etcS_Kante_Bezeichnung_AttributeGroupItemProvider != null) etcS_Kante_Bezeichnung_AttributeGroupItemProvider.dispose();
		if (etcS_KnotenItemProvider != null) etcS_KnotenItemProvider.dispose();
		if (etcS_Knoten_Art_Sonstige_TypeClassItemProvider != null) etcS_Knoten_Art_Sonstige_TypeClassItemProvider.dispose();
		if (etcS_Paketnummer_TypeClassItemProvider != null) etcS_Paketnummer_TypeClassItemProvider.dispose();
		if (etcS_Par_Erlaeuterung_TypeClassItemProvider != null) etcS_Par_Erlaeuterung_TypeClassItemProvider.dispose();
		if (etcS_Parametername_TypeClassItemProvider != null) etcS_Parametername_TypeClassItemProvider.dispose();
		if (etcS_Parameterwert_TypeClassItemProvider != null) etcS_Parameterwert_TypeClassItemProvider.dispose();
		if (etcS_RichtungsanzeigeItemProvider != null) etcS_RichtungsanzeigeItemProvider.dispose();
		if (etcS_SignalItemProvider != null) etcS_SignalItemProvider.dispose();
		if (etcS_Signal_Allg_AttributeGroupItemProvider != null) etcS_Signal_Allg_AttributeGroupItemProvider.dispose();
		if (etcS_Signal_DWeg_AttributeGroupItemProvider != null) etcS_Signal_DWeg_AttributeGroupItemProvider.dispose();
		if (etcS_Signal_TBV_AttributeGroupItemProvider != null) etcS_Signal_TBV_AttributeGroupItemProvider.dispose();
		if (etcS_System_Version_TypeClassItemProvider != null) etcS_System_Version_TypeClassItemProvider.dispose();
		if (etcS_W_KrItemProvider != null) etcS_W_KrItemProvider.dispose();
		if (etcS_W_Kr_MUKA_AttributeGroupItemProvider != null) etcS_W_Kr_MUKA_AttributeGroupItemProvider.dispose();
		if (eV_ModulItemProvider != null) eV_ModulItemProvider.dispose();
		if (eV_Modul_Art_TypeClassItemProvider != null) eV_Modul_Art_TypeClassItemProvider.dispose();
		if (eV_Modul_Ausgang_AttributeGroupItemProvider != null) eV_Modul_Ausgang_AttributeGroupItemProvider.dispose();
		if (eV_Modul_Eingang_AttributeGroupItemProvider != null) eV_Modul_Eingang_AttributeGroupItemProvider.dispose();
		if (eV_Modul_Physisch_AttributeGroupItemProvider != null) eV_Modul_Physisch_AttributeGroupItemProvider.dispose();
		if (eV_Modul_Typ_TypeClassItemProvider != null) eV_Modul_Typ_TypeClassItemProvider.dispose();
		if (eV_Modul_Virtuell_AttributeGroupItemProvider != null) eV_Modul_Virtuell_AttributeGroupItemProvider.dispose();
		if (fabrikat_TypeClassItemProvider != null) fabrikat_TypeClassItemProvider.dispose();
		if (fachtelegrammItemProvider != null) fachtelegrammItemProvider.dispose();
		if (fT_AnschaltbedingungItemProvider != null) fT_AnschaltbedingungItemProvider.dispose();
		if (fT_ESG_Merkmale_AttributeGroupItemProvider != null) fT_ESG_Merkmale_AttributeGroupItemProvider.dispose();
		if (fT_ESG_Subtyp_TypeClassItemProvider != null) fT_ESG_Subtyp_TypeClassItemProvider.dispose();
		if (fT_ESG_Typ_TypeClassItemProvider != null) fT_ESG_Typ_TypeClassItemProvider.dispose();
		if (fT_ETCS_L2_Merkmale_AttributeGroupItemProvider != null) fT_ETCS_L2_Merkmale_AttributeGroupItemProvider.dispose();
		if (fT_ETCS_L2_Typ_TypeClassItemProvider != null) fT_ETCS_L2_Typ_TypeClassItemProvider.dispose();
		if (fT_ETCS_Trans_Merkmale_AttributeGroupItemProvider != null) fT_ETCS_Trans_Merkmale_AttributeGroupItemProvider.dispose();
		if (fT_ETCS_Trans_Paket_41_AttributeGroupItemProvider != null) fT_ETCS_Trans_Paket_41_AttributeGroupItemProvider.dispose();
		if (fT_ETCS_Trans_Paket_N_AttributeGroupItemProvider != null) fT_ETCS_Trans_Paket_N_AttributeGroupItemProvider.dispose();
		if (fT_Fahrweg_TeilItemProvider != null) fT_Fahrweg_TeilItemProvider.dispose();
		if (fT_Fahrweg_Teil_Allg_AttributeGroupItemProvider != null) fT_Fahrweg_Teil_Allg_AttributeGroupItemProvider.dispose();
		if (fT_Fahrweg_Teile_AttributeGroupItemProvider != null) fT_Fahrweg_Teile_AttributeGroupItemProvider.dispose();
		if (fT_GNT_Merkmale_AttributeGroupItemProvider != null) fT_GNT_Merkmale_AttributeGroupItemProvider.dispose();
		if (fT_GNT_Punktart_TypeClassItemProvider != null) fT_GNT_Punktart_TypeClassItemProvider.dispose();
		if (fT_Hinweis_Funktion_TypeClassItemProvider != null) fT_Hinweis_Funktion_TypeClassItemProvider.dispose();
		if (fT_ZBS_Merkmale_AttributeGroupItemProvider != null) fT_ZBS_Merkmale_AttributeGroupItemProvider.dispose();
		if (fT_ZBS_Merkmale_La_AttributeGroupItemProvider != null) fT_ZBS_Merkmale_La_AttributeGroupItemProvider.dispose();
		if (fT_ZBS_Typ_TypeClassItemProvider != null) fT_ZBS_Typ_TypeClassItemProvider.dispose();
		if (fW_Teil_Nummer_TypeClassItemProvider != null) fW_Teil_Nummer_TypeClassItemProvider.dispose();
		if (gruppen_ID_TypeClassItemProvider != null) gruppen_ID_TypeClassItemProvider.dispose();
		if (harter_Ausstieg_Aus_L2_TypeClassItemProvider != null) harter_Ausstieg_Aus_L2_TypeClassItemProvider.dispose();
		if (hersteller_TypeClassItemProvider != null) hersteller_TypeClassItemProvider.dispose();
		if (hinweis_Balisenbefestigung_TypeClassItemProvider != null) hinweis_Balisenbefestigung_TypeClassItemProvider.dispose();
		if (individualisierung_Weitere_TypeClassItemProvider != null) individualisierung_Weitere_TypeClassItemProvider.dispose();
		if (ist_Befahren_TypeClassItemProvider != null) ist_Befahren_TypeClassItemProvider.dispose();
		if (km_BTS_1_TypeClassItemProvider != null) km_BTS_1_TypeClassItemProvider.dispose();
		if (km_BTS_2_TypeClassItemProvider != null) km_BTS_2_TypeClassItemProvider.dispose();
		if (km_BTS_3_TypeClassItemProvider != null) km_BTS_3_TypeClassItemProvider.dispose();
		if (knoten_Auf_TOP_Kante_AttributeGroupItemProvider != null) knoten_Auf_TOP_Kante_AttributeGroupItemProvider.dispose();
		if (konfigurationskennung_TypeClassItemProvider != null) konfigurationskennung_TypeClassItemProvider.dispose();
		if (l_ACKLEVELTR_TypeClassItemProvider != null) l_ACKLEVELTR_TypeClassItemProvider.dispose();
		if (laenge_1_TypeClassItemProvider != null) laenge_1_TypeClassItemProvider.dispose();
		if (laenge_Ausfuehrungsbereich_TypeClassItemProvider != null) laenge_Ausfuehrungsbereich_TypeClassItemProvider.dispose();
		if (laenge_Gestufte_V_Signalisierung_TypeClassItemProvider != null) laenge_Gestufte_V_Signalisierung_TypeClassItemProvider.dispose();
		if (laenge_Soll_Mind_150_TypeClassItemProvider != null) laenge_Soll_Mind_150_TypeClassItemProvider.dispose();
		if (leistungsbedarf_TypeClassItemProvider != null) leistungsbedarf_TypeClassItemProvider.dispose();
		if (leU_AnlageItemProvider != null) leU_AnlageItemProvider.dispose();
		if (leU_Anlage_Allg_AttributeGroupItemProvider != null) leU_Anlage_Allg_AttributeGroupItemProvider.dispose();
		if (leU_Anlage_Art_TypeClassItemProvider != null) leU_Anlage_Art_TypeClassItemProvider.dispose();
		if (leU_Anlage_Bezeichnung_AttributeGroupItemProvider != null) leU_Anlage_Bezeichnung_AttributeGroupItemProvider.dispose();
		if (leU_Ausgang_Nr_TypeClassItemProvider != null) leU_Ausgang_Nr_TypeClassItemProvider.dispose();
		if (leU_ModulItemProvider != null) leU_ModulItemProvider.dispose();
		if (leU_Modul_Allg_AttributeGroupItemProvider != null) leU_Modul_Allg_AttributeGroupItemProvider.dispose();
		if (leU_Modul_Art_TypeClassItemProvider != null) leU_Modul_Art_TypeClassItemProvider.dispose();
		if (leU_Modul_Ausgang_AttributeGroupItemProvider != null) leU_Modul_Ausgang_AttributeGroupItemProvider.dispose();
		if (leU_Modul_Bezeichnung_AttributeGroupItemProvider != null) leU_Modul_Bezeichnung_AttributeGroupItemProvider.dispose();
		if (leU_Modul_Geraetestand_TypeClassItemProvider != null) leU_Modul_Geraetestand_TypeClassItemProvider.dispose();
		if (leU_Modul_Typ_TypeClassItemProvider != null) leU_Modul_Typ_TypeClassItemProvider.dispose();
		if (leU_SchaltkastenItemProvider != null) leU_SchaltkastenItemProvider.dispose();
		if (leU_Schaltkasten_Bezeichnung_AttributeGroupItemProvider != null) leU_Schaltkasten_Bezeichnung_AttributeGroupItemProvider.dispose();
		if (leU_Schaltkasten_Energie_AttributeGroupItemProvider != null) leU_Schaltkasten_Energie_AttributeGroupItemProvider.dispose();
		if (leU_Schaltkasten_Position_AttributeGroupItemProvider != null) leU_Schaltkasten_Position_AttributeGroupItemProvider.dispose();
		if (leU_Schaltkasten_Typ_TypeClassItemProvider != null) leU_Schaltkasten_Typ_TypeClassItemProvider.dispose();
		if (leU_Steuernde_AttributeGroupItemProvider != null) leU_Steuernde_AttributeGroupItemProvider.dispose();
		if (lfd_Nr_Am_Bezugspunkt_TypeClassItemProvider != null) lfd_Nr_Am_Bezugspunkt_TypeClassItemProvider.dispose();
		if (link_Distanz_TypeClassItemProvider != null) link_Distanz_TypeClassItemProvider.dispose();
		if (llA_TypeClassItemProvider != null) llA_TypeClassItemProvider.dispose();
		if (lM_G_TypeClassItemProvider != null) lM_G_TypeClassItemProvider.dispose();
		if (lT_Binaerdatei_Hilfe_AttributeGroupItemProvider != null) lT_Binaerdatei_Hilfe_AttributeGroupItemProvider.dispose();
		if (lT_Binaerdaten_AttributeGroupItemProvider != null) lT_Binaerdaten_AttributeGroupItemProvider.dispose();
		if (luft_TelegrammItemProvider != null) luft_TelegrammItemProvider.dispose();
		if (m_LEVELTR_TypeClassItemProvider != null) m_LEVELTR_TypeClassItemProvider.dispose();
		if (massgebende_Neig_1_TypeClassItemProvider != null) massgebende_Neig_1_TypeClassItemProvider.dispose();
		if (massgebende_Neig_Schutzstrecke_TypeClassItemProvider != null) massgebende_Neig_Schutzstrecke_TypeClassItemProvider.dispose();
		if (massgebende_Neigung_Mind_150_TypeClassItemProvider != null) massgebende_Neigung_Mind_150_TypeClassItemProvider.dispose();
		if (massgebende_Neigung_Mind_Sig_150_TypeClassItemProvider != null) massgebende_Neigung_Mind_Sig_150_TypeClassItemProvider.dispose();
		if (massgebende_Neigung_Mind_Sig_TypeClassItemProvider != null) massgebende_Neigung_Mind_Sig_TypeClassItemProvider.dispose();
		if (mastschild_TypeClassItemProvider != null) mastschild_TypeClassItemProvider.dispose();
		if (max_Leistung_TypeClassItemProvider != null) max_Leistung_TypeClassItemProvider.dispose();
		if (max_Unterbrechungszeit_TypeClassItemProvider != null) max_Unterbrechungszeit_TypeClassItemProvider.dispose();
		if (metallteil_AttributeGroupItemProvider != null) metallteil_AttributeGroupItemProvider.dispose();
		if (metallteil_Kategorie_TypeClassItemProvider != null) metallteil_Kategorie_TypeClassItemProvider.dispose();
		if (metallteil_Laenge_TypeClassItemProvider != null) metallteil_Laenge_TypeClassItemProvider.dispose();
		if (modulnummer_TypeClassItemProvider != null) modulnummer_TypeClassItemProvider.dispose();
		if (montageabweichung_TypeClassItemProvider != null) montageabweichung_TypeClassItemProvider.dispose();
		if (neigung_TypeClassItemProvider != null) neigung_TypeClassItemProvider.dispose();
		if (nennleistung_TypeClassItemProvider != null) nennleistung_TypeClassItemProvider.dispose();
		if (niD_BG_TypeClassItemProvider != null) niD_BG_TypeClassItemProvider.dispose();
		if (niD_C_TypeClassItemProvider != null) niD_C_TypeClassItemProvider.dispose();
		if (niD_RBC_TypeClassItemProvider != null) niD_RBC_TypeClassItemProvider.dispose();
		if (niD_STM_TypeClassItemProvider != null) niD_STM_TypeClassItemProvider.dispose();
		if (niD_TSR_TypeClassItemProvider != null) niD_TSR_TypeClassItemProvider.dispose();
		if (nummer_Schaltkasten_TypeClassItemProvider != null) nummer_Schaltkasten_TypeClassItemProvider.dispose();
		if (oberstrombegrenzung_Gueterzug_TypeClassItemProvider != null) oberstrombegrenzung_Gueterzug_TypeClassItemProvider.dispose();
		if (oberstrombegrenzung_Reisezug_TypeClassItemProvider != null) oberstrombegrenzung_Reisezug_TypeClassItemProvider.dispose();
		if (port_Nr_Ausg_Physisch_TypeClassItemProvider != null) port_Nr_Ausg_Physisch_TypeClassItemProvider.dispose();
		if (position_Sonstige_TypeClassItemProvider != null) position_Sonstige_TypeClassItemProvider.dispose();
		if (position_TypeClassItemProvider != null) position_TypeClassItemProvider.dispose();
		if (primaerquelle_TypeClassItemProvider != null) primaerquelle_TypeClassItemProvider.dispose();
		if (prioritaet_TypeClassItemProvider != null) prioritaet_TypeClassItemProvider.dispose();
		if (prog_Datei_Einzel_AttributeGroupItemProvider != null) prog_Datei_Einzel_AttributeGroupItemProvider.dispose();
		if (prog_Datei_GruppeItemProvider != null) prog_Datei_GruppeItemProvider.dispose();
		if (projektierungsfall_TypeClassItemProvider != null) projektierungsfall_TypeClassItemProvider.dispose();
		if (rbcItemProvider != null) rbcItemProvider.dispose();
		if (rbC_Allg_AttributeGroupItemProvider != null) rbC_Allg_AttributeGroupItemProvider.dispose();
		if (rbC_ETCS_System_Version_TypeClassItemProvider != null) rbC_ETCS_System_Version_TypeClassItemProvider.dispose();
		if (rbC_SRS_Version_TypeClassItemProvider != null) rbC_SRS_Version_TypeClassItemProvider.dispose();
		if (rekursion_2_Nr_TypeClassItemProvider != null) rekursion_2_Nr_TypeClassItemProvider.dispose();
		if (rekursion_Nr_TypeClassItemProvider != null) rekursion_Nr_TypeClassItemProvider.dispose();
		if (rufnummer_TypeClassItemProvider != null) rufnummer_TypeClassItemProvider.dispose();
		if (sbE_TypeClassItemProvider != null) sbE_TypeClassItemProvider.dispose();
		if (schutzstrecke_Erforderlich_TypeClassItemProvider != null) schutzstrecke_Erforderlich_TypeClassItemProvider.dispose();
		if (schutzstrecke_Vorhanden_TypeClassItemProvider != null) schutzstrecke_Vorhanden_TypeClassItemProvider.dispose();
		if (solllaenge_Mind_Sig_150_TypeClassItemProvider != null) solllaenge_Mind_Sig_150_TypeClassItemProvider.dispose();
		if (solllaenge_Mind_Sig_TypeClassItemProvider != null) solllaenge_Mind_Sig_TypeClassItemProvider.dispose();
		if (sonstige_Standortangabe_TypeClassItemProvider != null) sonstige_Standortangabe_TypeClassItemProvider.dispose();
		if (spannung_Art_TypeClassItemProvider != null) spannung_Art_TypeClassItemProvider.dispose();
		if (spannung_Toleranz_Obere_TypeClassItemProvider != null) spannung_Toleranz_Obere_TypeClassItemProvider.dispose();
		if (spannung_Toleranz_Untere_TypeClassItemProvider != null) spannung_Toleranz_Untere_TypeClassItemProvider.dispose();
		if (srS_Version_TypeClassItemProvider != null) srS_Version_TypeClassItemProvider.dispose();
		if (standortangabe_Balisenschild_TypeClassItemProvider != null) standortangabe_Balisenschild_TypeClassItemProvider.dispose();
		if (start_W_Element_AttributeGroupItemProvider != null) start_W_Element_AttributeGroupItemProvider.dispose();
		if (stZ_TypeClassItemProvider != null) stZ_TypeClassItemProvider.dispose();
		if (system_Vor_Grenze_Besonders_TypeClassItemProvider != null) system_Vor_Grenze_Besonders_TypeClassItemProvider.dispose();
		if (system_Vor_Grenze_TypeClassItemProvider != null) system_Vor_Grenze_TypeClassItemProvider.dispose();
		if (tbV_Meldepunkt_TypeClassItemProvider != null) tbV_Meldepunkt_TypeClassItemProvider.dispose();
		if (tbV_Tunnelbereich_Laenge_TypeClassItemProvider != null) tbV_Tunnelbereich_Laenge_TypeClassItemProvider.dispose();
		if (tbV_Tunnelsignal_TypeClassItemProvider != null) tbV_Tunnelsignal_TypeClassItemProvider.dispose();
		if (telegramm_Index_TypeClassItemProvider != null) telegramm_Index_TypeClassItemProvider.dispose();
		if (telegrammnummer_TypeClassItemProvider != null) telegrammnummer_TypeClassItemProvider.dispose();
		if (text_Bedingung_TypeClassItemProvider != null) text_Bedingung_TypeClassItemProvider.dispose();
		if (textmeldung_TypeClassItemProvider != null) textmeldung_TypeClassItemProvider.dispose();
		if (ueberbrueckung_EV_Unterbrechung_TypeClassItemProvider != null) ueberbrueckung_EV_Unterbrechung_TypeClassItemProvider.dispose();
		if (ueberwachung_Laenge_TypeClassItemProvider != null) ueberwachung_Laenge_TypeClassItemProvider.dispose();
		if (umfahrstrasse_TypeClassItemProvider != null) umfahrstrasse_TypeClassItemProvider.dispose();
		if (untergruppen_ID_TypeClassItemProvider != null) untergruppen_ID_TypeClassItemProvider.dispose();
		if (v_Befehl_R_TypeClassItemProvider != null) v_Befehl_R_TypeClassItemProvider.dispose();
		if (v_Befehl_Z_TypeClassItemProvider != null) v_Befehl_Z_TypeClassItemProvider.dispose();
		if (v_Frei_TypeClassItemProvider != null) v_Frei_TypeClassItemProvider.dispose();
		if (v_Start_TypeClassItemProvider != null) v_Start_TypeClassItemProvider.dispose();
		if (v_Ziel_TypeClassItemProvider != null) v_Ziel_TypeClassItemProvider.dispose();
		if (v_Zul_Strecke_TypeClassItemProvider != null) v_Zul_Strecke_TypeClassItemProvider.dispose();
		if (vbC_Kennung_TypeClassItemProvider != null) vbC_Kennung_TypeClassItemProvider.dispose();
		if (vbC_NID_C_TypeClassItemProvider != null) vbC_NID_C_TypeClassItemProvider.dispose();
		if (vbC_Setzen_TypeClassItemProvider != null) vbC_Setzen_TypeClassItemProvider.dispose();
		if (vbC_Timer_TypeClassItemProvider != null) vbC_Timer_TypeClassItemProvider.dispose();
		if (verbot_Anhalten_TypeClassItemProvider != null) verbot_Anhalten_TypeClassItemProvider.dispose();
		if (verbot_Regenerative_Bremse_TypeClassItemProvider != null) verbot_Regenerative_Bremse_TypeClassItemProvider.dispose();
		if (verbot_WB_Art_TypeClassItemProvider != null) verbot_WB_Art_TypeClassItemProvider.dispose();
		if (verkuerzter_Abstand_TypeClassItemProvider != null) verkuerzter_Abstand_TypeClassItemProvider.dispose();
		if (verwendung_Als_Rueckfall_TypeClassItemProvider != null) verwendung_Als_Rueckfall_TypeClassItemProvider.dispose();
		if (verwendung_Hilfe_TypeClassItemProvider != null) verwendung_Hilfe_TypeClassItemProvider.dispose();
		if (verwendung_TypeClassItemProvider != null) verwendung_TypeClassItemProvider.dispose();
		if (vgR_1_TypeClassItemProvider != null) vgR_1_TypeClassItemProvider.dispose();
		if (vgR_2_TypeClassItemProvider != null) vgR_2_TypeClassItemProvider.dispose();
		if (vgR_TypeClassItemProvider != null) vgR_TypeClassItemProvider.dispose();
		if (vlA_TypeClassItemProvider != null) vlA_TypeClassItemProvider.dispose();
		if (vorsignalabstand_TypeClassItemProvider != null) vorsignalabstand_TypeClassItemProvider.dispose();
		if (vZ_TypeClassItemProvider != null) vZ_TypeClassItemProvider.dispose();
		if (w_Anschluss_TypeClassItemProvider != null) w_Anschluss_TypeClassItemProvider.dispose();
		if (w_Lage_TypeClassItemProvider != null) w_Lage_TypeClassItemProvider.dispose();
		if (wirkrichtung_In_Datenpunkt_TypeClassItemProvider != null) wirkrichtung_In_Datenpunkt_TypeClassItemProvider.dispose();
		if (wirksam_TypeClassItemProvider != null) wirksam_TypeClassItemProvider.dispose();
		if (zbS_La_Bereich_Distanz_TypeClassItemProvider != null) zbS_La_Bereich_Distanz_TypeClassItemProvider.dispose();
		if (zbS_La_Bereich_Geschwindigkeit_TypeClassItemProvider != null) zbS_La_Bereich_Geschwindigkeit_TypeClassItemProvider.dispose();
		if (zbS_La_Bereich_Laenge_TypeClassItemProvider != null) zbS_La_Bereich_Laenge_TypeClassItemProvider.dispose();
		if (zbS_La_Bereich_Neigung_TypeClassItemProvider != null) zbS_La_Bereich_Neigung_TypeClassItemProvider.dispose();
		if (zbS_Merkmale_AttributeGroupItemProvider != null) zbS_Merkmale_AttributeGroupItemProvider.dispose();
		if (zbS_Reaktion_TypeClassItemProvider != null) zbS_Reaktion_TypeClassItemProvider.dispose();
		if (zbS_SchutzstreckeItemProvider != null) zbS_SchutzstreckeItemProvider.dispose();
		if (zbS_Schutzstrecke_Allg_AttributeGroupItemProvider != null) zbS_Schutzstrecke_Allg_AttributeGroupItemProvider.dispose();
		if (zbS_SignalItemProvider != null) zbS_SignalItemProvider.dispose();
		if (zbS_Signal_Signalabstand_AttributeGroupItemProvider != null) zbS_Signal_Signalabstand_AttributeGroupItemProvider.dispose();
		if (ziel_DP_Ausrichtung_TypeClassItemProvider != null) ziel_DP_Ausrichtung_TypeClassItemProvider.dispose();
		if (ziel_Ist_Fahrwegende_TypeClassItemProvider != null) ziel_Ist_Fahrwegende_TypeClassItemProvider.dispose();
		if (ziel_W_Element_AttributeGroupItemProvider != null) ziel_W_Element_AttributeGroupItemProvider.dispose();
		if (zlA_TypeClassItemProvider != null) zlA_TypeClassItemProvider.dispose();
		if (zuB_BereichsgrenzeItemProvider != null) zuB_BereichsgrenzeItemProvider.dispose();
		if (zuB_Bereichsgrenze_Allg_AttributeGroupItemProvider != null) zuB_Bereichsgrenze_Allg_AttributeGroupItemProvider.dispose();
		if (zuB_Bereichsgrenze_Bezeichnung_AttributeGroupItemProvider != null) zuB_Bereichsgrenze_Bezeichnung_AttributeGroupItemProvider.dispose();
		if (zuB_Bereichsgrenze_Nach_ESG_AttributeGroupItemProvider != null) zuB_Bereichsgrenze_Nach_ESG_AttributeGroupItemProvider.dispose();
		if (zuB_Bereichsgrenze_Nach_GNT_TypeClassItemProvider != null) zuB_Bereichsgrenze_Nach_GNT_TypeClassItemProvider.dispose();
		if (zuB_Bereichsgrenze_Nach_L2_AttributeGroupItemProvider != null) zuB_Bereichsgrenze_Nach_L2_AttributeGroupItemProvider.dispose();
		if (zuB_Bereichsgrenze_Nach_L2_Von_ESG_AttributeGroupItemProvider != null) zuB_Bereichsgrenze_Nach_L2_Von_ESG_AttributeGroupItemProvider.dispose();
		if (zuB_Bereichsgrenze_Nach_LZB_AttributeGroupItemProvider != null) zuB_Bereichsgrenze_Nach_LZB_AttributeGroupItemProvider.dispose();
		if (zuB_Bereichsgrenze_Nach_Ohne_AttributeGroupItemProvider != null) zuB_Bereichsgrenze_Nach_Ohne_AttributeGroupItemProvider.dispose();
		if (zuB_Bereichsgrenze_Nach_PZB_AttributeGroupItemProvider != null) zuB_Bereichsgrenze_Nach_PZB_AttributeGroupItemProvider.dispose();
		if (zuB_Bereichsgrenze_Nach_Sonstige_AttributeGroupItemProvider != null) zuB_Bereichsgrenze_Nach_Sonstige_AttributeGroupItemProvider.dispose();
		if (zuB_Bereichsgrenze_Nach_ZBS_AttributeGroupItemProvider != null) zuB_Bereichsgrenze_Nach_ZBS_AttributeGroupItemProvider.dispose();
		if (zuB_Bgrenze_RBC_Wechsel_AttributeGroupItemProvider != null) zuB_Bgrenze_RBC_Wechsel_AttributeGroupItemProvider.dispose();
		if (zuB_SE_Ausruestung_AttributeGroupItemProvider != null) zuB_SE_Ausruestung_AttributeGroupItemProvider.dispose();
		if (zuB_StreckeneigenschaftItemProvider != null) zuB_StreckeneigenschaftItemProvider.dispose();
		if (zuB_Streckeneigenschaft_Bezeichnung_AttributeGroupItemProvider != null) zuB_Streckeneigenschaft_Bezeichnung_AttributeGroupItemProvider.dispose();
	}

}
