/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.operation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.s.util.maven.IMavenRunnerSpi;
import org.eclipse.scout.sdk.core.s.util.maven.MavenBuild;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;
import org.osgi.framework.Version;

public class MavenBuildOperation
implements BiConsumer<IEnvironment, IProgress> {
    public static final String LAUNCH_CONFIGURATION_TYPE_ID = "org.eclipse.m2e.Maven2LaunchConfigurationType";
    public static final String WORKING_DIRECTORY = "org.eclipse.jdt.launching.WORKING_DIRECTORY";
    public static final String JRE_CONTAINER = "org.eclipse.jdt.launching.JRE_CONTAINER";
    public static final String M2_PROFILES = "M2_PROFILES";
    public static final String M2_GOALS = "M2_GOALS";
    public static final String M2_PROPERTIES = "M2_PROPERTIES";
    public static final String M2_OFFLINE = "M2_OFFLINE";
    public static final String M2_UPDATE_SNAPSHOTS = "M2_UPDATE_SNAPSHOTS";
    public static final String M2_SKIP_TESTS = "M2_SKIP_TESTS";
    public static final String M2_NON_RECURSIVE = "M2_NON_RECURSIVE";
    public static final String M2_WORKSPACE_RESOLUTION = "M2_WORKSPACE_RESOLUTION";
    public static final String M2_DEBUG_OUTPUT = "M2_DEBUG_OUTPUT";
    public static final String M2_THREADS = "M2_THREADS";
    private static final AtomicLong BUILD_NAME_NUM = new AtomicLong(0L);
    private MavenBuild m_build;
    private volatile CountDownLatch m_artifactGenCompleted;
    private boolean m_waitUntilCompleted = true;
    private final List<Integer> m_mavenReturnCodes = new ArrayList<Integer>(1);

    @Override
    public void accept(IEnvironment env, IProgress progress) {
        Ensure.notNull((Object)this.getBuild());
        Ensure.isFalse((boolean)this.getBuild().getGoals().isEmpty());
        Ensure.notNull((Object)this.getBuild().getWorkingDirectory());
        progress.init(10, (CharSequence)this.toString(), new Object[0]);
        this.m_artifactGenCompleted = new CountDownLatch(1);
        try {
            this.scheduleMavenBuild(progress);
            progress.setWorkRemaining(4);
            if (this.isWaitUntilCompleted()) {
                this.waitForArtifactBuildCompleted();
                for (Integer mavenReturnCode : this.m_mavenReturnCodes) {
                    if (mavenReturnCode != null && mavenReturnCode == 0) continue;
                    throw Ensure.newFail((CharSequence)"Maven build failed with error code {}. See Maven Console for details.", (Object[])new Object[]{mavenReturnCode});
                }
            }
            progress.worked(4);
        }
        catch (CoreException e) {
            throw new SdkException((Throwable)e);
        }
    }

    protected void scheduleMavenBuild(IProgress progress) throws CoreException {
        ILaunchConfiguration launchConfiguration = this.createLaunchConfiguration((IProgressMonitor)EclipseEnvironment.toScoutProgress(progress.newChild(1)).monitor());
        SdkLog.debug((CharSequence)"Executing embedded {}", (Object[])new Object[]{this.getBuild().toString()});
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchListener)new LaunchListener());
        launchConfiguration.launch("run", (IProgressMonitor)EclipseEnvironment.toScoutProgress(progress.newChild(5)).monitor(), false, true);
    }

    protected void waitForArtifactBuildCompleted() {
        try {
            boolean completed = this.m_artifactGenCompleted.await(15L, TimeUnit.MINUTES);
            if (!completed) {
                SdkLog.warning((CharSequence)"Maven build did not complete within 15 minutes.", (Object[])new Object[0]);
            }
        }
        catch (InterruptedException e) {
            SdkLog.debug((Object[])new Object[]{e});
        }
    }

    protected IContainer getWorkspaceContainer() {
        IContainer[] containers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(this.getBuild().getWorkingDirectory().toUri());
        if (containers.length < 1) {
            return null;
        }
        return containers[0];
    }

    protected ILaunchConfiguration createLaunchConfiguration(IProgressMonitor monitor) throws CoreException {
        IVMInstall vm;
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType(LAUNCH_CONFIGURATION_TYPE_ID);
        ILaunchConfigurationWorkingCopy workingCopy = launchConfigurationType.newInstance(null, "-mavenBuild" + BUILD_NAME_NUM.getAndIncrement());
        MavenBuild build = this.getBuild();
        Map properties = build.getProperties();
        workingCopy.setAttribute(WORKING_DIRECTORY, build.getWorkingDirectory().toAbsolutePath().toString());
        workingCopy.setAttribute("org.eclipse.debug.ui.private", true);
        workingCopy.setAttribute(M2_UPDATE_SNAPSHOTS, build.hasOption('U'));
        workingCopy.setAttribute(M2_OFFLINE, build.hasOption('o'));
        workingCopy.setAttribute(M2_SKIP_TESTS, properties.containsKey("skipTests") || properties.containsKey("maven.test.skip"));
        workingCopy.setAttribute(M2_NON_RECURSIVE, build.hasOption('N'));
        workingCopy.setAttribute(M2_WORKSPACE_RESOLUTION, true);
        workingCopy.setAttribute(M2_DEBUG_OUTPUT, SdkLog.isDebugEnabled() || build.hasOption('X'));
        workingCopy.setAttribute(M2_THREADS, 1);
        workingCopy.setAttribute(M2_PROPERTIES, build.getPropertiesAsList());
        if (build.getGoals().stream().anyMatch("archetype:generate"::equals) && (vm = MavenBuildOperation.getDefaultJvm()) != null) {
            String path = Path.fromOSString((String)vm.getInstallLocation().toString()).toPortableString();
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, path);
        }
        MavenBuildOperation.setGoals(workingCopy, build.getGoals());
        IContainer container = this.getWorkspaceContainer();
        MavenBuildOperation.setProjectConfiguration(workingCopy, container, monitor);
        MavenBuildOperation.setJreContainerPath(workingCopy, (IResource)container);
        return workingCopy;
    }

    protected static IVMInstall getDefaultJvm() {
        IVMInstall defaultVm = JavaRuntime.getDefaultVMInstall();
        if (defaultVm != null && "org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType".equals(defaultVm.getVMInstallType().getName())) {
            return defaultVm;
        }
        IVMInstall2 result = null;
        for (IVMInstall candidate : JavaRuntime.getVMInstallType((String)"org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType").getVMInstalls()) {
            if (!(candidate instanceof IVMInstall2)) continue;
            IVMInstall2 vm2 = (IVMInstall2)candidate;
            if (result != null && new Version(vm2.getJavaVersion()).compareTo(new Version(result.getJavaVersion())) <= 0) continue;
            result = vm2;
        }
        return (IVMInstall)result;
    }

    protected static void setJreContainerPath(ILaunchConfigurationWorkingCopy workingCopy, IResource container) throws CoreException {
        IPath path = MavenBuildOperation.getJreContainerPath(container);
        if (path != null) {
            workingCopy.setAttribute(JRE_CONTAINER, path.toPortableString());
        }
    }

    protected static void setGoals(ILaunchConfigurationWorkingCopy workingCopy, Iterable<String> goals) {
        StringBuilder goalBuilder = new StringBuilder();
        Iterator<String> iterator = goals.iterator();
        goalBuilder.append(iterator.next());
        while (iterator.hasNext()) {
            goalBuilder.append(' ').append(iterator.next());
        }
        workingCopy.setAttribute(M2_GOALS, goalBuilder.toString());
    }

    protected static void setProjectConfiguration(ILaunchConfigurationWorkingCopy workingCopy, IContainer basedir, IProgressMonitor monitor) {
        if (basedir == null || !basedir.exists() || basedir.getType() != 4) {
            return;
        }
        IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
        if (projectManager == null) {
            return;
        }
        IFile pomFile = basedir.getFile((IPath)new Path("pom.xml"));
        IMavenProjectFacade projectFacade = projectManager.create(pomFile, false, monitor);
        if (projectFacade == null) {
            return;
        }
        ResolverConfiguration configuration = projectFacade.getResolverConfiguration();
        if (configuration == null) {
            return;
        }
        String selectedProfiles = configuration.getSelectedProfiles();
        if (Strings.hasText((CharSequence)selectedProfiles)) {
            workingCopy.setAttribute(M2_PROFILES, selectedProfiles);
        }
    }

    protected static IPath getJreContainerPath(IResource basedir) throws CoreException {
        if (basedir == null || !basedir.exists()) {
            return null;
        }
        IProject project = basedir.getProject();
        if (project == null || !project.hasNature("org.eclipse.jdt.core.javanature")) {
            return null;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (!JdtUtils.exists((IJavaElement)javaProject)) {
            return null;
        }
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        return Arrays.stream(entries).filter(entry -> JRE_CONTAINER.equals(entry.getPath().segment(0))).findFirst().map(IClasspathEntry::getPath).orElse(null);
    }

    public boolean isWaitUntilCompleted() {
        return this.m_waitUntilCompleted;
    }

    public void setWaitUntilCompleted(boolean waitUntilCompleted) {
        this.m_waitUntilCompleted = waitUntilCompleted;
    }

    public MavenBuild getBuild() {
        return this.m_build;
    }

    public void setBuild(MavenBuild build) {
        this.m_build = build;
    }

    public String toString() {
        return "Maven Build";
    }

    private final class LaunchListener
    implements ILaunchListener {
        private final Collection<IProcess> m_watchedProcesses = new HashSet<IProcess>(1);

        private LaunchListener() {
        }

        public void launchRemoved(ILaunch launch) {
        }

        public void launchAdded(ILaunch launch) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void launchChanged(ILaunch launch) {
            IProcess[] processes = launch.getProcesses();
            if (processes == null || processes.length < 1) {
                return;
            }
            DebugPlugin debugPlugin = DebugPlugin.getDefault();
            Collection<IProcess> collection = this.m_watchedProcesses;
            synchronized (collection) {
                debugPlugin.addDebugEventListener((IDebugEventSetListener)new DebugEventSetListener(this.m_watchedProcesses));
                Collections.addAll(this.m_watchedProcesses, processes);
                debugPlugin.getLaunchManager().removeLaunchListener((ILaunchListener)this);
            }
        }
    }

    public static final class M2eMavenRunner
    implements IMavenRunnerSpi {
        public void execute(MavenBuild build, IEnvironment env, IProgress progress) {
            MavenBuildOperation op = new MavenBuildOperation();
            op.setBuild(build);
            op.accept(env, progress);
        }
    }

    private final class DebugEventSetListener
    implements IDebugEventSetListener {
        private final Collection<IProcess> m_expectedProcesses;

        private DebugEventSetListener(Collection<IProcess> expectedProcesses) {
            this.m_expectedProcesses = expectedProcesses;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleDebugEvents(DebugEvent[] events) {
            Collection<IProcess> collection = this.m_expectedProcesses;
            synchronized (collection) {
                for (DebugEvent e : events) {
                    IProcess changedProcess;
                    Object source = e.getSource();
                    if (source == null || !this.m_expectedProcesses.contains(source) || !(changedProcess = (IProcess)source).isTerminated()) continue;
                    int exitValue = -1;
                    try {
                        exitValue = changedProcess.getExitValue();
                    }
                    catch (DebugException ex) {
                        SdkLog.error((CharSequence)"Error reading exit value.", (Object[])new Object[]{ex});
                    }
                    MavenBuildOperation.this.m_mavenReturnCodes.add(exitValue);
                    this.m_expectedProcesses.remove(changedProcess);
                }
                if (this.m_expectedProcesses.isEmpty()) {
                    DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                    MavenBuildOperation.this.m_artifactGenCompleted.countDown();
                }
            }
        }
    }
}

