/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.nls.editor.importexport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.editor.importexport.TranslationImportExportWizardExtension;
import org.eclipse.scout.sdk.s2e.ui.wizard.AbstractImportExportWizard;
import org.osgi.framework.Bundle;

public final class TranslationImportExportExtensionPoint {
    public static final String EXTENSION_POINT_ID_NLS_EXPORTER = "nlsExporter";
    public static final String EXTENSION_POINT_ID_NLS_IMPORTER = "nlsImporter";
    private static volatile List<TranslationImportExportWizardExtension> importers;
    private static volatile List<TranslationImportExportWizardExtension> exporters;

    private TranslationImportExportExtensionPoint() {
    }

    public static List<TranslationImportExportWizardExtension> getImporters() {
        List<TranslationImportExportWizardExtension> result = importers;
        if (result != null) {
            return result;
        }
        return TranslationImportExportExtensionPoint.loadImporters();
    }

    private static synchronized List<TranslationImportExportWizardExtension> loadImporters() {
        List<TranslationImportExportWizardExtension> result = importers;
        if (result != null) {
            return result;
        }
        importers = result = TranslationImportExportExtensionPoint.loadExtensionPoints(EXTENSION_POINT_ID_NLS_IMPORTER);
        return result;
    }

    public static List<TranslationImportExportWizardExtension> getExporters() {
        List<TranslationImportExportWizardExtension> result = exporters;
        if (result != null) {
            return result;
        }
        return TranslationImportExportExtensionPoint.loadExporters();
    }

    private static synchronized List<TranslationImportExportWizardExtension> loadExporters() {
        List<TranslationImportExportWizardExtension> result = exporters;
        if (result != null) {
            return result;
        }
        exporters = result = TranslationImportExportExtensionPoint.loadExtensionPoints(EXTENSION_POINT_ID_NLS_EXPORTER);
        return result;
    }

    private static List<TranslationImportExportWizardExtension> loadExtensionPoints(String id) {
        IExtension[] exts;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        ArrayList<TranslationImportExportWizardExtension> wizardExtensions = new ArrayList<TranslationImportExportWizardExtension>();
        IExtensionPoint xp = reg.getExtensionPoint("org.eclipse.scout.sdk.s2e.ui", id);
        IExtension[] iExtensionArray = exts = xp.getExtensions();
        int n = exts.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                try {
                    String attWizard = element.getAttribute("wizard");
                    String attName = element.getAttribute("name");
                    if (Strings.isBlank((CharSequence)attWizard) || Strings.isBlank((CharSequence)attName)) {
                        SdkLog.warning((String)"Invalid import/export wizard extension: {}. Name or wizard missing.", (Object[])new Object[]{extension.getExtensionPointUniqueIdentifier()});
                    } else {
                        Bundle contributingBundle = Platform.getBundle((String)extension.getNamespaceIdentifier());
                        Class wizard = contributingBundle.loadClass(attWizard);
                        if (!AbstractImportExportWizard.class.isAssignableFrom(wizard)) {
                            SdkLog.error((String)"extension '{}' has a wizard not instance of '{}'. Ignoring extension.", (Object[])new Object[]{extension.getExtensionPointUniqueIdentifier(), AbstractImportExportWizard.class.getName()});
                        } else {
                            wizardExtensions.add(new TranslationImportExportWizardExtension(wizard, attName.trim()));
                        }
                    }
                }
                catch (ClassNotFoundException | NoClassDefFoundError | RuntimeException e) {
                    SdkLog.error((String)"Could not create an executable extension of point '{}'.", (Object[])new Object[]{extension.getExtensionPointUniqueIdentifier(), e});
                }
                ++n4;
            }
            ++n2;
        }
        return Collections.unmodifiableList(new ArrayList(wizardExtensions));
    }
}

