/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.manipulation.CodeTemplateContext;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.GlobalTemplateVariables;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.scout.sdk.core.builder.java.body.IMethodBodyBuilder;
import org.eclipse.scout.sdk.core.builder.java.comment.ICommentBuilder;
import org.eclipse.scout.sdk.core.builder.java.comment.IDefaultElementCommentGeneratorSpi;
import org.eclipse.scout.sdk.core.generator.IJavaElementGenerator;
import org.eclipse.scout.sdk.core.generator.ISourceGenerator;
import org.eclipse.scout.sdk.core.generator.compilationunit.ICompilationUnitGenerator;
import org.eclipse.scout.sdk.core.generator.field.IFieldGenerator;
import org.eclipse.scout.sdk.core.generator.method.IMethodGenerator;
import org.eclipse.scout.sdk.core.generator.methodparam.IMethodParameterGenerator;
import org.eclipse.scout.sdk.core.generator.type.ITypeGenerator;
import org.eclipse.scout.sdk.core.model.api.PropertyBean;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.JavaTypes;
import org.eclipse.scout.sdk.core.util.PropertySupport;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;

public class JdtSettingsCommentGenerator
implements IDefaultElementCommentGeneratorSpi {
    private static final String UNDEFINED_VAR_VALUE = "undefined";
    private static final int METHOD_TYPE_NORMAL = 2;
    private static final int METHOD_TYPE_GETTER = 4;
    private static final int METHOD_TYPE_SETTER = 8;
    private static final TemplateVariableResolver USERNAME_RESOLVER = new UsernameResolver();

    public ISourceGenerator<ICommentBuilder<?>> createCompilationUnitComment(ICompilationUnitGenerator<?> target) {
        return b -> {
            PropertySupport builderCtx = b.context().properties();
            if (!JdtSettingsCommentGenerator.isAutomaticallyAddComments(builderCtx)) {
                return;
            }
            IJavaProject ownerProject = (IJavaProject)builderCtx.getProperty("JavaProject", IJavaProject.class);
            Template template = JdtSettingsCommentGenerator.getCodeTemplate("org.eclipse.jdt.ui.text.codetemplates.filecomment", ownerProject);
            if (template != null) {
                CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), ownerProject, b.context().lineDelimiter());
                context.setVariable("file_name", (String)target.fileName().orElse(null));
                String packageName = target.packageName().orElse("");
                context.setVariable("package_name", packageName);
                if (JdtUtils.exists((IJavaElement)ownerProject)) {
                    context.setVariable("project_name", ownerProject.getElementName());
                }
                context.setVariable("type_name", JavaCore.removeJavaLikeExtension((String)target.elementName().orElse(null)));
                String comment = JdtSettingsCommentGenerator.evaluateTemplate((TemplateContext)context, template);
                if (comment != null) {
                    b.append(comment);
                    JdtSettingsCommentGenerator.ensureEndsWithNewline(b, comment);
                }
            }
        };
    }

    public ISourceGenerator<ICommentBuilder<?>> createTypeComment(ITypeGenerator<?> target) {
        return b -> {
            TemplateBuffer buffer;
            PropertySupport builderCtx = b.context().properties();
            if (!JdtSettingsCommentGenerator.isAutomaticallyAddComments(builderCtx)) {
                return;
            }
            IJavaProject ownerProject = (IJavaProject)builderCtx.getProperty("JavaProject", IJavaProject.class);
            Template template = JdtSettingsCommentGenerator.getCodeTemplate("org.eclipse.jdt.ui.text.codetemplates.typecomment", ownerProject);
            if (template == null) {
                return;
            }
            CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), ownerProject, b.context().lineDelimiter());
            context.setVariable("file_name", UNDEFINED_VAR_VALUE);
            context.setVariable("package_name", JavaTypes.qualifier((CharSequence)target.fullyQualifiedName()));
            if (JdtUtils.exists((IJavaElement)ownerProject)) {
                context.setVariable("project_name", ownerProject.getElementName());
            }
            context.setVariable("enclosing_type", (String)target.getDeclaringFullyQualifiedName().orElse(null));
            context.setVariable("type_name", (String)target.elementName().orElse(null));
            try {
                buffer = context.evaluate(template);
            }
            catch (BadLocationException | TemplateException e) {
                throw new SdkException(e);
            }
            String str = buffer.getString();
            if (Strings.isBlank((CharSequence)str)) {
                return;
            }
            TemplateVariable position = JdtSettingsCommentGenerator.findVariable(buffer, "tags");
            if (position == null) {
                b.append(str);
                JdtSettingsCommentGenerator.ensureEndsWithNewline(b, str);
                return;
            }
            Document document = new Document(str);
            int[] tagOffsets = position.getOffsets();
            int i = tagOffsets.length - 1;
            while (i >= 0) {
                try {
                    JdtSettingsCommentGenerator.insertTag((IDocument)document, tagOffsets[i], position.getLength(), Collections.emptyList(), Collections.emptyList(), null, Collections.emptyList(), false, b.context().lineDelimiter());
                }
                catch (BadLocationException e) {
                    throw new SdkException((Throwable)e);
                }
                --i;
            }
            String comment = document.get();
            if (comment != null) {
                b.append(comment);
                JdtSettingsCommentGenerator.ensureEndsWithNewline(b, comment);
            }
        };
    }

    public ISourceGenerator<ICommentBuilder<?>> createMethodComment(IMethodGenerator<?, ? extends IMethodBodyBuilder<?>> target) {
        return JdtSettingsCommentGenerator.createMethodCommentInternal(target, 2);
    }

    public ISourceGenerator<ICommentBuilder<?>> createGetterMethodComment(IMethodGenerator<?, ? extends IMethodBodyBuilder<?>> target) {
        return JdtSettingsCommentGenerator.createMethodCommentInternal(target, 4);
    }

    public ISourceGenerator<ICommentBuilder<?>> createSetterMethodComment(IMethodGenerator<?, ? extends IMethodBodyBuilder<?>> target) {
        return JdtSettingsCommentGenerator.createMethodCommentInternal(target, 8);
    }

    private static void ensureEndsWithNewline(ICommentBuilder<?> b, String comment) {
        if (comment.endsWith(b.context().lineDelimiter())) {
            return;
        }
        b.nl();
    }

    private static ISourceGenerator<ICommentBuilder<?>> createMethodCommentInternal(IMethodGenerator<?, ? extends IMethodBodyBuilder<?>> target, int type) {
        return b -> {
            TemplateBuffer buffer;
            Template template;
            String templateName;
            PropertySupport builderCtx = b.context().properties();
            if (!JdtSettingsCommentGenerator.isAutomaticallyAddComments(builderCtx)) {
                return;
            }
            IJavaProject ownerProject = (IJavaProject)builderCtx.getProperty("JavaProject", IJavaProject.class);
            List<String> paramNames = target.parameters().map(IJavaElementGenerator::elementName).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            List<String> exceptionNames = target.exceptions().collect(Collectors.toList());
            Optional returnTypeName = target.returnType();
            String fieldTypeSimpleName = UNDEFINED_VAR_VALUE;
            switch (type) {
                case 4: {
                    templateName = "org.eclipse.jdt.ui.text.codetemplates.gettercomment";
                    if (!returnTypeName.isPresent()) break;
                    fieldTypeSimpleName = JavaTypes.simpleName((CharSequence)((CharSequence)returnTypeName.get()));
                    break;
                }
                case 8: {
                    templateName = "org.eclipse.jdt.ui.text.codetemplates.settercomment";
                    Optional firstParam = target.parameters().findAny().flatMap(IMethodParameterGenerator::dataType);
                    if (!firstParam.isPresent()) break;
                    fieldTypeSimpleName = JavaTypes.simpleName((CharSequence)((CharSequence)firstParam.get()));
                    break;
                }
                default: {
                    templateName = returnTypeName.map(s -> "org.eclipse.jdt.ui.text.codetemplates.methodcomment").orElse("org.eclipse.jdt.ui.text.codetemplates.constructorcomment");
                }
            }
            if ((template = JdtSettingsCommentGenerator.getCodeTemplate(templateName, ownerProject)) == null) {
                return;
            }
            CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), ownerProject, b.context().lineDelimiter());
            String getterSetterName = UNDEFINED_VAR_VALUE;
            Matcher matcher = PropertyBean.BEAN_METHOD_NAME.matcher(target.elementName().orElse(""));
            if (matcher.find()) {
                getterSetterName = matcher.group(2);
            }
            if (JdtUtils.exists((IJavaElement)ownerProject)) {
                context.setVariable("project_name", ownerProject.getElementName());
            }
            context.setVariable("file_name", UNDEFINED_VAR_VALUE);
            context.setVariable("package_name", UNDEFINED_VAR_VALUE);
            context.setVariable("enclosing_method", (String)target.elementName().orElse(null));
            context.setVariable("enclosing_type", UNDEFINED_VAR_VALUE);
            context.setVariable("field", getterSetterName);
            context.setVariable("field_type", fieldTypeSimpleName);
            context.setVariable("bare_field_name", getterSetterName);
            if (!paramNames.isEmpty()) {
                context.setVariable("param", (String)paramNames.get(0));
            } else {
                context.setVariable("param", UNDEFINED_VAR_VALUE);
            }
            returnTypeName.ifPresent(arg_0 -> JdtSettingsCommentGenerator.lambda$8((TemplateContext)context, arg_0));
            try {
                buffer = context.evaluate(template);
            }
            catch (BadLocationException | TemplateException e) {
                throw new SdkException(e);
            }
            if (buffer == null) {
                return;
            }
            String str = buffer.getString();
            if (Strings.isBlank((CharSequence)str)) {
                return;
            }
            TemplateVariable position = JdtSettingsCommentGenerator.findVariable(buffer, "tags");
            if (position == null) {
                b.append(str);
                JdtSettingsCommentGenerator.ensureEndsWithNewline(b, str);
                return;
            }
            Document document = new Document(str);
            int[] tagOffsets = position.getOffsets();
            int i = tagOffsets.length - 1;
            while (i >= 0) {
                try {
                    JdtSettingsCommentGenerator.insertTag((IDocument)document, tagOffsets[i], position.getLength(), paramNames, exceptionNames, returnTypeName.orElse(null), Collections.emptyList(), false, b.context().lineDelimiter());
                }
                catch (BadLocationException e) {
                    throw new SdkException((Throwable)e);
                }
                --i;
            }
            String comment = document.get();
            if (comment != null) {
                b.append(comment);
                JdtSettingsCommentGenerator.ensureEndsWithNewline(b, comment);
            }
        };
    }

    public ISourceGenerator<ICommentBuilder<?>> createFieldComment(IFieldGenerator<?> target) {
        return b -> {
            PropertySupport builderCtx = b.context().properties();
            if (!JdtSettingsCommentGenerator.isAutomaticallyAddComments(builderCtx)) {
                return;
            }
            IJavaProject ownerProject = (IJavaProject)builderCtx.getProperty("JavaProject", IJavaProject.class);
            Template template = JdtSettingsCommentGenerator.getCodeTemplate("org.eclipse.jdt.ui.text.codetemplates.fieldcomment", ownerProject);
            if (template != null) {
                CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), ownerProject, b.context().lineDelimiter());
                context.setVariable("field_type", JavaTypes.simpleName((CharSequence)target.dataType().orElse(null)));
                context.setVariable("field", (String)target.elementName().orElse(null));
                if (JdtUtils.exists((IJavaElement)ownerProject)) {
                    context.setVariable("project_name", ownerProject.getElementName());
                }
                context.setVariable("package_name", UNDEFINED_VAR_VALUE);
                context.setVariable("file_name", UNDEFINED_VAR_VALUE);
                String comment = JdtSettingsCommentGenerator.evaluateTemplate((TemplateContext)context, template);
                if (comment != null) {
                    b.append(comment);
                    JdtSettingsCommentGenerator.ensureEndsWithNewline(b, comment);
                }
            }
        };
    }

    private static boolean isAutomaticallyAddComments(PropertySupport map) {
        IScopeContext[] contexts;
        if (map == null) {
            return false;
        }
        IJavaProject jp = (IJavaProject)map.getProperty("JavaProject", IJavaProject.class);
        if (jp == null) {
            return false;
        }
        IScopeContext[] iScopeContextArray = contexts = new IScopeContext[]{new ProjectScope(jp.getProject()), InstanceScope.INSTANCE, DefaultScope.INSTANCE};
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            IScopeContext context = iScopeContextArray[n2];
            IEclipsePreferences node = context.getNode("org.eclipse.jdt.ui");
            if (node != null) {
                String val = node.get("org.eclipse.jdt.ui.javadoc", null);
                return "true".equals(val);
            }
            ++n2;
        }
        return true;
    }

    private static String evaluateTemplate(TemplateContext context, Template template) {
        TemplateBuffer buffer;
        Iterator resolvers = context.getContextType().resolvers();
        while (resolvers.hasNext()) {
            TemplateVariableResolver resolver = (TemplateVariableResolver)resolvers.next();
            if (!(resolver instanceof GlobalTemplateVariables.User)) continue;
            context.getContextType().removeResolver(resolver);
            context.getContextType().addResolver(USERNAME_RESOLVER);
            break;
        }
        try {
            buffer = context.evaluate(template);
        }
        catch (BadLocationException | TemplateException e) {
            throw new SdkException(e);
        }
        if (buffer == null) {
            return null;
        }
        String str = buffer.getString();
        if (Strings.isBlank((CharSequence)str)) {
            return null;
        }
        return str;
    }

    private static Template getCodeTemplate(String id, IJavaProject project) {
        return StubUtility.getCodeTemplate((String)id, (IJavaProject)project);
    }

    private static TemplateVariable findVariable(TemplateBuffer buffer, String variable) {
        TemplateVariable[] positions;
        TemplateVariable[] templateVariableArray = positions = buffer.getVariables();
        int n = positions.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateVariable curr = templateVariableArray[n2];
            if (variable.equals(curr.getType())) {
                return curr;
            }
            ++n2;
        }
        return null;
    }

    private static void insertTag(IDocument textBuffer, int offset, int length, Iterable<String> paramNames, Iterable<String> exceptionNames, String returnType, Iterable<String> typeParameterNames, boolean isDeprecated, String lineDelimiter) throws BadLocationException {
        int prevLine;
        IRegion region = textBuffer.getLineInformationOfOffset(offset);
        if (region == null) {
            return;
        }
        String lineStart = textBuffer.get(region.getOffset(), offset - region.getOffset());
        StringBuilder buf = new StringBuilder();
        for (String typeParameterName : typeParameterNames) {
            if (buf.length() > 0) {
                buf.append(lineDelimiter).append(lineStart);
            }
            buf.append("@param ").append('<').append(typeParameterName).append('>');
        }
        for (String paramName : paramNames) {
            if (buf.length() > 0) {
                buf.append(lineDelimiter).append(lineStart);
            }
            buf.append("@param ").append(paramName);
        }
        if (returnType != null && !"void".equals(returnType)) {
            if (buf.length() > 0) {
                buf.append(lineDelimiter).append(lineStart);
            }
            buf.append("@return");
        }
        if (exceptionNames != null) {
            for (String exceptionName : exceptionNames) {
                if (buf.length() > 0) {
                    buf.append(lineDelimiter).append(lineStart);
                }
                buf.append("@throws ").append(exceptionName);
            }
        }
        if (isDeprecated) {
            if (buf.length() > 0) {
                buf.append(lineDelimiter).append(lineStart);
            }
            buf.append("@deprecated");
        }
        if (buf.length() == 0 && JdtSettingsCommentGenerator.isAllCommentWhitespace(lineStart) && (prevLine = textBuffer.getLineOfOffset(offset) - 1) > 0) {
            IRegion prevRegion = textBuffer.getLineInformation(prevLine);
            int prevLineEnd = prevRegion.getOffset() + prevRegion.getLength();
            textBuffer.replace(prevLineEnd, offset + length - prevLineEnd, "");
            return;
        }
        textBuffer.replace(offset, length, buf.toString());
    }

    private static boolean isAllCommentWhitespace(CharSequence lineStart) {
        int i = 0;
        while (i < lineStart.length()) {
            char ch = lineStart.charAt(i);
            if (!Character.isWhitespace(ch) && ch != '*') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static /* synthetic */ void lambda$8(TemplateContext templateContext, String s) {
        templateContext.setVariable("return_type", s);
    }

    private static final class UsernameResolver
    extends GlobalTemplateVariables.User {
        private UsernameResolver() {
        }

        protected String resolve(TemplateContext context) {
            return CoreUtils.getUsername();
        }
    }
}

