/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.tools.launch.rwt.internal.config;

import org.eclipse.rap.tools.launch.rwt.internal.config.RWTLaunchConfig;
import org.eclipse.rap.tools.launch.rwt.internal.config.ValidationResult;
import org.eclipse.rap.tools.launch.rwt.internal.config.Validator;

public class ContextPathValidator
extends Validator {
    static final int ERR_CONTEXT_PATH_INVALID = 8041;
    static final int ERR_CONTEXT_PATH_LEADING_SLASH = 8042;

    ContextPathValidator(RWTLaunchConfig config, ValidationResult validationResult) {
        super(config, validationResult);
    }

    void validate() {
        if (this.config.getUseManualContextPath()) {
            this.validateLeadingSlash();
            this.vaidateCharacters();
        }
    }

    private void validateLeadingSlash() {
        if (!this.config.getContextPath().startsWith("/")) {
            this.addError("The context path must start with a slash.", 8042);
        }
    }

    private void vaidateCharacters() {
        String contextPath = this.config.getContextPath();
        if (contextPath.startsWith("/")) {
            contextPath = contextPath.substring(1);
        }
        boolean invalid = false;
        if (contextPath.indexOf("//") != -1) {
            invalid = true;
        }
        int i = 0;
        while (i < contextPath.length() && !invalid) {
            boolean isValidSpecialChar;
            char ch = contextPath.charAt(i);
            boolean isLetterOrDigit = Character.isLetterOrDigit(ch);
            boolean bl = isValidSpecialChar = "/_-.".indexOf(ch) != -1;
            if (!isLetterOrDigit && !isValidSpecialChar) {
                invalid = true;
            }
            ++i;
        }
        if (invalid) {
            this.addError("The context path contains invalid characters.", 8041);
        }
    }
}

