/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.rwt.Adaptable;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.widgets.EventUtil;
import org.eclipse.swt.widgets.Widget;

public class DragSourceEvent
extends TypedEvent {
    private static final long serialVersionUID = 1L;
    public static final int DRAG_START = 2008;
    public static final int DRAG_END = 2000;
    public static final int DRAG_SET_DATA = 2001;
    private static final Class LISTENER = DragSourceListener.class;
    public int detail;
    public boolean doit;
    public int x;
    public int y;
    public TransferData dataType;
    public Image image;
    public int offsetX;
    public int offsetY;
    public int time;

    public DragSourceEvent(Widget widget, int id) {
        super(widget, id);
    }

    public String toString() {
        String string = super.toString();
        return String.valueOf(string.substring(0, string.length() - 1)) + " operation=" + this.detail + " type=" + (this.dataType != null ? this.dataType.type : 0) + " doit=" + this.doit + "}";
    }

    protected void dispatchToObserver(Object listener) {
        switch (this.getID()) {
            case 2008: {
                ((DragSourceListener)listener).dragStart(this);
                break;
            }
            case 2000: {
                ((DragSourceListener)listener).dragFinished(this);
                break;
            }
            case 2001: {
                ((DragSourceListener)listener).dragSetData(this);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid event handler type.");
            }
        }
    }

    protected boolean allowProcessing() {
        return EventUtil.isAccessible(this.widget);
    }

    protected Class getListenerType() {
        return LISTENER;
    }

    public static boolean hasListener(Adaptable adaptable) {
        return DragSourceEvent.hasListener(adaptable, LISTENER);
    }

    public static void addListener(Adaptable adaptable, DragSourceListener listener) {
        DragSourceEvent.addListener(adaptable, LISTENER, listener);
    }

    public static void removeListener(Adaptable adaptable, DragSourceListener listener) {
        DragSourceEvent.removeListener(adaptable, LISTENER, listener);
    }

    public static Object[] getListeners(Adaptable adaptable) {
        return DragSourceEvent.getListener(adaptable, LISTENER);
    }
}

