/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.FrameworkUtil;

public final class SafeRunner {
    public static void run(ISafeRunnable code) {
        Assert.isNotNull(code);
        try {
            code.run();
        }
        catch (Exception e) {
            SafeRunner.handleException(code, e);
        }
        catch (LinkageError e) {
            SafeRunner.handleException(code, e);
        }
        catch (AssertionError e) {
            SafeRunner.handleException(code, (Throwable)((Object)e));
        }
    }

    private static void handleException(ISafeRunnable code, Throwable e) {
        if (!(e instanceof OperationCanceledException)) {
            String pluginId = FrameworkUtil.getBundle(code.getClass()).getSymbolicName();
            if (pluginId == null) {
                pluginId = "org.eclipse.equinox.common";
            }
            String message = String.format("Problems occurred when invoking code from plug-in: \"{0}\".", pluginId);
            if (e instanceof CoreException) {
                MultiStatus status = new MultiStatus(pluginId, 2, message, e);
                status.merge(((CoreException)e).getStatus());
            } else {
                Status status = new Status(4, pluginId, 2, message, e);
            }
            e.printStackTrace();
        }
        code.handleException(e);
    }
}

