/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;

public class BrowserFunction {
    Browser browser;
    String name;
    boolean disposed;

    public BrowserFunction(Browser browser, String name) {
        this(browser, name, true);
    }

    BrowserFunction(Browser browser, String name, boolean create) {
        if (browser == null) {
            SWT.error(4);
        }
        if (name == null) {
            SWT.error(4);
        }
        if (browser.isDisposed()) {
            SWT.error(24);
        }
        browser.checkWidget();
        this.browser = browser;
        this.browser.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent event) {
                BrowserFunction.this.dispose(false);
            }
        });
        this.name = name;
        if (create) {
            browser.createFunction(this);
        }
    }

    public void dispose() {
        this.dispose(true);
    }

    void dispose(boolean remove) {
        if (!this.disposed) {
            if (remove) {
                this.browser.destroyFunction(this);
            }
            this.browser = null;
            this.name = null;
            this.disposed = true;
        }
    }

    public Object function(Object[] arguments) {
        if (this.disposed) {
            SWT.error(49);
        }
        this.browser.checkWidget();
        return null;
    }

    public Browser getBrowser() {
        if (this.disposed) {
            SWT.error(49);
        }
        this.browser.checkWidget();
        return this.browser;
    }

    public String getName() {
        if (this.disposed) {
            SWT.error(49);
        }
        this.browser.checkWidget();
        return this.name;
    }

    public boolean isDisposed() {
        return this.disposed;
    }
}

