/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.serverpush;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.rap.rwt.SingletonUtil;
import org.eclipse.rap.rwt.internal.serverpush.ServerPushActivationTracker;
import org.eclipse.rap.rwt.internal.serverpush.ServerPushRequestTracker;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.ServiceStore;
import org.eclipse.rap.rwt.internal.util.SerializableLock;
import org.eclipse.rap.rwt.service.UISession;
import org.eclipse.rap.rwt.service.UISessionEvent;
import org.eclipse.rap.rwt.service.UISessionListener;
import org.eclipse.swt.internal.SerializableCompatibility;

public final class ServerPushManager
implements SerializableCompatibility {
    private static final int DEFAULT_REQUEST_CHECK_INTERVAL = 30000;
    private static final String FORCE_PUSH = String.valueOf(ServerPushManager.class.getName()) + "#forcePush";
    private final ServerPushActivationTracker serverPushActivationTracker;
    private final SerializableLock lock = new SerializableLock();
    private boolean uiThreadRunning = false;
    private boolean hasRunnables;
    private int requestCheckInterval = 30000;
    private transient ServerPushRequestTracker serverPushRequestTracker;

    private ServerPushManager() {
        this.serverPushActivationTracker = new ServerPushActivationTracker();
        this.serverPushRequestTracker = new ServerPushRequestTracker();
    }

    public static ServerPushManager getInstance() {
        return SingletonUtil.getSessionInstance(ServerPushManager.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCallBackRequestBlocked() {
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            return !this.serverPushRequestTracker.hasActive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeClient() {
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            if (!this.uiThreadRunning) {
                this.releaseBlockedRequest();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseBlockedRequest() {
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHasRunnables(boolean hasRunnables) {
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            this.hasRunnables = hasRunnables;
        }
        ServiceStore serviceStore = ContextProvider.getServiceStore();
        if (serviceStore != null && hasRunnables && this.isServerPushActive()) {
            serviceStore.setAttribute(FORCE_PUSH, Boolean.TRUE);
        }
    }

    public void setRequestCheckInterval(int requestCheckInterval) {
        this.requestCheckInterval = requestCheckInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyUIThreadStart() {
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            this.uiThreadRunning = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyUIThreadEnd() {
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            this.uiThreadRunning = false;
            if (this.hasRunnables) {
                this.wakeClient();
            }
        }
    }

    public void activateServerPushFor(Object handle) {
        this.serverPushActivationTracker.activate(handle);
    }

    public void deactivateServerPushFor(Object handle) {
        this.serverPushActivationTracker.deactivate(handle);
        if (!this.serverPushActivationTracker.isActive()) {
            this.releaseBlockedRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRunnables() {
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            return this.hasRunnables;
        }
    }

    public boolean needsActivation() {
        return this.isServerPushActive() || ServerPushManager.forceServerPushForPendingRunnables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processRequest(HttpServletResponse response) {
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            block11: {
                if (this.isCallBackRequestBlocked()) {
                    this.releaseBlockedRequest();
                }
                if (this.mustBlockCallBackRequest()) {
                    long requestStartTime = System.currentTimeMillis();
                    this.serverPushRequestTracker.activate(Thread.currentThread());
                    TerminationListener listener = ServerPushManager.attachTerminationListener();
                    try {
                        try {
                            boolean canRelease = false;
                            while (!canRelease) {
                                this.lock.wait(this.requestCheckInterval);
                                canRelease = this.canReleaseBlockedRequest(response, requestStartTime);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.interrupted();
                            listener.detach();
                            this.serverPushRequestTracker.deactivate(Thread.currentThread());
                            break block11;
                        }
                    }
                    catch (Throwable throwable) {
                        listener.detach();
                        this.serverPushRequestTracker.deactivate(Thread.currentThread());
                        throw throwable;
                    }
                    listener.detach();
                    this.serverPushRequestTracker.deactivate(Thread.currentThread());
                }
            }
        }
    }

    private boolean canReleaseBlockedRequest(HttpServletResponse response, long requestStartTime) {
        boolean result = false;
        if (!this.mustBlockCallBackRequest()) {
            result = true;
        } else if (ServerPushManager.isSessionExpired(requestStartTime)) {
            result = true;
        } else if (!ServerPushManager.isConnectionAlive(response)) {
            result = true;
        } else if (!this.serverPushRequestTracker.isActive(Thread.currentThread())) {
            result = true;
        }
        return result;
    }

    boolean mustBlockCallBackRequest() {
        return this.isServerPushActive() && !this.hasRunnables;
    }

    public boolean isServerPushActive() {
        return this.serverPushActivationTracker.isActive();
    }

    private Object readResolve() {
        this.serverPushRequestTracker = new ServerPushRequestTracker();
        return this;
    }

    private static TerminationListener attachTerminationListener() {
        UISession uiSession = ContextProvider.getUISession();
        TerminationListener result = new TerminationListener(uiSession);
        result.attach();
        return result;
    }

    private static boolean isSessionExpired(long requestStartTime) {
        return ServerPushManager.isSessionExpired(requestStartTime, System.currentTimeMillis());
    }

    static boolean isSessionExpired(long requestStartTime, long currentTime) {
        UISession uiSession = ContextProvider.getUISession();
        if (uiSession == null) {
            return true;
        }
        HttpSession httpSession = uiSession.getHttpSession();
        int maxInactiveInterval = httpSession.getMaxInactiveInterval();
        if (maxInactiveInterval > 0) {
            return currentTime > requestStartTime + (long)(maxInactiveInterval * 1000);
        }
        return false;
    }

    private static boolean isConnectionAlive(HttpServletResponse response) {
        try {
            PrintWriter writer = response.getWriter();
            writer.write(" ");
            return !writer.checkError();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static boolean forceServerPushForPendingRunnables() {
        boolean result = false;
        ServiceStore serviceStore = ContextProvider.getServiceStore();
        if (serviceStore != null) {
            result = Boolean.TRUE.equals(serviceStore.getAttribute(FORCE_PUSH));
        }
        return result;
    }

    private static class TerminationListener
    implements UISessionListener {
        private final transient Thread currentThread;
        private final transient UISession uiSession;

        private TerminationListener(UISession uiSession) {
            this.uiSession = uiSession;
            this.currentThread = Thread.currentThread();
        }

        public void attach() {
            this.uiSession.addUISessionListener(this);
        }

        public void detach() {
            this.uiSession.removeUISessionListener(this);
        }

        @Override
        public void beforeDestroy(UISessionEvent event) {
            this.currentThread.interrupt();
        }
    }
}

