/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.application;

import javax.servlet.ServletContext;
import org.eclipse.rap.rwt.application.ApplicationConfiguration;
import org.eclipse.rap.rwt.internal.SingletonManager;
import org.eclipse.rap.rwt.internal.application.ApplicationContextImpl;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.rap.rwt.service.ApplicationContext;

public class ApplicationRunner {
    public static final String RESOURCES = "rwt-resources";
    private final ApplicationContextImpl applicationContext;

    public ApplicationRunner(ApplicationConfiguration configuration, ServletContext servletContext) {
        ParamCheck.notNull(configuration, "configuration");
        ParamCheck.notNull(servletContext, "servletContext");
        this.applicationContext = new ApplicationContextImpl(configuration, servletContext);
    }

    public void start() {
        this.applicationContext.attachToServletContext();
        SingletonManager.install(this.applicationContext);
        try {
            this.applicationContext.activate();
        }
        catch (RuntimeException rte) {
            this.applicationContext.removeFromServletContext();
            throw rte;
        }
    }

    public void stop() {
        try {
            this.applicationContext.deactivate();
        }
        finally {
            this.applicationContext.removeFromServletContext();
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext.isActive() ? this.applicationContext : null;
    }
}

