/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools.model.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.jpa.jpql.parser.UpdateClause;
import org.eclipse.persistence.jpa.jpql.tools.model.IListChangeListener;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AbstractModifyClauseStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.ListHolderStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObjectVisitor;
import org.eclipse.persistence.jpa.jpql.tools.model.query.UpdateItemStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.UpdateStatementStateObject;
import org.eclipse.persistence.jpa.jpql.utility.iterable.ListIterable;
import org.eclipse.persistence.jpa.jpql.utility.iterable.SnapshotCloneListIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateClauseStateObject
extends AbstractModifyClauseStateObject
implements ListHolderStateObject<UpdateItemStateObject> {
    private List<UpdateItemStateObject> items;
    public static final String UPDATE_ITEMS_LIST = "items";

    public UpdateClauseStateObject(UpdateStatementStateObject parent) {
        super(parent);
    }

    @Override
    public void accept(StateObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void addChildren(List<StateObject> children) {
        super.addChildren(children);
        children.addAll(this.items);
    }

    public UpdateItemStateObject addItem() {
        UpdateItemStateObject updateItem = new UpdateItemStateObject(this);
        this.addItem(updateItem);
        return updateItem;
    }

    public UpdateItemStateObject addItem(ListIterator<String> paths, StateObject newValue) {
        UpdateItemStateObject updateItem = new UpdateItemStateObject(this);
        updateItem.setPaths(paths);
        updateItem.setNewValue(newValue);
        this.addItem(updateItem);
        return updateItem;
    }

    public UpdateItemStateObject addItem(ListIterator<String> paths, String newValue) {
        UpdateItemStateObject updateItem = new UpdateItemStateObject(this);
        updateItem.setPaths(paths);
        updateItem.parseNewValue(newValue);
        this.addItem(updateItem);
        return updateItem;
    }

    @Override
    public UpdateItemStateObject addItem(String path) {
        UpdateItemStateObject updateItem = new UpdateItemStateObject(this);
        updateItem.setPath(path);
        this.addItem(updateItem);
        return updateItem;
    }

    public UpdateItemStateObject addItem(String path, StateObject newValue) {
        UpdateItemStateObject updateItem = new UpdateItemStateObject(this);
        updateItem.setPath(path);
        updateItem.setNewValue(newValue);
        this.addItem(updateItem);
        return updateItem;
    }

    public UpdateItemStateObject addItem(String path, String newValue) {
        UpdateItemStateObject updateItem = new UpdateItemStateObject(this);
        updateItem.setPath(path);
        updateItem.parseNewValue(newValue);
        this.addItem(updateItem);
        return updateItem;
    }

    public UpdateItemStateObject addItem(String[] paths, StateObject newValue) {
        UpdateItemStateObject updateItem = new UpdateItemStateObject(this);
        updateItem.setPaths(paths);
        updateItem.setNewValue(newValue);
        this.addItem(updateItem);
        return updateItem;
    }

    public UpdateItemStateObject addItem(String[] paths, String newValue) {
        UpdateItemStateObject updateItem = new UpdateItemStateObject(this);
        updateItem.setPaths(paths);
        updateItem.parseNewValue(newValue);
        this.addItem(updateItem);
        return updateItem;
    }

    @Override
    public UpdateItemStateObject addItem(UpdateItemStateObject item) {
        this.getChangeSupport().addItem(this, this.items, UPDATE_ITEMS_LIST, this.parent(item));
        return item;
    }

    @Override
    public void addItems(List<? extends UpdateItemStateObject> items) {
        this.getChangeSupport().addItems(this, this.items, UPDATE_ITEMS_LIST, this.parent(items));
    }

    @Override
    public void addListChangeListener(String listName, IListChangeListener<UpdateItemStateObject> listener) {
        this.getChangeSupport().addListChangeListener(listName, listener);
    }

    protected boolean areChildrenEquivalent(UpdateClauseStateObject stateObject) {
        int size = this.itemsSize();
        if (size != stateObject.itemsSize()) {
            return false;
        }
        int index = size;
        while (--index >= 0) {
            UpdateItemStateObject child2;
            UpdateItemStateObject child1 = this.getItem(index);
            if (child1.isEquivalent(child2 = stateObject.getItem(index))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canMoveDown(UpdateItemStateObject item) {
        return this.getChangeSupport().canMoveDown(this.items, item);
    }

    @Override
    public boolean canMoveUp(UpdateItemStateObject item) {
        return this.getChangeSupport().canMoveUp(this.items, item);
    }

    @Override
    public UpdateClause getExpression() {
        return (UpdateClause)super.getExpression();
    }

    @Override
    public String getIdentifier() {
        return "UPDATE";
    }

    @Override
    public UpdateItemStateObject getItem(int index) {
        return this.items.get(index);
    }

    @Override
    public UpdateStatementStateObject getParent() {
        return (UpdateStatementStateObject)super.getParent();
    }

    @Override
    public boolean hasItems() {
        return !this.items.isEmpty();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.items = new ArrayList<UpdateItemStateObject>();
    }

    @Override
    public boolean isEquivalent(StateObject stateObject) {
        return super.isEquivalent(stateObject) && this.areChildrenEquivalent((UpdateClauseStateObject)stateObject);
    }

    public boolean isIdentificationVariableDefined() {
        return !this.getIdentificationVariableStateObject().isVirtual();
    }

    @Override
    public ListIterable<UpdateItemStateObject> items() {
        return new SnapshotCloneListIterable<UpdateItemStateObject>(this.items);
    }

    @Override
    public int itemsSize() {
        return this.items.size();
    }

    @Override
    public UpdateItemStateObject moveDown(UpdateItemStateObject item) {
        this.getChangeSupport().moveDown(this, this.items, UPDATE_ITEMS_LIST, item);
        return item;
    }

    @Override
    public UpdateItemStateObject moveUp(UpdateItemStateObject item) {
        this.getChangeSupport().moveUp(this, this.items, UPDATE_ITEMS_LIST, item);
        return item;
    }

    public void parse(String jpqlFragment) {
        UpdateItemStateObject stateObject = (UpdateItemStateObject)this.buildStateObject(jpqlFragment, "update_item*");
        this.addItem(stateObject);
    }

    @Override
    public void removeItem(UpdateItemStateObject stateObject) {
        this.getChangeSupport().removeItem(this, this.items, UPDATE_ITEMS_LIST, stateObject);
    }

    @Override
    public void removeItems(Collection<UpdateItemStateObject> items) {
        this.getChangeSupport().removeItems(this, this.items, UPDATE_ITEMS_LIST, items);
    }

    @Override
    public void removeListChangeListener(String listName, IListChangeListener<UpdateItemStateObject> listener) {
        this.getChangeSupport().removeListChangeListener(listName, listener);
    }

    public void setExpression(UpdateClause expression) {
        super.setExpression(expression);
    }

    @Override
    protected void toTextInternal(Appendable writer) throws IOException {
        super.toTextInternal(writer);
        writer.append(' ');
        writer.append("SET");
        writer.append(' ');
        this.toStringItems(writer, this.items, true);
    }
}

