/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.remoteserviceadmin;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.Activator;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.LogUtility;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.PropertiesUtil;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EndpointDescription;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.IEndpointDescriptionAdvertiser;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.EndpointListener;
import org.osgi.service.remoteserviceadmin.ImportRegistration;
import org.osgi.util.tracker.ServiceTracker;

public abstract class AbstractTopologyManager {
    public static final String SERVICE_EXPORTED_INTERFACES_WILDCARD = "*";
    private BundleContext context;
    private ServiceTracker endpointDescriptionAdvertiserTracker;
    private Object endpointDescriptionAdvertiserTrackerLock = new Object();
    private ServiceTracker remoteServiceAdminTracker;
    private Object remoteServiceAdminTrackerLock = new Object();

    public AbstractTopologyManager(BundleContext context) {
        this.context = context;
    }

    protected BundleContext getContext() {
        return this.context;
    }

    protected String getFrameworkUUID() {
        Activator a = Activator.getDefault();
        if (a == null) {
            return null;
        }
        return a.getFrameworkUUID();
    }

    protected IEndpointDescriptionAdvertiser getEndpointDescriptionAdvertiser(org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription) {
        IEndpointDescriptionAdvertiser advertiser = AccessController.doPrivileged(new PrivilegedAction<IEndpointDescriptionAdvertiser>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IEndpointDescriptionAdvertiser run() {
                Object object = AbstractTopologyManager.this.endpointDescriptionAdvertiserTrackerLock;
                synchronized (object) {
                    if (AbstractTopologyManager.this.endpointDescriptionAdvertiserTracker == null) {
                        AbstractTopologyManager.this.endpointDescriptionAdvertiserTracker = new ServiceTracker(AbstractTopologyManager.this.getContext(), IEndpointDescriptionAdvertiser.class.getName(), null);
                        AbstractTopologyManager.this.endpointDescriptionAdvertiserTracker.open();
                    }
                }
                return (IEndpointDescriptionAdvertiser)AbstractTopologyManager.this.endpointDescriptionAdvertiserTracker.getService();
            }
        });
        if (advertiser == null) {
            this.logWarning("handleOSGiEndpointAdded", "No endpoint description advertiser available for endpointDescription=" + endpointDescription);
        }
        return advertiser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.endpointDescriptionAdvertiserTrackerLock;
        synchronized (object) {
            if (this.endpointDescriptionAdvertiserTracker != null) {
                this.endpointDescriptionAdvertiserTracker.close();
                this.endpointDescriptionAdvertiserTracker = null;
            }
        }
        object = this.remoteServiceAdminTrackerLock;
        synchronized (object) {
            if (this.remoteServiceAdminTracker != null) {
                this.remoteServiceAdminTracker.close();
                this.remoteServiceAdminTracker = null;
            }
        }
        this.context = null;
    }

    protected void logWarning(String methodName, String message) {
        LogUtility.logWarning(methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/topologymanager", this.getClass(), message);
    }

    protected Filter createRSAFilter() {
        String filterString = "(&(objectClass=" + org.osgi.service.remoteserviceadmin.RemoteServiceAdmin.class.getName() + ")(" + "org.eclipse.ecf.rsa" + "=*))";
        try {
            return this.getContext().createFilter(filterString);
        }
        catch (InvalidSyntaxException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected org.osgi.service.remoteserviceadmin.RemoteServiceAdmin getRemoteServiceAdmin() {
        Object object = this.remoteServiceAdminTrackerLock;
        synchronized (object) {
            if (this.remoteServiceAdminTracker == null) {
                this.remoteServiceAdminTracker = new ServiceTracker(Activator.getContext(), this.createRSAFilter(), null);
                this.remoteServiceAdminTracker.open();
            }
        }
        return (org.osgi.service.remoteserviceadmin.RemoteServiceAdmin)this.remoteServiceAdminTracker.getService();
    }

    protected void advertiseEndpointDescription(org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription) {
        IEndpointDescriptionAdvertiser advertiser = this.getEndpointDescriptionAdvertiser(endpointDescription);
        if (advertiser != null) {
            this.trace("advertiseEndpointDescription", "advertising endpointDescription=" + endpointDescription + " with advertiser=" + advertiser);
            this.handleAdvertisingResult(advertiser.advertise(endpointDescription), endpointDescription, true);
        }
    }

    protected void unadvertiseEndpointDescription(org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription) {
        IEndpointDescriptionAdvertiser advertiser = this.getEndpointDescriptionAdvertiser(endpointDescription);
        if (advertiser != null) {
            this.trace("unadvertiseEndpointDescription", "unadvertising endpointDescription=" + endpointDescription + " with advertiser=" + advertiser);
            this.handleAdvertisingResult(advertiser.unadvertise(endpointDescription), endpointDescription, false);
        }
    }

    protected void advertiseEndpointDescription(EndpointDescription endpointDescription) {
        IEndpointDescriptionAdvertiser advertiser = this.getEndpointDescriptionAdvertiser(endpointDescription);
        if (advertiser != null) {
            this.trace("advertiseEndpointDescription", "advertising endpointDescription=" + (Object)((Object)endpointDescription) + " with advertiser=" + advertiser);
            this.handleAdvertisingResult(advertiser.advertise(endpointDescription), endpointDescription, true);
        }
    }

    protected void unadvertiseEndpointDescription(EndpointDescription endpointDescription) {
        IEndpointDescriptionAdvertiser advertiser = this.getEndpointDescriptionAdvertiser(endpointDescription);
        if (advertiser != null) {
            this.trace("unadvertiseEndpointDescription", "unadvertising endpointDescription=" + (Object)((Object)endpointDescription) + " with advertiser=" + advertiser);
            this.handleAdvertisingResult(advertiser.unadvertise(endpointDescription), endpointDescription, false);
        }
    }

    protected void logError(String methodName, String message, Throwable exception) {
        LogUtility.logError(methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/topologymanager", this.getClass(), message, exception);
    }

    protected void logError(String methodName, String message, IStatus result) {
        LogUtility.logError(methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/topologymanager", this.getClass(), result);
    }

    protected void trace(String methodName, String message) {
        LogUtility.trace(methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/topologymanager", this.getClass(), message);
    }

    protected void logError(String methodName, String message) {
        LogUtility.logError(methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/topologymanager", this.getClass(), message);
    }

    protected void handleECFEndpointAdded(EndpointDescription endpointDescription) {
        this.trace("handleEndpointAdded", "endpointDescription=" + (Object)((Object)endpointDescription));
        this.getRemoteServiceAdmin().importService((org.osgi.service.remoteserviceadmin.EndpointDescription)endpointDescription);
    }

    protected void handleECFEndpointRemoved(org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription) {
        this.trace("handleEndpointRemoved", "endpointDescription=" + endpointDescription);
        RemoteServiceAdmin rsa = (RemoteServiceAdmin)this.getRemoteServiceAdmin();
        List<RemoteServiceAdmin.ImportRegistration> importedRegistrations = rsa.getImportedRegistrations();
        EndpointDescription ed = (EndpointDescription)endpointDescription;
        for (RemoteServiceAdmin.ImportRegistration importedRegistration : importedRegistrations) {
            if (!importedRegistration.match(ed)) continue;
            this.trace("handleEndpointRemoved", "closing importedRegistration=" + importedRegistration);
            importedRegistration.close();
        }
    }

    private String isInterested(Object scopeobj, org.osgi.service.remoteserviceadmin.EndpointDescription description) {
        block5: {
            block6: {
                String[] scope;
                block4: {
                    if (!(scopeobj instanceof List)) break block4;
                    List scope2 = (List)scopeobj;
                    for (String filter : scope2) {
                        if (!description.matches(filter)) continue;
                        return filter;
                    }
                    break block5;
                }
                if (!(scopeobj instanceof String[])) break block6;
                String[] stringArray = scope = (String[])scopeobj;
                int n = scope.length;
                int n2 = 0;
                while (n2 < n) {
                    String filter = stringArray[n2];
                    if (description.matches(filter)) {
                        return filter;
                    }
                    ++n2;
                }
                break block5;
            }
            if (!(scopeobj instanceof String)) break block5;
            StringTokenizer st = new StringTokenizer((String)scopeobj, " ");
            while (st.hasMoreTokens()) {
                String filter = st.nextToken();
                if (!description.matches(filter)) continue;
                return filter;
            }
        }
        return null;
    }

    private void notifyOtherEndpointListeners(EndpointListener exceptEndpointListener, org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription, boolean added) {
        ServiceReference[] listeners = null;
        try {
            listeners = this.context.getServiceReferences(EndpointListener.class.getName(), "(endpoint.listener.scope=*)");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        if (listeners != null) {
            int i = 0;
            while (i < listeners.length) {
                Object scope;
                String matchedFilter;
                EndpointListener listener = (EndpointListener)this.getContext().getService(listeners[i]);
                if (listener != exceptEndpointListener && (matchedFilter = this.isInterested(scope = listeners[i].getProperty("endpoint.listener.scope"), endpointDescription)) != null) {
                    if (added) {
                        listener.endpointAdded(endpointDescription, matchedFilter);
                    } else {
                        listener.endpointRemoved(endpointDescription, matchedFilter);
                    }
                }
                ++i;
            }
        }
    }

    protected void handleNonECFEndpointAdded(EndpointListener listener, org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription) {
        this.notifyOtherEndpointListeners(listener, endpointDescription, true);
    }

    protected void handleNonECFEndpointRemoved(EndpointListener listener, org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription) {
        this.notifyOtherEndpointListeners(listener, endpointDescription, false);
    }

    protected void handleNonECFEndpointRemoved(org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription, String matchedFilter) {
        this.advertiseEndpointDescription(endpointDescription);
    }

    protected void handleAdvertisingResult(IStatus result, org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription, boolean advertise) {
        if (!result.isOK()) {
            this.logError("handleAdvertisingResult", String.valueOf(advertise ? "Advertise" : "Unadvertise") + " of endpointDescription=" + endpointDescription + " FAILED", result);
        }
    }

    protected void handleInvalidImportRegistration(ImportRegistration importRegistration, Throwable t) {
        this.logError("handleInvalidImportRegistration", "importRegistration=" + importRegistration, t);
    }

    protected void handleEvent(ServiceEvent event, Map listeners) {
        switch (event.getType()) {
            case 2: {
                this.handleServiceModifying(event.getServiceReference());
                break;
            }
            case 1: {
                this.handleServiceRegistering(event.getServiceReference());
                break;
            }
        }
    }

    protected void handleServiceRegistering(ServiceReference serviceReference) {
        String[] exportedInterfaces = PropertiesUtil.getExportedInterfaces(serviceReference);
        if (exportedInterfaces == null) {
            return;
        }
        TreeMap<String, String[]> exportProperties = new TreeMap<String, String[]>(String.CASE_INSENSITIVE_ORDER);
        exportProperties.put("service.exported.interfaces", exportedInterfaces);
        this.trace("handleServiceRegistering", "serviceReference=" + serviceReference + " exportProperties=" + exportProperties);
        this.getRemoteServiceAdmin().exportService(serviceReference, exportProperties);
    }

    protected void handleServiceModifying(ServiceReference serviceReference) {
        this.logWarning("handleServiceModifying", "serviceReference=" + serviceReference + " modified with no response");
    }

    protected void handleServiceUnregistering(ServiceReference serviceReference) {
        List<RemoteServiceAdmin.ExportRegistration> exportedRegistrations = ((RemoteServiceAdmin)this.getRemoteServiceAdmin()).getExportedRegistrations();
        for (RemoteServiceAdmin.ExportRegistration exportedRegistration : exportedRegistrations) {
            if (!exportedRegistration.match(serviceReference)) continue;
            this.trace("handleServiceUnregistering", "closing exportRegistration for serviceReference=" + serviceReference);
            exportedRegistration.close();
        }
    }
}

