/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.tests.serialization.robustness;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.FeatureNotFoundException;
import org.eclipse.rmf.tests.serialization.model.nodes.Node;
import org.eclipse.rmf.tests.serialization.model.nodes.NodesPackage;
import org.eclipse.rmf.tests.serialization.util.AbstractTestCase;
import org.eclipse.rmf.tests.serialization.util.LoadSaveUtil;
import org.eclipse.sphinx.emf.serialization.XMLPersistenceMappingResourceFactoryImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LoadPatternAttribute0100RobustnessTests
extends AbstractTestCase {
    static final String INPUT_PATH = "org.eclipse.rmf.tests.serialization.robustness/";

    @Before
    public void setUp() throws Exception {
        super.setUp();
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/rmf/serialization/model/nodes.ecore", (Object)NodesPackage.eINSTANCE);
    }

    @Test
    public void testEAttribute_Attribute0100_Single_NestedElements() {
        String inputFileName = "org.eclipse.rmf.tests.serialization.robustness/EAttribute_Attribute0100Single_NestedElements.xml";
        try {
            Resource resource = LoadSaveUtil.loadResource("resources/input/" + inputFileName, (ResourceFactoryImpl)new XMLPersistenceMappingResourceFactoryImpl(), null);
            Assert.assertSame((Object)1, (Object)resource.getErrors().size());
            Assert.assertTrue((boolean)(resource.getErrors().get(0) instanceof FeatureNotFoundException));
            this.validateEAttributeSingle(resource, (EStructuralFeature)NodesPackage.eINSTANCE.getNode_EAttribute_Attribute0100Single(), (EStructuralFeature)NodesPackage.eINSTANCE.getNode_EAttribute_Attribute1100Single());
        }
        catch (Exception ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    @Test
    public void testEAttribute_Attribute0100_Many_NestedElements() {
        String inputFileName = "org.eclipse.rmf.tests.serialization.robustness/EAttribute_Attribute0100Many_NestedElements.xml";
        try {
            Resource resource = LoadSaveUtil.loadResource("resources/input/" + inputFileName, (ResourceFactoryImpl)new XMLPersistenceMappingResourceFactoryImpl(), null);
            Assert.assertSame((Object)1, (Object)resource.getErrors().size());
            Assert.assertTrue((boolean)(resource.getErrors().get(0) instanceof FeatureNotFoundException));
            this.validateEAttributeSingle(resource, (EStructuralFeature)NodesPackage.eINSTANCE.getNode_EAttribute_Attribute0100Many(), (EStructuralFeature)NodesPackage.eINSTANCE.getNode_EAttribute_Attribute1100Many());
        }
        catch (Exception ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    protected void validateEAttributeSingle(Resource resource, EStructuralFeature badFeature, EStructuralFeature goodFeature) {
        Assert.assertNotNull((Object)resource);
        Assert.assertSame((Object)1, (Object)resource.getContents().size());
        EObject object = (EObject)resource.getContents().get(0);
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode(), (Object)object.eClass());
        Node node = (Node)object;
        Assert.assertFalse((boolean)node.eIsSet(badFeature));
        Assert.assertTrue((boolean)node.eIsSet(goodFeature));
        if (goodFeature.isMany()) {
            Assert.assertEquals((Object)"value2", (Object)((EList)node.eGet(goodFeature)).get(0));
        } else {
            Assert.assertEquals((Object)"value2", (Object)node.eGet(goodFeature));
        }
    }
}

