/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.xhtml;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ScopeType implements Enumerator
{
    ROW(0, "row", "row"),
    COL(1, "col", "col"),
    ROWGROUP(2, "rowgroup", "rowgroup"),
    COLGROUP(3, "colgroup", "colgroup");

    public static final int ROW_VALUE = 0;
    public static final int COL_VALUE = 1;
    public static final int ROWGROUP_VALUE = 2;
    public static final int COLGROUP_VALUE = 3;
    private static final ScopeType[] VALUES_ARRAY;
    public static final List<ScopeType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ScopeType[]{ROW, COL, ROWGROUP, COLGROUP};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ScopeType get(String literal) {
        ScopeType[] scopeTypeArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            ScopeType result = scopeTypeArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static ScopeType getByName(String name) {
        ScopeType[] scopeTypeArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            ScopeType result = scopeTypeArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static ScopeType get(int value) {
        switch (value) {
            case 0: {
                return ROW;
            }
            case 1: {
                return COL;
            }
            case 2: {
                return ROWGROUP;
            }
            case 3: {
                return COLGROUP;
            }
        }
        return null;
    }

    private ScopeType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

