/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.tests.reqif10.serialization.uc005;

import java.math.BigInteger;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rmf.reqif10.AttributeDefinitionEnumeration;
import org.eclipse.rmf.reqif10.AttributeDefinitionString;
import org.eclipse.rmf.reqif10.AttributeDefinitionXHTML;
import org.eclipse.rmf.reqif10.AttributeValueEnumeration;
import org.eclipse.rmf.reqif10.AttributeValueString;
import org.eclipse.rmf.reqif10.AttributeValueXHTML;
import org.eclipse.rmf.reqif10.DatatypeDefinitionEnumeration;
import org.eclipse.rmf.reqif10.DatatypeDefinitionString;
import org.eclipse.rmf.reqif10.DatatypeDefinitionXHTML;
import org.eclipse.rmf.reqif10.EmbeddedValue;
import org.eclipse.rmf.reqif10.EnumValue;
import org.eclipse.rmf.reqif10.ReqIF10Factory;
import org.eclipse.rmf.reqif10.SpecHierarchy;
import org.eclipse.rmf.reqif10.SpecObject;
import org.eclipse.rmf.reqif10.SpecObjectType;
import org.eclipse.rmf.reqif10.Specification;
import org.eclipse.rmf.reqif10.SpecificationType;
import org.eclipse.rmf.reqif10.XhtmlContent;
import org.eclipse.rmf.tests.reqif10.serialization.uc004.ReqifTool;
import org.eclipse.rmf.tests.reqif10.serialization.util.SimpleModelBuilder;

public class RoundtripFilteringModelBuilder
extends SimpleModelBuilder {
    private static final ReqIF10Factory factory = ReqIF10Factory.eINSTANCE;
    private static GregorianCalendar DATE = new GregorianCalendar(2014, 1, 1);
    private DatatypeDefinitionXHTML t_comment;
    private DatatypeDefinitionEnumeration t_statusOEM;
    private DatatypeDefinitionEnumeration t_statusSupplier;
    private DatatypeDefinitionString t_foreignId;
    private DatatypeDefinitionXHTML t_text;
    private DatatypeDefinitionEnumeration t_variant;
    private AttributeDefinitionString ad_foreignId;
    private AttributeDefinitionXHTML ad_text;
    private Map<ReqifTool, AttributeDefinitionEnumeration> ad_oemStatus = new HashMap<ReqifTool, AttributeDefinitionEnumeration>();
    private Map<ReqifTool, AttributeDefinitionXHTML> ad_oemComment = new HashMap<ReqifTool, AttributeDefinitionXHTML>();
    private SpecObjectType specObjecttype;
    private SpecificationType specType;
    private AttributeDefinitionEnumeration ad_variant;
    private AttributeDefinitionXHTML ad_internal;

    public RoundtripFilteringModelBuilder() throws Exception {
        super("multiple-supplier-test", "Roundtrip Filtering Test");
        this.getReqIF().getTheHeader().setCreationTime(DATE);
    }

    @Override
    public void createDatatypes() throws Exception {
        this.createDatatypeComment();
        this.createDatatypeText();
        this.createDatatypeForeignId();
        this.createDatatypeStatusOEM();
        this.createDatatypeStatusSupplier();
        this.createDatatypeVariant();
    }

    @Override
    public void createSpecObjectTypes() throws Exception {
        this.specObjecttype = factory.createSpecObjectType();
        this.specObjecttype.setIdentifier("RequirementType");
        this.specObjecttype.setLastChange(DATE);
        this.specObjecttype.setLongName("RequirementType");
        this.createForeignIdDefinition();
        this.createTextDefinition();
        this.createVariantDefinition();
        this.createInternalDefinition();
        this.getReqIF().getCoreContent().getSpecTypes().add((Object)this.specObjecttype);
        ReqifTool[] reqifToolArray = ReqifTool.values();
        int n = reqifToolArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReqifTool tool = reqifToolArray[n2];
            if (tool != ReqifTool.ALL_TOOLS) {
                this.createSpecObjectTypes(tool);
            }
            ++n2;
        }
    }

    @Override
    public void createSpecObjects() throws Exception {
        this.createSpecObject("REQ-1", "Steering Wheel Spec", 7, null);
        this.createSpecObject("REQ-2", "The diameter of the steering wheel must be 320mm", 7, "320mm is optimal according to our newest top secret study");
        this.createSpecObject("REQ-3", "The steering wheel will have an airbag. Carry-Over-Part Nr: 0012.444.WHL.AB", 7, null);
        this.createSpecObject("REQ-4", "The rim cover has to be constructed out of plastics", 1, "Supplier xy fails to reach the quality we need");
        this.createSpecObject("REQ-5", "The rim cover must be a leather wrapping", 2, null);
        this.createSpecObject("REQ-6", "The rim cover must be a leather wrapping and wooden veener on top and bottom", 4, null);
        this.createSpecObject("REQ-7", "Audio and display functions must be controllable via buttons on the steering wheel", 6, null);
    }

    private void createSpecObject(String id, String desc, int variant, String internalKnowHow) throws Exception {
        SpecObject obj = factory.createSpecObject();
        obj.setIdentifier(id);
        obj.setLongName("SpecObject " + id);
        obj.setLastChange(DATE);
        obj.setType(this.specObjecttype);
        this.getReqIF().getCoreContent().getSpecObjects().add((Object)obj);
        AttributeValueString foreignId = factory.createAttributeValueString();
        foreignId.setDefinition(this.ad_foreignId);
        foreignId.setTheValue(id);
        obj.getValues().add((Object)foreignId);
        AttributeValueXHTML text = factory.createAttributeValueXHTML();
        text.setDefinition(this.ad_text);
        XhtmlContent content = SimpleModelBuilder.createXhtmlValue(desc);
        text.setTheValue(content);
        obj.getValues().add((Object)text);
        if (internalKnowHow != null) {
            AttributeValueXHTML internal = factory.createAttributeValueXHTML();
            internal.setDefinition(this.ad_internal);
            content = SimpleModelBuilder.createXhtmlValue(internalKnowHow);
            internal.setTheValue(content);
            obj.getValues().add((Object)internal);
        }
        AttributeValueEnumeration v = factory.createAttributeValueEnumeration();
        v.setDefinition(this.ad_variant);
        obj.getValues().add((Object)v);
        int i = 0;
        while (i < 3) {
            int bit = variant >> i & 1;
            if (bit == 1) {
                v.getValues().add((Object)((EnumValue)this.t_variant.getSpecifiedValues().get(i)));
            }
            ++i;
        }
    }

    @Override
    public void createSpecifications() throws Exception {
        Specification spec = factory.createSpecification();
        spec.setIdentifier("specification");
        spec.setLongName("specification");
        spec.setLastChange(DATE);
        spec.setType(this.specType);
        this.getReqIF().getCoreContent().getSpecifications().add((Object)spec);
        for (SpecObject object : this.getReqIF().getCoreContent().getSpecObjects()) {
            SpecHierarchy sh = factory.createSpecHierarchy();
            sh.setObject(object);
            sh.setIdentifier("sh-" + object.getIdentifier());
            sh.setLongName("sh-" + object.getIdentifier());
            sh.setLastChange(DATE);
            spec.getChildren().add((Object)sh);
        }
    }

    private void createDatatypeComment() throws Exception {
        this.t_comment = factory.createDatatypeDefinitionXHTML();
        this.t_comment.setLongName("T_Comment");
        this.t_comment.setIdentifier("T_Comment");
        this.t_comment.setLastChange(DATE);
        this.getReqIF().getCoreContent().getDatatypes().add((Object)this.t_comment);
    }

    private void createDatatypeText() throws Exception {
        this.t_text = factory.createDatatypeDefinitionXHTML();
        this.t_text.setLongName("T_Text");
        this.t_text.setIdentifier("T_Text");
        this.t_text.setLastChange(DATE);
        this.getReqIF().getCoreContent().getDatatypes().add((Object)this.t_text);
    }

    private void createDatatypeForeignId() throws Exception {
        this.t_foreignId = factory.createDatatypeDefinitionString();
        this.t_foreignId.setLongName("T_ForeignId");
        this.t_foreignId.setIdentifier("T_ForeignId");
        this.t_foreignId.setLastChange(DATE);
        this.t_foreignId.setMaxLength(BigInteger.valueOf(255L));
        this.getReqIF().getCoreContent().getDatatypes().add((Object)this.t_foreignId);
    }

    private void createDatatypeStatusOEM() throws Exception {
        this.t_statusOEM = factory.createDatatypeDefinitionEnumeration();
        this.t_statusOEM.setLongName("T_Status_OEM");
        this.t_statusOEM.setIdentifier("T_Status_OEM");
        this.t_statusOEM.setLastChange(DATE);
        this.addEnum(this.t_statusOEM, 10L, "Not to evaluate");
        this.addEnum(this.t_statusOEM, 11L, "To evaluate");
        this.addEnum(this.t_statusOEM, 12L, "Accepted");
        this.addEnum(this.t_statusOEM, 13L, "Not accepted");
        this.getReqIF().getCoreContent().getDatatypes().add((Object)this.t_statusOEM);
    }

    private void createDatatypeStatusSupplier() throws Exception {
        this.t_statusSupplier = factory.createDatatypeDefinitionEnumeration();
        this.t_statusSupplier.setLongName("T_Status_Supplier");
        this.t_statusSupplier.setIdentifier("T_Status_Supplier");
        this.t_statusSupplier.setLastChange(DATE);
        this.addEnum(this.t_statusSupplier, 20L, "To be clarified");
        this.addEnum(this.t_statusSupplier, 21L, "Agreed");
        this.addEnum(this.t_statusSupplier, 22L, "Not agreed");
        this.addEnum(this.t_statusSupplier, 23L, "Partly agreed");
        this.getReqIF().getCoreContent().getDatatypes().add((Object)this.t_statusSupplier);
    }

    private void createDatatypeVariant() throws Exception {
        this.t_variant = factory.createDatatypeDefinitionEnumeration();
        this.t_variant.setLongName("T_Variant");
        this.t_variant.setIdentifier("T_Variant");
        this.t_variant.setLastChange(DATE);
        this.addEnum(this.t_variant, 30L, "LO");
        this.addEnum(this.t_variant, 31L, "MID");
        this.addEnum(this.t_variant, 32L, "HI");
        this.getReqIF().getCoreContent().getDatatypes().add((Object)this.t_variant);
    }

    private void addEnum(DatatypeDefinitionEnumeration enumeration, long key, String value) {
        EnumValue enumValue = factory.createEnumValue();
        enumValue.setIdentifier("id-" + key);
        enumValue.setLongName(value);
        enumValue.setLastChange(DATE);
        EmbeddedValue embeddedValue = factory.createEmbeddedValue();
        embeddedValue.setKey(BigInteger.valueOf(key));
        embeddedValue.setOtherContent("otherContent-" + key);
        enumValue.setProperties(embeddedValue);
        enumeration.getSpecifiedValues().add((Object)enumValue);
    }

    private void createTextDefinition() {
        this.ad_text = factory.createAttributeDefinitionXHTML();
        this.ad_text.setLongName("ReqIF.Text");
        this.ad_text.setIdentifier("ReqIF.Text");
        this.ad_text.setLastChange(DATE);
        this.ad_text.setType(this.t_text);
        this.specObjecttype.getSpecAttributes().add((Object)this.ad_text);
    }

    private void createInternalDefinition() {
        this.ad_internal = factory.createAttributeDefinitionXHTML();
        this.ad_internal.setLongName("Internal Know-How");
        this.ad_internal.setIdentifier("InternalKnowHow");
        this.ad_internal.setLastChange(DATE);
        this.ad_internal.setType(this.t_text);
        this.specObjecttype.getSpecAttributes().add((Object)this.ad_internal);
    }

    private void createVariantDefinition() {
        this.ad_variant = factory.createAttributeDefinitionEnumeration();
        this.ad_variant.setLongName("Variant");
        this.ad_variant.setIdentifier("Variant");
        this.ad_variant.setLastChange(DATE);
        this.ad_variant.setType(this.t_variant);
        this.ad_variant.setMultiValued(true);
        this.specObjecttype.getSpecAttributes().add((Object)this.ad_variant);
    }

    private void createForeignIdDefinition() {
        this.ad_foreignId = factory.createAttributeDefinitionString();
        this.ad_foreignId.setLongName("ReqIF.ForeignID");
        this.ad_foreignId.setIdentifier("ReqIF.ForeignID");
        this.ad_foreignId.setLastChange(DATE);
        this.ad_foreignId.setType(this.t_foreignId);
        this.specObjecttype.getSpecAttributes().add((Object)this.ad_foreignId);
    }

    private void createSpecObjectTypes(ReqifTool tool) throws Exception {
        AttributeDefinitionEnumeration oem_status = factory.createAttributeDefinitionEnumeration();
        oem_status.setLastChange(DATE);
        oem_status.setIdentifier("oem-status-" + (Object)((Object)tool));
        oem_status.setLongName("OEM Status " + (Object)((Object)tool));
        oem_status.setType(this.t_statusOEM);
        oem_status.setMultiValued(false);
        this.specObjecttype.getSpecAttributes().add((Object)oem_status);
        this.ad_oemStatus.put(tool, oem_status);
        AttributeDefinitionXHTML oem_comment = factory.createAttributeDefinitionXHTML();
        oem_comment.setLastChange(DATE);
        oem_comment.setIdentifier("oem-comment-" + (Object)((Object)tool));
        oem_comment.setLongName("OEM Comment " + (Object)((Object)tool));
        oem_comment.setType(this.t_comment);
        this.specObjecttype.getSpecAttributes().add((Object)oem_comment);
        this.ad_oemComment.put(tool, oem_comment);
        AttributeDefinitionEnumeration supplier_status = factory.createAttributeDefinitionEnumeration();
        supplier_status.setLastChange(DATE);
        supplier_status.setIdentifier("supplier-status-" + (Object)((Object)tool));
        supplier_status.setLongName("Supplier Status " + (Object)((Object)tool));
        supplier_status.setType(this.t_statusSupplier);
        supplier_status.setMultiValued(false);
        this.specObjecttype.getSpecAttributes().add((Object)supplier_status);
        AttributeDefinitionXHTML supplier_comment = factory.createAttributeDefinitionXHTML();
        supplier_comment.setLastChange(DATE);
        supplier_comment.setIdentifier("supplier-comment-" + (Object)((Object)tool));
        supplier_comment.setLongName("Supplier Comment " + (Object)((Object)tool));
        supplier_comment.setType(this.t_comment);
        this.specObjecttype.getSpecAttributes().add((Object)supplier_comment);
    }

    @Override
    public void createSpecificationTypes() throws Exception {
        this.specType = factory.createSpecificationType();
        this.specType.setIdentifier("specType");
        this.specType.setLongName("specType");
        this.specType.setLastChange(DATE);
        this.getReqIF().getCoreContent().getSpecTypes().add((Object)this.specType);
    }
}

