/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.tests.reqif10.serialization.uc001.tc1300;

import java.io.IOException;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rmf.reqif10.AttributeValueXHTML;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.SpecRelation;
import org.eclipse.rmf.tests.reqif10.serialization.uc001.tc1300.TC1300SpecRelationModelBuilder;
import org.eclipse.rmf.tests.reqif10.serialization.util.AbstractTestCase;
import org.eclipse.rmf.tests.reqif10.serialization.util.CommonSystemAttributes;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TC1300SpecRelationTests
extends AbstractTestCase
implements CommonSystemAttributes {
    static final String TEST_CASE_ID = "TC1300";
    static final String REFERENCE_DATA_FILENAME = TC1300SpecRelationTests.getWorkingFileName(TC1300SpecRelationTests.getReferenceDataFileName("TC1300", false));
    static final String EXPORT_DATA_FILENAME = TC1300SpecRelationTests.getWorkingFileName(TC1300SpecRelationTests.getFirstExportFileName("TC1300", false));
    static ReqIF originalReqIF = null;
    static ReqIF loadedReqIF = null;

    @BeforeClass
    public static void setupOnce() throws Exception {
        AbstractTestCase.setupOnce();
        originalReqIF = new TC1300SpecRelationModelBuilder().getReqIF();
        TC1300SpecRelationTests.saveReqIFFile((EObject)originalReqIF, REFERENCE_DATA_FILENAME);
        loadedReqIF = TC1300SpecRelationTests.loadReqIFFile(REFERENCE_DATA_FILENAME);
    }

    @Test
    public void testSchemaCompliance() throws Exception {
        this.validateAgainstSchema(REFERENCE_DATA_FILENAME);
    }

    @Test
    public void testResave() throws IOException {
        try {
            TC1300SpecRelationTests.saveReqIFFile(EcoreUtil.copy((EObject)loadedReqIF), EXPORT_DATA_FILENAME);
        }
        catch (IOException ioe) {
            junit.framework.Assert.assertFalse((String)("We shall be able to save without exception. However the following exception occurred: " + ioe.toString()), (boolean)true);
        }
    }

    @Test
    public void testNoProxies() throws IOException {
        EcoreUtil.resolveAll((EObject)loadedReqIF);
        Map map = EcoreUtil.ProxyCrossReferencer.find((EObject)loadedReqIF);
        Assert.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void testSpecRelationHasName() throws IOException {
        SpecRelation specRelation = (SpecRelation)loadedReqIF.getCoreContent().getSpecRelations().get(0);
        Assert.assertNotNull((Object)specRelation.getType());
        Assert.assertEquals((long)1L, (long)specRelation.getValues().size());
        AttributeValueXHTML value = (AttributeValueXHTML)specRelation.getValues().get(0);
        Assert.assertEquals((Object)"ReqIF.Name", (Object)value.getDefinition().getLongName());
    }
}

